/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.swing;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.HashSet;
import java.util.PriorityQueue;

public abstract class FontUtil {
    private static final FontRenderContext FONT_RENDER_CONTEXT = new FontRenderContext(null, false, true);
    private static final String FONT_TEST_STRING = "The quick brown fox jumps over the lazy dog";
    public static final Font defaultFont = Font.decode(null);
    private static final FontExpressivenessComparator FONT_EXPRESSIVENESS_COMPARATOR = new FontExpressivenessComparator();
    private static DecimalFormat _fontSizeFormatter = new DecimalFormat("#.##");

    private static boolean isLogicalFontFamily(String string) {
        return "Dialog".equals(string) || "DialogInput".equals(string) || "SansSerif".equals(string) || "Serif".equals(string) || "Monospaced".equals(string);
    }

    public static Font getPhysicalFont(Font font, String string) {
        Font[] fontArray;
        String string2 = font.getFamily();
        if (!FontUtil.isLogicalFontFamily(string2)) {
            return font;
        }
        TextLayout textLayout = new TextLayout(string, font, FONT_RENDER_CONTEXT);
        PriorityQueue<Font> priorityQueue = new PriorityQueue<Font>(1, FONT_EXPRESSIVENESS_COMPARATOR);
        for (Font font2 : fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            TextLayout textLayout2;
            String string3 = font2.getFamily();
            if (FontUtil.isLogicalFontFamily(string3) || !(textLayout2 = new TextLayout(string, font2 = font2.deriveFont(font.getStyle(), font.getSize2D()), FONT_RENDER_CONTEXT)).getBounds().equals(textLayout.getBounds()) || textLayout2.getAscent() != textLayout.getAscent() || textLayout2.getDescent() != textLayout.getDescent() || textLayout2.getLeading() != textLayout.getLeading() || textLayout2.getAdvance() != textLayout.getAdvance() || textLayout2.getVisibleAdvance() != textLayout.getVisibleAdvance()) continue;
            priorityQueue.add(font2);
        }
        if (priorityQueue.isEmpty()) {
            return font;
        }
        return (Font)priorityQueue.poll();
    }

    public static Font getPhysicalFont(Font font) {
        return FontUtil.getPhysicalFont(font, FONT_TEST_STRING);
    }

    public static String encode(Font font) {
        String string = font.isBold() ? (font.isItalic() ? "bolditalic" : "bold") : (font.isItalic() ? "italic" : "plain");
        float f = font.getSize2D();
        return font.getFamily() + "-" + string + "-" + (f == (float)((int)f) ? Integer.toString((int)f) : _fontSizeFormatter.format(font));
    }

    private static class FontExpressivenessComparator
    implements Comparator<Font> {
        private static final int[] STYLES = new int[]{0, 2, 1, 3};

        private FontExpressivenessComparator() {
        }

        @Override
        public int compare(Font font, Font font2) {
            if (font == font2) {
                return 0;
            }
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            for (int n : STYLES) {
                hashSet.add(font.deriveFont(n).getPSName());
                hashSet2.add(font2.deriveFont(n).getPSName());
            }
            if (hashSet.size() < hashSet2.size()) {
                return 1;
            }
            if (hashSet.size() > hashSet2.size()) {
                return -1;
            }
            return font.getName().compareTo(font2.getName());
        }
    }
}

