/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Filter<T> {
    public abstract boolean passes(T var1);

    public Iterator<T> filter(Iterator<T> iterator) {
        return new FilterIterator(iterator);
    }

    public Iterable<T> filter(final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Filter.this.filter(iterable.iterator());
            }
        };
    }

    private class FilterIterator
    implements Iterator<T> {
        private static final int ITERATING = 0;
        private static final int AWAITING_CONSUMER = 1;
        private static final int AT_END = -1;
        private int state = 0;
        private Iterator<T> iterator;
        private T foundItem;

        private FilterIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.state != -1 && this.moveToNext();
        }

        @Override
        public T next() {
            this.moveToNext();
            if (this.state == 1) {
                this.state = 0;
            }
            return this.foundItem;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean moveToNext() {
            switch (this.state) {
                case 0: {
                    while (this.iterator.hasNext()) {
                        Object t = this.iterator.next();
                        if (!Filter.this.passes(t)) continue;
                        this.foundItem = t;
                        this.state = 1;
                        return true;
                    }
                    this.state = -1;
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            throw new NoSuchElementException();
        }
    }
}

