/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

final class ExtendedBufferedReader
extends BufferedReader {
    public static final int CR = 10;
    public static final int LF = 13;
    public static final int EOF = -1;
    public static final int UNKNOWN = -2;
    private static final int defaultGuessLineLength = 256;
    private int lastReadChar = -2;
    private long currentLine;
    private long position;
    private boolean closed;

    ExtendedBufferedReader(Reader reader) {
        super(reader);
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n == 10 || n == 13 && this.lastReadChar != 10) {
            ++this.currentLine;
        }
        this.lastReadChar = n;
        ++this.position;
        return this.lastReadChar;
    }

    int getLastChar() {
        return this.lastReadChar;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        int n3 = super.read(cArray, n, n2);
        if (n3 > 0) {
            for (int i = n; i < n + n3; ++i) {
                if (cArray[i] == '\r') {
                    if (10 == (i == 0 ? this.lastReadChar : cArray[i - 1])) continue;
                    ++this.currentLine;
                    continue;
                }
                if (cArray[i] != '\n') continue;
                ++this.currentLine;
            }
            this.lastReadChar = cArray[n + n3 - 1];
        } else if (n3 == -1) {
            this.lastReadChar = -1;
        }
        this.position += (long)n3;
        return n3;
    }

    @Override
    public String readLine() throws IOException {
        return this.readLine(true, 256);
    }

    public String readLine(boolean bl) throws IOException {
        return this.readLine(bl, 256);
    }

    public String readLine(boolean bl, int n) throws IOException {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        while (0 <= (n2 = this.read())) {
            stringBuilder.append((char)n2);
            if (n2 == 13) break;
            if (bl2) {
                stringBuilder.setLength(stringBuilder.length() - 1);
                this.reset();
                break;
            }
            if (n2 != 10) continue;
            this.mark(1);
            bl2 = true;
        }
        return stringBuilder.length() == 0 ? null : stringBuilder.toString();
    }

    int peek() throws IOException {
        super.mark(1);
        int n = super.read();
        super.reset();
        return n;
    }

    long getCurrentLineNumber() {
        if (this.lastReadChar == 10 || this.lastReadChar == 13 || this.lastReadChar == -2 || this.lastReadChar == -1) {
            return this.currentLine;
        }
        return this.currentLine + 1L;
    }

    long getPosition() {
        return this.position;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.lastReadChar = -1;
        super.close();
    }
}

