/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.awt.Color;
import java.awt.Font;
import java.util.Optional;
import ur_rna.Utilities.Colors;
import ur_rna.Utilities.annotation.NotNull;
import ur_rna.Utilities.swing.FontUtil;

public class Convert {
    private Convert() {
    }

    public static boolean toBool(Object object, boolean bl) {
        if (object == null || object.equals("")) {
            return bl;
        }
        return Convert.toBool(object);
    }

    public static boolean toBool(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() == 0.0;
        }
        if (object instanceof String) {
            return Convert.toBool((String)object);
        }
        if (object instanceof Void) {
            return false;
        }
        if (object instanceof Optional) {
            return ((Optional)object).isPresent();
        }
        return true;
    }

    public static boolean toBool(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return !(string = string.toUpperCase()).equals("F") && !string.equals("FALSE") && !string.equals("NO") && !string.equals("0");
    }

    public static int toInt(Object object) {
        return Convert.toInt(object, 0, false);
    }

    public static int toInt(Object object, int n) {
        return Convert.toInt(object, n, false);
    }

    public static int toInt(Object object, int n, boolean bl) {
        if (object == null) {
            return n;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            try {
                return object.equals("") ? n : Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                if (bl) {
                    throw numberFormatException;
                }
                return n;
            }
        }
        if (object instanceof Color) {
            return ((Color)object).getRGB();
        }
        if (bl) {
            throw Convert.createConvertException(object, Integer.class);
        }
        return n;
    }

    public static float toFloat(Object object) {
        return Convert.toFloat(object, 0.0f, false);
    }

    public static float toFloat(Object object, float f) {
        return Convert.toFloat(object, f, false);
    }

    public static float toFloat(Object object, float f, boolean bl) {
        if (object == null) {
            return f;
        }
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        if (object instanceof String) {
            try {
                return object.equals("") ? f : Float.parseFloat((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                if (bl) {
                    throw numberFormatException;
                }
                return f;
            }
        }
        if (bl) {
            throw Convert.createConvertException(object, Float.class);
        }
        return f;
    }

    public static double toDouble(Object object) {
        return Convert.toDouble(object, 0.0, false);
    }

    public static double toDouble(Object object, double d) {
        return Convert.toDouble(object, d, false);
    }

    public static double toDouble(Object object, double d, boolean bl) {
        if (object == null) {
            return d;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            try {
                return object.equals("") ? d : Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                if (bl) {
                    throw numberFormatException;
                }
                return d;
            }
        }
        if (bl) {
            throw Convert.createConvertException(object, Double.class);
        }
        return d;
    }

    public static char toChar(Object object) {
        return Convert.toChar(object, '\u0000', false);
    }

    public static char toChar(Object object, char c) {
        return Convert.toChar(object, c, false);
    }

    public static char toChar(Object object, char c, boolean bl) {
        if (object == null) {
            return c;
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (object instanceof Number) {
            return (char)((Number)object).intValue();
        }
        if (object instanceof String) {
            return object.equals("") ? c : ((String)object).charAt(0);
        }
        if (bl) {
            throw Convert.createConvertException(object, Character.class);
        }
        return c;
    }

    public static String toString(Object object) {
        return Convert.toString(object, null);
    }

    public static String toString(Object object, String string) {
        if (object == null) {
            return string;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Color) {
            return Colors.getName((Color)object);
        }
        if (object instanceof Font) {
            return FontUtil.encode((Font)object);
        }
        return object.toString();
    }

    public static Object toType(Object object, Class clazz) {
        if (object != null && object.getClass() == clazz) {
            return object;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return Convert.toInt(object);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.valueOf(Convert.toFloat(object));
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return Convert.toDouble(object);
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return Character.valueOf(Convert.toChar(object));
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return Convert.toBool(object);
        }
        if (clazz == String.class) {
            return Convert.toString(object);
        }
        if (clazz == Font.class) {
            return Convert.toFont(object);
        }
        if (clazz == Color.class) {
            return Convert.toColor(object);
        }
        throw Convert.createConvertException(object, clazz);
    }

    public static <T> T toType(Object object, @NotNull T t) {
        if (t instanceof Integer) {
            return (T)Integer.valueOf(Convert.toInt(object, (Integer)t));
        }
        if (t instanceof Float) {
            return (T)Float.valueOf(Convert.toFloat(object));
        }
        if (t instanceof Double) {
            return (T)Double.valueOf(Convert.toDouble(object));
        }
        if (t instanceof Character) {
            return (T)Character.valueOf(Convert.toChar(object));
        }
        if (t instanceof Boolean) {
            return (T)Boolean.valueOf(Convert.toBool(object));
        }
        if (t instanceof String) {
            return (T)Convert.toString(object);
        }
        throw Convert.createConvertException(object, t.getClass());
    }

    protected static RuntimeException createConvertException(Object object, Class clazz) {
        return new RuntimeException(String.format("Unable to convert from %s to %s.", object == null ? "NULL" : object.getClass().getSimpleName(), clazz.getSimpleName()));
    }

    public static String globToRegex(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        char[] cArray = string.toCharArray();
        block16: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\\': {
                    if (++i >= cArray.length) {
                        stringBuilder.append('\\');
                        continue block16;
                    }
                    char c2 = cArray[i];
                    switch (c2) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            stringBuilder.append('\\');
                        }
                        default: {
                            stringBuilder.append('\\');
                        }
                    }
                    stringBuilder.append(c2);
                    continue block16;
                }
                case '*': {
                    if (n2 == 0) {
                        stringBuilder.append(".*");
                        continue block16;
                    }
                    stringBuilder.append('*');
                    continue block16;
                }
                case '?': {
                    if (n2 == 0) {
                        stringBuilder.append('.');
                        continue block16;
                    }
                    stringBuilder.append('?');
                    continue block16;
                }
                case '[': {
                    ++n2;
                    n3 = i + 1;
                    stringBuilder.append('[');
                    continue block16;
                }
                case ']': {
                    --n2;
                    stringBuilder.append(']');
                    continue block16;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (n2 == 0 || n3 == i && c == '^') {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(c);
                    continue block16;
                }
                case '!': {
                    if (n3 == i) {
                        stringBuilder.append('^');
                        continue block16;
                    }
                    stringBuilder.append('!');
                    continue block16;
                }
                case '{': {
                    ++n;
                    stringBuilder.append('(');
                    continue block16;
                }
                case '}': {
                    --n;
                    stringBuilder.append(')');
                    continue block16;
                }
                case ',': {
                    if (n > 0) {
                        stringBuilder.append('|');
                        continue block16;
                    }
                    stringBuilder.append(',');
                    continue block16;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static Font toFont(Object object) {
        return Convert.toFont(object, null, false);
    }

    public static Font toFont(Object object, Font font) {
        return Convert.toFont(object, font, false);
    }

    public static Font toFont(Object object, Font font, boolean bl) {
        if (object == null) {
            return font;
        }
        if (object instanceof Font) {
            return (Font)object;
        }
        if (object instanceof String) {
            return Font.decode((String)object);
        }
        if (object instanceof Number) {
            return FontUtil.defaultFont.deriveFont(((Number)object).floatValue());
        }
        if (bl) {
            throw Convert.createConvertException(object, Font.class);
        }
        return font;
    }

    public static Color toColor(Object object) {
        return Convert.toColor(object, null, false);
    }

    public static Color toColor(Object object, Color color) {
        return Convert.toColor(object, color, false);
    }

    public static Color toColor(Object object, Color color, boolean bl) {
        if (object == null) {
            return color;
        }
        if (object instanceof Color) {
            return (Color)object;
        }
        if (object instanceof String) {
            Color color2 = Colors.getColor((String)object);
            return color2 == null ? color : color2;
        }
        if (object instanceof Number) {
            int n;
            return new Color(n, (long)(n = ((Number)object).intValue()) > 0xFFFFFFL || n < 0);
        }
        if (bl) {
            throw Convert.createConvertException(object, Color.class);
        }
        return color;
    }
}

