/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import ur_rna.Utilities.AppInfo;
import ur_rna.Utilities.Convert;
import ur_rna.Utilities.NullPrintStream;
import ur_rna.Utilities.ObjTools;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.Verbosity;

public class AppLog {
    protected static PrintStream nullStream = new NullPrintStream();
    public static Verbosity DefaultLogImportance = Verbosity.Info;
    private static AppLog defaultAppLog;
    private PrintStream[] streams = new PrintStream[]{nullStream, System.err, System.err, System.out, System.out, System.out};
    private boolean[] forceEnabled = new boolean[ObjTools.max(Verbosity.values(), verbosity -> verbosity.importance) + 1];
    private HashMap<File, PrintStream> _customStreams = new HashMap();
    protected Verbosity _requiredVerbosity = Verbosity.Info;

    public static AppLog getDefault() {
        if (defaultAppLog == null) {
            defaultAppLog = new AppLog();
        }
        return defaultAppLog;
    }

    public static void setDefault(AppLog appLog) {
        defaultAppLog = appLog;
    }

    public static String getSysProp(String ... stringArray) {
        if (stringArray.length == 1) {
            return AppLog.getSysProp(stringArray[0]);
        }
        for (String string : stringArray) {
            String string2 = AppLog.getSysProp(string);
            if (string == null) continue;
            return string2;
        }
        return null;
    }

    public static String getSysProp(String string) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        string2 = System.getenv(string);
        if (string2 != null) {
            return string2;
        }
        String string3 = AppInfo.getAppName().toLowerCase() + "_";
        string2 = System.getenv(string3 + string);
        if (string2 != null) {
            return string2;
        }
        if (string.indexOf(45) != -1) {
            string2 = System.getenv(string = string.replace('-', '_'));
            if (string2 != null) {
                return string2;
            }
            string2 = System.getenv(string3 + string);
            if (string2 != null) {
                return string2;
            }
        }
        if ((string2 = System.getenv(string.toLowerCase())) != null) {
            return string2;
        }
        string2 = System.getenv(string.toUpperCase());
        if (string2 != null) {
            return string2;
        }
        string2 = System.getenv((string3 + string).toLowerCase());
        if (string2 != null) {
            return string2;
        }
        string2 = System.getenv((string3 + string).toUpperCase());
        return string2;
    }

    public void readSystemProperties() {
        String string = AppLog.getSysProp("log-verbose", "verbose", "log-verbosity", "verbosity");
        if (string != null) {
            this.setVerbosity(Convert.toInt(string, AppLog.DefaultLogImportance.importance));
        }
        PrintStream printStream = null != (string = AppLog.getSysProp("log-out-file")) ? this.getCustomStream(string) : null;
        string = AppLog.getSysProp("log-err-file");
        PrintStream printStream2 = null != string ? this.getCustomStream(string) : null;
        for (Verbosity verbosity : Verbosity.values()) {
            string = AppLog.getSysProp("log-" + verbosity.name().toLowerCase());
            if (string != null) {
                this.setEnabledSpecial(verbosity, Strings.asBool(string));
            }
            if ((string = AppLog.getSysProp("log-" + verbosity.name().toLowerCase() + "-file")) != null) {
                this.setStream(verbosity, this.getCustomStream(string));
            }
            if (printStream != null && this.getStream(verbosity) == System.out) {
                this.setStream(verbosity, printStream);
            }
            if (printStream2 == null || this.getStream(verbosity) != System.err) continue;
            this.setStream(verbosity, printStream2);
        }
    }

    private PrintStream getCustomStream(String string) {
        switch (string) {
            case "!null": 
            case "!close": 
            case "!none": 
            case "!silent": {
                return nullStream;
            }
            case "!out": 
            case "stdout": {
                return System.out;
            }
            case "!err": 
            case "stderr": {
                return System.err;
            }
        }
        try {
            File file = new File(string).getCanonicalFile();
            PrintStream printStream = this._customStreams.get(file);
            if (printStream == null) {
                printStream = new PrintStream((OutputStream)new FileOutputStream(file, true), true, "UTF-8");
                this._customStreams.put(file, printStream);
            }
            return printStream;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return System.out;
        }
    }

    public boolean isTraceEnabled() {
        return this.isEnabled(Verbosity.Trace);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(Verbosity.Debug);
    }

    public boolean isEnabled(Verbosity verbosity) {
        return verbosity.importance <= this._requiredVerbosity.importance || this.forceEnabled[verbosity.importance];
    }

    public boolean isEnabled(int n) {
        return n <= this._requiredVerbosity.importance || this.forceEnabled[n];
    }

    public boolean isEnabledSpecial(Verbosity verbosity) {
        return this.forceEnabled[verbosity.importance];
    }

    public void setEnabledSpecial(Verbosity verbosity, boolean bl) {
        this.forceEnabled[verbosity.importance] = bl;
    }

    public Verbosity getVerbosity() {
        return this._requiredVerbosity;
    }

    public void setVerbosity(int n) throws IllegalArgumentException {
        this._requiredVerbosity = Verbosity.fromImportance(n);
    }

    public void setVerbosity(Verbosity verbosity) throws IllegalArgumentException {
        this.getStream(verbosity);
        this._requiredVerbosity = verbosity;
    }

    public void log(String string) {
        this.log(string, DefaultLogImportance);
    }

    public void log(String string, Object ... objectArray) {
        this.logFmt(string, DefaultLogImportance, objectArray);
    }

    private void logFmt(String string, Verbosity verbosity, Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            this.log(string, verbosity);
        } else {
            this.log(String.format(string, objectArray), verbosity);
        }
    }

    public void log(String string, Verbosity verbosity) {
        try {
            this.getStream(verbosity).println(string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            System.err.println(string);
        }
    }

    public PrintStream getStream(Verbosity verbosity) {
        int n = verbosity.importance;
        if (n < 0 || n >= this.streams.length) {
            throw new InternalError("Invalid log type: " + n);
        }
        return this.isEnabled(n) ? this.streams[n] : nullStream;
    }

    public void setStream(Verbosity verbosity, PrintStream printStream) {
        this.streams[verbosity.importance] = printStream;
    }

    public PrintStream getDbgStream() {
        return this.getStream(Verbosity.Debug);
    }

    public PrintStream getErrStream() {
        return this.getStream(Verbosity.Error);
    }

    public PrintStream getTrStream() {
        return this.getStream(Verbosity.Trace);
    }

    public void trace(String string) {
        this.log(string, Verbosity.Trace);
    }

    public void debug(String string) {
        this.log(string, Verbosity.Debug);
    }

    public void info(String string) {
        this.log(string, Verbosity.Info);
    }

    public void warn(String string) {
        this.log(string, Verbosity.Warn);
    }

    public void error(String string) {
        this.log(string, Verbosity.Error);
    }

    public void trace(String string, Object ... objectArray) {
        this.logFmt(string, Verbosity.Trace, objectArray);
    }

    public void debug(String string, Object ... objectArray) {
        this.logFmt(string, Verbosity.Debug, objectArray);
    }

    public void info(String string, Object ... objectArray) {
        this.logFmt(string, Verbosity.Info, objectArray);
    }

    public void warn(String string, Object ... objectArray) {
        this.logFmt(string, Verbosity.Warn, objectArray);
    }

    public void error(String string, Object ... objectArray) {
        this.logFmt(string, Verbosity.Error, objectArray);
    }

    public void error(String string, Throwable throwable) {
        this.log(string, Verbosity.Error);
        this.log(AppLog.getErrorInfo(throwable), Verbosity.Error);
    }

    public static String getErrorInfo(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

