/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JPanel;
import ur_rna.RNAstructureUI.ui.BorderBuilder;
import ur_rna.RNAstructureUI.ui.FieldPanel;
import ur_rna.RNAstructureUI.ui.NumberField;
import ur_rna.RNAstructureUI.ui.RadioButtonPanel;
import ur_rna.RNAstructureUI.windows.DrawingWindow;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.MultiWindow;

public class TurboFoldWindow
extends MultiWindow {
    private static final long serialVersionUID = 20120802L;
    private CardLayout cards;
    private static final String[] modeNames = new String[]{"Maximum Expected Accuracy", "ProbKnot/TurboKnot", "Probability Threshold"};
    private JPanel specificPanel;

    public TurboFoldWindow() {
        super("RNA", "TurboFold");
    }

    @Override
    protected void activate() {
        this.backend.activateTurboFold();
    }

    @Override
    protected void addBackendTuple(String string, String string2) {
        this.backend.addTurboFoldTuple(string, string2);
    }

    @Override
    protected void buildSpecificOptionsPanel() {
        BorderBuilder borderBuilder = new BorderBuilder();
        RadioButtonPanel radioButtonPanel = RadioButtonPanel.makeVertical("Mode", this, modeNames);
        NumberField.DoubleField doubleField = new NumberField.DoubleField("Gamma", 0.3);
        NumberField.IntegerField integerField = new NumberField.IntegerField("Iterations", 3, (Integer)1);
        FieldPanel fieldPanel = new FieldPanel(doubleField, integerField);
        fieldPanel.setPanelWidth(350);
        fieldPanel.makePanel();
        borderBuilder.makeTitledBorder("General Options", fieldPanel);
        NumberField.DoubleField doubleField2 = new NumberField.DoubleField("Max % Score Difference", 50.0, 0.0, 99.0);
        NumberField.IntegerField integerField2 = new NumberField.IntegerField("Max Number of Structures", 1000, (Integer)1);
        NumberField.IntegerField integerField3 = new NumberField.IntegerField("Window Size", 5, (Integer)0);
        NumberField.DoubleField doubleField3 = new NumberField.DoubleField("MEA Gamma", (Number)1);
        FieldPanel fieldPanel2 = new FieldPanel(doubleField2, integerField2, integerField3, doubleField3);
        fieldPanel2.setPanelWidth(350);
        fieldPanel2.makePanel();
        Box box = Box.createVerticalBox();
        box.add(fieldPanel2);
        box.add(Box.createVerticalStrut(350));
        NumberField.IntegerField integerField4 = new NumberField.IntegerField("Pseudoknot Iterations", 1, (Integer)1);
        NumberField.IntegerField integerField5 = new NumberField.IntegerField("Minimum Helix Length", 3, (Integer)1);
        FieldPanel fieldPanel3 = new FieldPanel(integerField4, integerField5);
        fieldPanel3.setPanelWidth(350);
        fieldPanel3.makePanel();
        Box box2 = Box.createVerticalBox();
        box2.add(fieldPanel3);
        box2.add(Box.createVerticalStrut(350));
        NumberField.DoubleField doubleField4 = new NumberField.DoubleField("Threshold", 0, 0, 99);
        FieldPanel fieldPanel4 = new FieldPanel(doubleField4);
        fieldPanel4.setPanelWidth(350);
        fieldPanel4.makePanel();
        Box box3 = Box.createVerticalBox();
        box3.add(fieldPanel4);
        box3.add(Box.createVerticalStrut(350));
        this.cards = new CardLayout();
        this.specificPanel = new JPanel(this.cards);
        this.specificPanel.add((Component)box, modeNames[0]);
        this.specificPanel.add((Component)box2, modeNames[1]);
        this.specificPanel.add((Component)box3, modeNames[2]);
        this.cards.show(this.specificPanel, modeNames[0]);
        this.options.add(fieldPanel);
        this.options.add(radioButtonPanel);
        this.options.add(this.specificPanel);
        borderBuilder.makeLeftBorder(10, this.options);
    }

    @Override
    protected void deleteBackendTuple(int n) {
        this.backend.deleteTurboFoldTuple(n);
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        for (String string : modeNames) {
            if (!commandInfo.command.equals(string)) continue;
            this.cards.show(this.specificPanel, string);
            return;
        }
        super.processCommand(commandInfo);
    }

    @Override
    protected int getNumSequences() {
        return this.backend.getNumTurboFoldSequences();
    }

    @Override
    protected String getSequenceSetAsString() {
        return this.backend.getTurboFoldSequenceSetData();
    }

    @Override
    protected boolean runMainCalculationMultipleSequences() {
        Object object;
        Box box;
        this.showProgress(false);
        JPanel jPanel = (JPanel)this.getInputControl(this.options, 3);
        RadioButtonPanel radioButtonPanel = (RadioButtonPanel)this.getInputControl(this.options, 2);
        String string = radioButtonPanel.getSelectedName();
        String string2 = "";
        FieldPanel fieldPanel = (FieldPanel)this.getInputControl(this.options, 1);
        double d = ((NumberField.DoubleField)fieldPanel.getField(1)).getValue();
        int n = ((NumberField.IntegerField)fieldPanel.getField(2)).getValue();
        if (string.equals("Maximum Expected Accuracy")) {
            box = (Box)this.getInputControl(jPanel, 1);
            object = (FieldPanel)this.getInputControl(box, 1);
            double d2 = ((NumberField.DoubleField)((FieldPanel)object).getField(1)).getValue();
            int n2 = ((NumberField.IntegerField)((FieldPanel)object).getField(2)).getValue();
            int n3 = ((NumberField.IntegerField)((FieldPanel)object).getField(3)).getValue();
            double d3 = ((NumberField.DoubleField)((FieldPanel)object).getField(4)).getValue();
            string2 = this.backend.runTurboFoldMaximumExpectedAccuracy(d, n, d2, n2, n3, d3);
        } else if (string.equals("ProbKnot/TurboKnot")) {
            box = (Box)this.getInputControl(jPanel, 2);
            object = (FieldPanel)this.getInputControl(box, 1);
            int n4 = ((NumberField.IntegerField)((FieldPanel)object).getField(1)).getValue();
            int n5 = ((NumberField.IntegerField)((FieldPanel)object).getField(2)).getValue();
            string2 = this.backend.runTurboFoldPseudoknot(d, n, n4, n5);
        } else if (string.equals("Probability Threshold")) {
            box = (Box)this.getInputControl(jPanel, 3);
            object = (FieldPanel)this.getInputControl(box, 1);
            Double d4 = ((NumberField.DoubleField)((FieldPanel)object).getField(1)).getValue();
            string2 = this.backend.runTurboFoldThreshold(d, n, d4);
        }
        this.displayCalcError(string2);
        if (!string2.equals("")) {
            return false;
        }
        if (!TurboFoldWindow.promptDraw("Do you want to draw\nstructures and dot plots?", null)) {
            return true;
        }
        this.showDrawProgress();
        for (int i = 1; i <= this.getNumSequences(); ++i) {
            object = this.backend.getTurboFoldCT(i);
            this.imageDialogs.add(new DrawingWindow((String)object));
            String string3 = this.backend.getTurboFoldSaveFile(i);
            this.imageDialogs.add(new DrawingWindow(string3));
        }
        this.showImageDialogs();
        return true;
    }
}

