/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import ur_rna.RNAstructureUI.ui.FieldPanel;
import ur_rna.RNAstructureUI.ui.FileField;
import ur_rna.RNAstructureUI.ui.NumberField;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.windows.DrawingWindow;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.ModuleWindow;
import ur_rna.Utilities.swing.MergeMenu;

public class ProbKnotWindow
extends ModuleWindow {
    private static final long serialVersionUID = 20120802L;

    public ProbKnotWindow(String string) {
        super(string, "Identify Pseudoknots");
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        if (commandInfo.command.equals("CT File")) {
            int n = 2;
            String string = StandardFileChooser.getSaveName(FileFilters.CT, filePanel.getFile(n));
            if (string != null) {
                filePanel.setFile(n, string);
            }
        } else if (commandInfo.command.equals("Partition Function Save File")) {
            String string = StandardFileChooser.getOpenName(FileFilters.PartitionSav);
            if (string == null) {
                return;
            }
            String string2 = this.backend.buildProbKnotDataStructure(string);
            if (!this.verifyBackendResult(string2, "File: %s", string)) {
                return;
            }
            String string3 = ProbKnotWindow.getOutputFile(string, "ct");
            filePanel.setFile(1, string);
            filePanel.setFile(2, string3);
            this.getCustomMenus().enableMenus();
        } else {
            super.processCommand(commandInfo);
        }
    }

    @Override
    protected void makeInputControls() {
        FileField fileField = FileField.createDisabled("Partition Function Save File").inputFile(FileFilters.PartitionSav);
        FileField fileField2 = FileField.createEnabled("CT File").outputFile(FileFilters.CT);
        FieldPanel.FilePanel filePanel = new FieldPanel.FilePanel(this, fileField, fileField2);
        filePanel.setPanelWidth(600);
        filePanel.makePanel();
        NumberField.IntegerField integerField = new NumberField.IntegerField("Iterations", 1, (Integer)1);
        NumberField.IntegerField integerField2 = new NumberField.IntegerField("Minimum Helix Length", 3, (Integer)1);
        FieldPanel fieldPanel = new FieldPanel(integerField, integerField2);
        fieldPanel.setPanelWidth(350);
        fieldPanel.makePanel();
        this.setGrid(2, 1);
        this.setFillHorizontal();
        this.placeComponent(0, 0, filePanel);
        this.setGrid(1, 1);
        this.placeComponent(0, 1, fieldPanel);
        this.makeStartButton(1, 1);
    }

    @Override
    protected boolean runMainCalculation() {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        FieldPanel fieldPanel = (FieldPanel)this.getInputControl(2);
        filePanel.saveRecent();
        filePanel.getFile(1);
        String string = filePanel.getFile(2);
        if (filePanel.isError()) {
            return false;
        }
        Integer n = ((NumberField.IntegerField)fieldPanel.getField(1)).getValue();
        Integer n2 = ((NumberField.IntegerField)fieldPanel.getField(2)).getValue();
        this.showProgress(false);
        String string2 = this.backend.runPseudoknotPrediction(string, n, n2);
        this.displayCalcError(string2);
        if (!string2.equals("")) {
            return false;
        }
        if (ProbKnotWindow.promptDraw()) {
            DrawingWindow drawingWindow = new DrawingWindow(string);
            if (drawingWindow.isError()) {
                return false;
            }
            drawingWindow.showWindow();
        }
        return true;
    }

    @Override
    protected MergeMenu[] createCustomMenus() {
        return null;
    }
}

