/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.Utilities.swing.JActionLabel;

public class PredictionResultsWindow
extends InternalWindow {
    private JPanel pnlFiles;
    private JLabel lblResults;
    private JButton btnClose;
    private JPanel pnlDrawings;
    private JPanel pnlContent;
    private JLabel lblFile;
    private JButton btnShowAbbreviations;
    private JPanel pnlClient = new JPanel();
    private HashMap<JButton, PlotResult> plotResults = new HashMap();
    int fileCount;
    int plotRow = -1;
    int plotCol;
    private final Font headerFont;

    public PredictionResultsWindow() {
        this(null);
    }

    public PredictionResultsWindow(String string) {
        this.$$$setupUI$$$();
        this.headerFont = new Font("Arial", 1, 12);
        if (string != null) {
            this.setCaption(string);
        }
        this.pnlFiles.removeAll();
        this.pnlDrawings.removeAll();
        this.btnClose.addActionListener(actionEvent -> this.dispose());
        this.btnShowAbbreviations.addActionListener(actionEvent -> this.showAbbreviations());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlClient, gridBagConstraints);
        this.pnlClient.setLayout(new GridBagLayout());
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.pnlClient.add((Component)this.pnlContent, gridBagConstraints);
        this.setPreferredSize(new Dimension(700, 600));
        this.pack();
    }

    private void $$$setupUI$$$() {
        this.pnlContent = new JPanel();
        this.pnlContent.setLayout(new GridBagLayout());
        this.pnlContent.setPreferredSize(new Dimension(700, 500));
        JLabel jLabel = new JLabel();
        jLabel.setFont(new Font(jLabel.getFont().getName(), 1, 14));
        jLabel.setText("Results of Structure Prediction Calculation");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        this.pnlContent.add((Component)jLabel, gridBagConstraints);
        this.lblResults = new JLabel();
        this.lblResults.setText("Structure Prediction completed successfully and the following files were produced:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.pnlContent.add((Component)this.lblResults, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("<html>Additionally, the following <b>drawings and plots</b> can be produced with the results:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.pnlContent.add((Component)jLabel2, gridBagConstraints);
        this.pnlDrawings = new JPanel();
        this.pnlDrawings.setLayout(new GridBagLayout());
        this.pnlDrawings.setAutoscrolls(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.pnlContent.add((Component)this.pnlDrawings, gridBagConstraints);
        JButton jButton = new JButton();
        jButton.setText("MFE (Fold) Structure + Probabilities");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.pnlDrawings.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton();
        jButton2.setText("MFE (Fold) Structure + Probabilities");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.pnlDrawings.add((Component)jButton2, gridBagConstraints);
        JButton jButton3 = new JButton();
        jButton3.setText("MFE (Fold) Structure + Probabilities");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.pnlDrawings.add((Component)jButton3, gridBagConstraints);
        this.btnClose = new JButton();
        this.btnClose.setText("Close    (Done Generating Drawings)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.pnlContent.add((Component)this.btnClose, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("The drawings listed above can only be automatically generated while this window is open.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.pnlContent.add((Component)jLabel3, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("<html>Once you close it, you can make similar drawings using the <b> Draw </b> and <b> Draw Dot Plot </b> commands on the <b> File </b> menu. SHAPE or Probability colorization can be added to structures using the <b> Annotations </b> menu.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.pnlContent.add((Component)jLabel4, gridBagConstraints);
        this.btnShowAbbreviations = new JButton();
        this.btnShowAbbreviations.setText("Abbreviations...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.pnlContent.add((Component)this.btnShowAbbreviations, gridBagConstraints);
        this.pnlFiles = new JPanel();
        this.pnlFiles.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        this.pnlContent.add((Component)this.pnlFiles, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("<FILE>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 3, 2, 4);
        this.pnlFiles.add((Component)jLabel5, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("<DESCRIPTION>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 3, 2, 4);
        this.pnlFiles.add((Component)jLabel6, gridBagConstraints);
        this.lblFile = new JLabel();
        this.lblFile.setFont(new Font(this.lblFile.getFont().getName(), 1, this.lblFile.getFont().getSize()));
        this.lblFile.setForeground(new Color(-14667710));
        this.lblFile.setText("p450_MaxExpect.ct");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 3, 2, 4);
        this.pnlFiles.add((Component)this.lblFile, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("MEA structure prediction");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 3, 2, 4);
        this.pnlFiles.add((Component)jLabel7, gridBagConstraints);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.pnlContent;
    }

    public void addFile(String string, String string2) {
        File file = new File(string);
        JActionLabel jActionLabel = new JActionLabel(file.getName(), string);
        jActionLabel.setFont(this.lblFile.getFont());
        jActionLabel.setForeground(this.lblFile.getForeground());
        jActionLabel.setToolTipText(file.toString());
        jActionLabel.addActionListener(this::browseFile);
        JLabel jLabel = new JLabel(string2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.fileCount++;
        gridBagConstraints.insets = new Insets(2, 3, 2, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        this.pnlFiles.add((Component)jActionLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        this.pnlFiles.add((Component)jLabel, gridBagConstraints);
    }

    private void browseFile(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        File file = new File(string).getParentFile();
        if (file.exists()) {
            try {
                Desktop.getDesktop().open(file);
            }
            catch (IOException iOException) {
                Dialogs.showError("The location could not be opened: " + iOException.toString());
            }
        }
    }

    public void addPlot(String string, String string2, Supplier<InternalWindow> supplier) {
        if (this.plotRow == -1) {
            this.plotRow = 0;
        }
        PlotResult plotResult = new PlotResult(string, supplier);
        JButton jButton = new JButton(string);
        jButton.setActionCommand(string);
        jButton.setToolTipText(string2);
        jButton.addActionListener(this::plotButtonHandler);
        this.plotResults.put(jButton, plotResult);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.plotRow;
        gridBagConstraints.gridx = this.plotCol++;
        gridBagConstraints.insets = new Insets(2, 3, 2, 4);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlDrawings.add((Component)jButton, gridBagConstraints);
    }

    public void addPlotSeparator() {
        ++this.plotRow;
        this.plotCol = 0;
    }

    public void addPlotHeader(String string, int n) {
        ++this.plotRow;
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(this.headerFont);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.plotRow;
        gridBagConstraints.insets = new Insets(2, 3, 2, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        this.pnlDrawings.add((Component)jLabel, gridBagConstraints);
        this.addPlotSeparator();
    }

    public void showAbbreviations(boolean bl) {
        this.btnShowAbbreviations.setVisible(bl);
    }

    private void plotButtonHandler(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        PlotResult plotResult = this.plotResults.get(jButton);
        if (plotResult == null) {
            return;
        }
        jButton.setEnabled(false);
        String string = jButton.getText();
        jButton.setText("Loading...");
        SwingUtilities.invokeLater(() -> {
            try {
                if (!this.showPlotWindow(plotResult.window)) {
                    plotResult.window = plotResult.plotCreator.get();
                    this.showPlotWindow(plotResult.window);
                }
            }
            catch (Exception exception) {
                Dialogs.showError(exception.getMessage(), "Error Displaying Result Window");
            }
            finally {
                jButton.setText(string);
                jButton.setEnabled(true);
            }
        });
    }

    private boolean showPlotWindow(InternalWindow internalWindow) {
        if (internalWindow == null || internalWindow.isClosed()) {
            return false;
        }
        internalWindow.toFront();
        internalWindow.grabFocus();
        return true;
    }

    private void showAbbreviations() {
        JLabel jLabel = new JLabel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jLabel.setText("Abbreviations:");
        jLabel.setFont(jLabel.getFont().deriveFont(1, 14.0f));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 4);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("<html><dl><dt><b>MFE</b></dt><dd><b>Minimum Free Energy</b> -- The structure is produced by using the Nearest Neighbor Rules to calculate the Gibbs free energy change (upon folding) for every possible structure and returning the structure(s) with lowest energy.\n</dd>\n\n<dt><b>MEA</b></dt><dd><b>Maximum Expected Accuracy</b> -- The structure is produced by first determining probabilities for all possible base pairs (and by extension all possible unpaired bases). Then the most probable structure is produced by maximizing the sum of probabilities of all base pairs and unpaired bases.\n</dd>\n</dl>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 2, 4);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        jPanel.setPreferredSize(new Dimension(600, 200));
        JOptionPane.showMessageDialog(this, jPanel, "Structure Abbreviations", 1);
    }

    @Override
    public void pack() {
        super.pack();
        this.setSize(new Dimension(this.getWidth(), this.pnlContent.getHeight() + 10 + this.getHeight() - this.pnlClient.getHeight()));
    }

    private static class PlotResult {
        public final String caption;
        public final Supplier<InternalWindow> plotCreator;
        public InternalWindow window;

        public PlotResult(String string, Supplier<InternalWindow> supplier) {
            this.caption = string;
            this.plotCreator = supplier;
        }
    }
}

