/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import ur_rna.RNAstructureUI.menus.ConstraintsMenu;
import ur_rna.RNAstructureUI.ui.FieldPanel;
import ur_rna.RNAstructureUI.ui.FileField;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.windows.DrawingWindow;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.ModuleWindow;
import ur_rna.Utilities.swing.MergeMenu;

public class PartitionSingleWindow
extends ModuleWindow {
    private static final long serialVersionUID = 20120802L;

    public PartitionSingleWindow(String string) {
        super(string, string + " Single Strand Partition Function");
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        if (commandInfo.command.equals("Save File")) {
            int n = 2;
            String string = StandardFileChooser.getSaveName(FileFilters.PartitionSav, filePanel.getFile(n));
            if (string != null) {
                filePanel.setFile(n, string);
            }
        } else if (commandInfo.command.equals("Sequence File")) {
            String string = StandardFileChooser.getOpenName(FileFilters.Sequence);
            if (string == null) {
                return;
            }
            String string2 = this.backend.buildPartitionDataStructure(string, this.isRNA);
            if (!this.verifyBackendResult(string2, "File: %s\nRNA: %s", string, this.isRNA)) {
                return;
            }
            String string3 = PartitionSingleWindow.getOutputFile(string, "pfs");
            filePanel.setFile(1, string);
            filePanel.setFile(2, string3);
            this.getCustomMenus().enableMenus();
        } else {
            super.processCommand(commandInfo);
        }
    }

    @Override
    protected void makeInputControls() {
        FileField fileField = FileField.createDisabled("Sequence File").inputFile(FileFilters.Sequence);
        FileField fileField2 = FileField.createEnabled("Save File").outputFile(FileFilters.PartitionSav);
        FieldPanel.FilePanel filePanel = new FieldPanel.FilePanel(this, fileField, fileField2);
        filePanel.setPanelWidth(600);
        filePanel.makePanel();
        this.setGrid(2, 1);
        this.setFillHorizontal();
        this.placeComponent(0, 0, filePanel);
        this.makeStartButton(0, 1);
    }

    @Override
    protected boolean runMainCalculation() {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        filePanel.saveRecent();
        filePanel.getFile(1);
        String string = filePanel.getFile(2);
        if (filePanel.isError()) {
            return false;
        }
        this.showProgress();
        String string2 = this.backend.runPartition(string);
        this.displayCalcError(string2);
        if (!string2.equals("")) {
            return false;
        }
        if (PartitionSingleWindow.promptDraw()) {
            this.showDrawProgress();
            DrawingWindow drawingWindow = new DrawingWindow(string);
            if (drawingWindow.isError()) {
                return false;
            }
            drawingWindow.showWindow();
        }
        return true;
    }

    @Override
    protected MergeMenu[] createCustomMenus() {
        ConstraintsMenu constraintsMenu = new ConstraintsMenu(this.backend);
        constraintsMenu.buildTemperatureMenu();
        ConstraintsMenu constraintsMenu2 = new ConstraintsMenu(this.backend);
        constraintsMenu2.addGeneralSection();
        constraintsMenu2.addMaxPairingDistanceSection();
        constraintsMenu2.addSHAPESection();
        constraintsMenu2.addShowResetSection();
        constraintsMenu2.addSaveRestoreSection();
        return new ConstraintsMenu[]{constraintsMenu, constraintsMenu2};
    }
}

