/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import ur_rna.RNAstructureUI.menus.ConstraintsMenu;
import ur_rna.RNAstructureUI.ui.FieldPanel;
import ur_rna.RNAstructureUI.ui.FileField;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.windows.DrawingWindow;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.ModuleWindow;
import ur_rna.Utilities.swing.MergeMenu;

public class PartitionDoubleWindow
extends ModuleWindow {
    private static final long serialVersionUID = 20120802L;

    public PartitionDoubleWindow(String string) {
        super(string, string + " Bimolecular Partition Function");
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        if (commandInfo.command.equals("Save File")) {
            int n = 3;
            String string = StandardFileChooser.getSaveName(FileFilters.PartitionSav, filePanel.getFile(n));
            if (string != null) {
                filePanel.setFile(n, string);
            }
        } else if (commandInfo.command.equals("Sequence File 1")) {
            String string = StandardFileChooser.getOpenName(FileFilters.Sequence);
            if (string != null) {
                filePanel.setFile(1, string);
            }
        } else if (commandInfo.command.equals("Sequence File 2")) {
            String string = StandardFileChooser.getOpenName(FileFilters.Sequence);
            if (string == null) {
                return;
            }
            filePanel.setFile(2, string);
            String string2 = filePanel.getFile(1);
            String string3 = filePanel.getFile(2);
            String string4 = this.backend.buildBipartitionDataStructure(string2, string3, this.isRNA);
            if (!this.verifyBackendResult(string4, "Seq1: %s\nSeq2: %s\nRNA: %s", string2, string3, this.isRNA)) {
                return;
            }
            String string5 = this.combineFileNames(string2, string3, "pfs");
            filePanel.setFile(3, string5);
            this.getCustomMenus().enableMenus();
        } else {
            super.processCommand(commandInfo);
        }
    }

    @Override
    protected void makeInputControls() {
        FileField fileField = FileField.createDisabled("Sequence File 1").inputFile(FileFilters.Sequence);
        FileField fileField2 = FileField.createDisabled("Sequence File 2").inputFile(FileFilters.Sequence);
        FileField fileField3 = FileField.createEnabled("Save File").outputFile(FileFilters.PartitionSav);
        FieldPanel.FilePanel filePanel = new FieldPanel.FilePanel(this, fileField, fileField2, fileField3);
        filePanel.setPanelWidth(600);
        filePanel.makePanel();
        this.setGrid(2, 1);
        this.setFillHorizontal();
        this.placeComponent(0, 0, filePanel);
        this.makeStartButton(0, 1);
    }

    @Override
    protected boolean runMainCalculation() {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        filePanel.saveRecent();
        filePanel.getFile(1);
        filePanel.getFile(2);
        String string = filePanel.getFile(3);
        if (filePanel.isError()) {
            return false;
        }
        this.showProgress();
        String string2 = this.backend.runBipartition(string);
        this.displayCalcError(string2);
        if (!string2.equals("")) {
            return false;
        }
        if (PartitionDoubleWindow.promptDraw()) {
            this.showDrawProgress();
            DrawingWindow drawingWindow = new DrawingWindow(string);
            if (drawingWindow.isError()) {
                return false;
            }
            drawingWindow.showWindow();
        }
        return true;
    }

    @Override
    protected MergeMenu[] createCustomMenus() {
        ConstraintsMenu constraintsMenu = new ConstraintsMenu(this.backend);
        constraintsMenu.buildTemperatureMenu();
        return new ConstraintsMenu[]{constraintsMenu};
    }
}

