/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import java.awt.Dimension;
import ur_rna.RNAstructureUI.menus.ConstraintsMenu;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.RNAstructureUI.ui.FieldPanel;
import ur_rna.RNAstructureUI.ui.FileField;
import ur_rna.RNAstructureUI.ui.RadioButtonPanel;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.ModuleWindow;
import ur_rna.Utilities.swing.MergeMenu;

public class OligoScreenWindow
extends ModuleWindow {
    private static final long serialVersionUID = 20120802L;
    private static String oligomerChemistry;

    public OligoScreenWindow() {
        super("", "OligoScreen");
        this.isRNA = false;
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        if (commandInfo.command.equals("Oligomer List")) {
            String string = StandardFileChooser.getOpenName(FileFilters.List);
            if (string == null) {
                return;
            }
            String string2 = this.backend.buildOligoScreenDataStructure();
            if (!this.verifyBackendResult(string2, null, new Object[0])) {
                return;
            }
            String string3 = OligoScreenWindow.getOutputFile(string, "rep");
            filePanel.setFile(1, string);
            filePanel.setFile(2, string3);
            this.getCustomMenus().enableMenus();
        } else if (commandInfo.command.equals("Report File")) {
            int n = 2;
            String string = StandardFileChooser.getSaveName(FileFilters.Report, filePanel.getFile(n));
            if (!string.equals("")) {
                filePanel.setFile(n, string);
            }
        } else if (commandInfo.command.equals("DNA") || commandInfo.command.equals("RNA")) {
            oligomerChemistry = commandInfo.command;
        } else {
            super.processCommand(commandInfo);
        }
    }

    @Override
    protected void makeInputControls() {
        FileField fileField = FileField.createDisabled("Oligomer List").inputFile(FileFilters.List);
        FileField fileField2 = FileField.createEnabled("Report File").outputFile(FileFilters.Report);
        FieldPanel.FilePanel filePanel = new FieldPanel.FilePanel(this, fileField, fileField2);
        filePanel.setPanelWidth(600);
        filePanel.makePanel();
        RadioButtonPanel radioButtonPanel = RadioButtonPanel.makeHorizontal("Oligomer Chemistry", this, "DNA", "RNA");
        int n = radioButtonPanel.getPreferredSize().height;
        radioButtonPanel.setPreferredSize(new Dimension(200, n));
        if (oligomerChemistry != null) {
            radioButtonPanel.setSelectedButton(oligomerChemistry);
        }
        this.setGrid(2, 1);
        this.setFillHorizontal();
        this.placeComponent(0, 0, filePanel);
        this.setGrid(1, 1);
        this.setAnchorCenter();
        this.setInsets(0, 10, 0, 0);
        this.placeComponent(0, 1, radioButtonPanel);
        this.makeStartButton(1, 1);
    }

    @Override
    protected boolean runMainCalculation() {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        RadioButtonPanel radioButtonPanel = (RadioButtonPanel)this.getInputControl(2);
        filePanel.saveRecent();
        String string = filePanel.getFile(1);
        String string2 = filePanel.getFile(2);
        if (filePanel.isError()) {
            return false;
        }
        this.isRNA = radioButtonPanel.getSelectedName().equals("RNA");
        this.showProgress(false);
        String string3 = this.backend.runOligoScreen(string, string2, this.isRNA);
        this.displayCalcError(string3);
        if (!string3.equals("")) {
            return false;
        }
        Dialogs.showMessage("OligoScreen Complete.");
        return true;
    }

    @Override
    protected MergeMenu[] createCustomMenus() {
        ConstraintsMenu constraintsMenu = new ConstraintsMenu(this.backend);
        constraintsMenu.buildTemperatureMenu();
        return new ConstraintsMenu[]{constraintsMenu};
    }
}

