/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import ur_rna.RNAstructureUI.menus.ConstraintsMenu;
import ur_rna.RNAstructureUI.ui.BorderBuilder;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.RNAstructureUI.ui.FieldPanel;
import ur_rna.RNAstructureUI.ui.FileField;
import ur_rna.RNAstructureUI.ui.NumberField;
import ur_rna.RNAstructureUI.ui.ScrollerPane;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.windows.DrawingWindow;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.ModuleWindow;
import ur_rna.Utilities.swing.MergeMenu;

public abstract class MultiWindow
extends ModuleWindow {
    private static final long serialVersionUID = 20120802L;
    protected final int columnWidth = 350;
    protected ArrayList<DrawingWindow> imageDialogs;
    protected Box options;
    private ScrollerPane scroll;

    protected MultiWindow(String string, String string2) {
        super(string, string + " " + string2);
        this.scroll.setSizes(350, 390);
        this.imageDialogs = new ArrayList();
    }

    protected abstract void activate();

    protected abstract void addBackendTuple(String var1, String var2);

    protected abstract void buildSpecificOptionsPanel();

    protected abstract void deleteBackendTuple(int var1);

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        JPanel jPanel = (JPanel)this.getInputControl(5);
        FieldPanel fieldPanel = (FieldPanel)this.getInputControl(jPanel, 3).getComponent(1);
        ScrollerPane scrollerPane = (ScrollerPane)this.getInputControl(jPanel, 2);
        JTextArea jTextArea = (JTextArea)scrollerPane.getViewport().getView();
        if (commandInfo.command.equals("ADD -->")) {
            filePanel.saveRecent();
            String string = filePanel.getFile(1);
            String string2 = filePanel.getFile(2);
            if (string.equals("") || string2.equals("")) {
                return;
            }
            this.addBackendTuple(string, string2);
            this.invokeCommand("Repaint", commandInfo.event);
            filePanel.setFile(1, "");
            filePanel.setFile(2, "");
            if (this.getNumSequences() >= 2) {
                this.getCustomMenus().enableMenus();
            }
        } else if (commandInfo.command.equals("CT File")) {
            int n = 2;
            String string = StandardFileChooser.getSaveName(FileFilters.CT, filePanel.getFile(n));
            if (!string.equals("")) {
                filePanel.setFile(n, string);
            }
        } else if (commandInfo.command.equals("Delete Sequence")) {
            Integer n = ((NumberField.IntegerField)fieldPanel.getField(1)).getValue();
            if (n < 1 || n > this.getNumSequences()) {
                String string = "Cannot delete the selected sequence/ct pair.";
                Dialogs.showError(string);
            } else {
                this.deleteBackendTuple(n);
            }
            this.invokeCommand("Repaint", commandInfo.event);
        } else if (commandInfo.command.equals("Repaint")) {
            jTextArea.setText(this.getSequenceSetAsString());
            ((NumberField.IntegerField)fieldPanel.getField(1)).resetField(this.getNumSequences(), 0, this.getNumSequences());
            jTextArea.repaint();
        } else if (commandInfo.command.equals("Sequence File")) {
            String string = StandardFileChooser.getOpenName(FileFilters.Sequence);
            if (string.equals("")) {
                return;
            }
            String string3 = MultiWindow.getOutputFile(string, "ct");
            filePanel.setFile(1, string);
            filePanel.setFile(2, string3);
        } else {
            super.processCommand(commandInfo);
        }
    }

    protected abstract int getNumSequences();

    protected abstract String getSequenceSetAsString();

    @Override
    protected void makeInputControls() {
        BorderBuilder borderBuilder = new BorderBuilder();
        FileField fileField = FileField.createDisabled("Sequence File").inputFile(FileFilters.Sequence);
        FileField fileField2 = FileField.createEnabled("CT File").outputFile(FileFilters.CT);
        FieldPanel.FilePanel filePanel = new FieldPanel.FilePanel(this, fileField, fileField2);
        filePanel.setPanelWidth(350);
        filePanel.makePanel();
        JButton jButton = new JButton("ADD -->");
        jButton.addActionListener(this);
        this.options = Box.createVerticalBox();
        Dimension dimension = new Dimension(350, 305);
        this.options.setPreferredSize(dimension);
        this.options.setMinimumSize(dimension);
        this.options.setMaximumSize(dimension);
        this.options.setSize(dimension);
        this.buildSpecificOptionsPanel();
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("Sequence Set:");
        jLabel.setHorizontalAlignment(0);
        borderBuilder.makeTopBorder(10, jLabel);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setDisabledTextColor(Color.black);
        jTextArea.setFont(new Font("Monospaced", 0, 12));
        jTextArea.setTabSize(4);
        this.scroll = new ScrollerPane(jTextArea, 0, 0);
        this.scroll.setBarPolicies(1, 1);
        borderBuilder.makeEqualBorder(10, this.scroll);
        JButton jButton2 = new JButton("Delete Sequence");
        jButton2.addActionListener(this);
        NumberField.IntegerField integerField = new NumberField.IntegerField("", 0, 0, 0);
        FieldPanel fieldPanel = new FieldPanel(integerField);
        fieldPanel.setPanelWidth(100);
        fieldPanel.makePanel();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        borderBuilder.makeEqualBorder(10, jPanel2);
        jPanel2.add((Component)jButton2, "West");
        jPanel2.add(fieldPanel);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)this.scroll, "Center");
        jPanel.add((Component)jPanel2, "South");
        this.setGrid(1, 1);
        this.setFillHorizontal();
        this.placeComponent(0, 0, filePanel);
        this.setFillCenter();
        this.setPad(40, 10);
        this.placeComponent(0, 1, jButton);
        this.setPad(0, 0);
        this.setFillHorizontal();
        this.placeComponent(0, 2, this.options);
        this.makeStartButton(0, 3);
        this.setInsets(0, 0, 0, 0);
        this.setPad(0, 0);
        this.setGrid(1, 4);
        this.placeComponent(1, 0, jPanel);
    }

    @Override
    protected boolean runMainCalculation() {
        if (this.getNumSequences() <= 0) {
            String string = "No file names given in sequence set.";
            Dialogs.showError(string);
            return false;
        }
        return this.runMainCalculationMultipleSequences();
    }

    protected abstract boolean runMainCalculationMultipleSequences();

    @Override
    protected MergeMenu[] createCustomMenus() {
        ConstraintsMenu constraintsMenu = new ConstraintsMenu(this.backend);
        constraintsMenu.buildTemperatureMenu();
        return new ConstraintsMenu[]{constraintsMenu};
    }

    protected void showImageDialogs() {
        for (DrawingWindow drawingWindow : this.imageDialogs) {
            if (!drawingWindow.isError()) continue;
            String string = "error creating image results window.";
            Dialogs.showError(string);
            return;
        }
        for (DrawingWindow drawingWindow : this.imageDialogs) {
            drawingWindow.showWindow();
        }
    }
}

