/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.utilities;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import ur_rna.RNAstructureUI.RNAstructure;
import ur_rna.Utilities.Strings;

public class MRUFileStorage {
    private ArrayList<String> list = new ArrayList();

    public List<String> getList() {
        return Collections.unmodifiableList(this.list);
    }

    public void add(String string) {
        this.list.remove(string);
        this.list.add(string);
    }

    public void remove(String string) {
        this.list.remove(string);
    }

    public void saveToStorage() {
        Preferences preferences = RNAstructure.getPrefs().node("MRUFiles");
        int n = 1;
        for (String string : this.list) {
            if (!new File(string).exists()) continue;
            preferences.put("" + n++, string);
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void loadFromStorage() {
        try {
            String[] stringArray;
            this.list.clear();
            Preferences preferences = RNAstructure.getPrefs().node("MRUFiles");
            for (String string : stringArray = preferences.keys()) {
                String string2 = preferences.get(string, null);
                if (Strings.isEmpty(string2)) continue;
                this.list.add(string2);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }
}

