/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class ProgressPanel
extends JPanel {
    private final JProgressBar progressBar;
    private final JLabel label;
    private final JButton button;
    private final Timer timer;
    private boolean started;

    public ProgressPanel() {
        this("Progress: ", null, null);
    }

    public ProgressPanel(String string, ActionListener actionListener, ActionListener actionListener2) {
        super(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.label = new JLabel(string);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.label.setFont(this.label.getFont().deriveFont(1));
        this.add((Component)this.label, gridBagConstraints);
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(new Dimension(20, 25));
        this.progressBar.setValue(0);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.progressBar, gridBagConstraints);
        this.button = new JButton("Cancel");
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridx;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        this.button.setVisible(actionListener != null);
        this.add((Component)this.button, gridBagConstraints);
        this.timer = new Timer(250, actionListener2);
        this.timer.setRepeats(true);
        if (actionListener != null) {
            this.addCancelListener(actionListener);
        }
    }

    public void start() {
        this.started = true;
        if (!this.isIndeterminate()) {
            this.timer.start();
        }
    }

    public void stop() {
        this.started = false;
        this.timer.stop();
    }

    public void addCancelListener(ActionListener actionListener) {
        this.button.addActionListener(actionListener);
    }

    public void removeCancelListener(ActionListener actionListener) {
        this.button.removeActionListener(actionListener);
    }

    public ActionListener[] getCancelListeners() {
        return this.button.getActionListeners();
    }

    public void addUpdateListener(ActionListener actionListener) {
        this.timer.addActionListener(actionListener);
    }

    public void removeUpdateListener(ActionListener actionListener) {
        this.timer.removeActionListener(actionListener);
    }

    public ActionListener[] getUpdateListeners() {
        return this.timer.getActionListeners();
    }

    public String getMessage() {
        return this.label.getText();
    }

    public void setMessage(String string) {
        this.label.setText(string);
    }

    public boolean isIndeterminate() {
        return this.progressBar.isIndeterminate();
    }

    public void setIndeterminate(boolean bl) {
        this.progressBar.setIndeterminate(bl);
        if (bl) {
            this.timer.stop();
        } else if (this.started) {
            this.timer.start();
        }
    }

    public int getProgress() {
        return this.progressBar.getValue();
    }

    public void setProgress(int n) {
        this.progressBar.setValue(n);
    }

    public boolean allowCancel() {
        return this.button.isVisible();
    }

    public void setAllowCancel(boolean bl) {
        this.button.setVisible(bl);
    }
}

