/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.ui;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;

public abstract class NumberField
extends JTextField {
    private static final long serialVersionUID = 20120802L;
    protected Number initial;
    protected Number maximum;
    protected Number minimum;

    protected NumberField(String string, Number number, Number number2, Number number3) {
        this.setName(string);
        this.resetField(number, number2, number3);
        this.addKeyListener(new KeyAdapter(){

            private void checkKey(KeyEvent keyEvent) {
                boolean bl;
                char c = keyEvent.getKeyChar();
                if (Character.isDigit(c)) {
                    return;
                }
                if (c == '\b') {
                    return;
                }
                boolean bl2 = c == '-';
                boolean bl3 = NumberField.this.getText().trim().equals("");
                boolean bl4 = bl = NumberField.this.minimum.doubleValue() < 0.0;
                if (bl2 && bl3 && bl) {
                    return;
                }
                boolean bl5 = NumberField.this.doAdditionalCheck(c);
                if (bl5) {
                    return;
                }
                keyEvent.consume();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                this.checkKey(keyEvent);
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                this.checkKey(keyEvent);
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                boolean bl = NumberField.this.checkValue();
                if (!bl) {
                    NumberField.this.setText(NumberField.this.initial.toString());
                }
            }
        });
    }

    protected abstract boolean checkValue();

    protected boolean doAdditionalCheck(char c) {
        return false;
    }

    public abstract Number getValue();

    public void resetField(Number number) {
        boolean bl;
        boolean bl2 = this.minimum.doubleValue() <= number.doubleValue();
        boolean bl3 = bl = this.maximum.doubleValue() >= number.doubleValue();
        if (!bl2 || !bl) {
            return;
        }
        this.setText(number.toString());
        this.initial = number;
    }

    public void resetField(Number number, Number number2, Number number3) {
        boolean bl;
        boolean bl2 = number2.doubleValue() <= number.doubleValue();
        boolean bl3 = bl = number3.doubleValue() >= number.doubleValue();
        if (!bl2 || !bl) {
            return;
        }
        this.setText(number.toString());
        this.initial = number;
        this.minimum = number2;
        this.maximum = number3;
    }

    public static class IntegerField
    extends NumberField {
        private static final long serialVersionUID = 20120802L;

        public IntegerField(String string, Integer n) {
            super(string, n, -2147483647, Integer.MAX_VALUE);
        }

        public IntegerField(String string, Integer n, Integer n2) {
            super(string, n, n2, Integer.MAX_VALUE);
        }

        public IntegerField(String string, Integer n, Integer n2, Integer n3) {
            super(string, n, n2, n3);
        }

        @Override
        protected boolean checkValue() {
            try {
                Integer n = Integer.parseInt(this.getText());
                if (n < this.minimum.intValue()) {
                    return false;
                }
                if (n > this.maximum.intValue()) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }

        @Override
        public Integer getValue() {
            Integer n = null;
            try {
                n = Integer.parseInt(this.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return n;
        }

        public void setValue(int n) {
            this.setText("" + n);
        }
    }

    public static class FloatField
    extends NumberField {
        private static final long serialVersionUID = 20120802L;

        public FloatField(String string, Number number) {
            super(string, number, Float.valueOf(-3.4028235E38f), Float.valueOf(Float.MAX_VALUE));
        }

        public FloatField(String string, Number number, Number number2) {
            super(string, number, number2, Float.valueOf(Float.MAX_VALUE));
        }

        public FloatField(String string, Number number, Number number2, Number number3) {
            super(string, number, number2, number3);
        }

        @Override
        protected boolean checkValue() {
            try {
                Float f = Float.valueOf(Float.parseFloat(this.getText()));
                if (f.floatValue() < this.minimum.floatValue()) {
                    return false;
                }
                if (f.floatValue() > this.maximum.floatValue()) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }

        @Override
        protected boolean doAdditionalCheck(char c) {
            boolean bl = c == '.';
            boolean bl2 = !this.getText().contains(".");
            return bl && bl2;
        }

        @Override
        public Float getValue() {
            Float f = null;
            try {
                f = Float.valueOf(Float.parseFloat(this.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return f;
        }
    }

    public static class DoubleField
    extends NumberField {
        private static final long serialVersionUID = 20120802L;

        public DoubleField(String string, Number number) {
            super(string, number, -1.7976931348623157E308, Double.MAX_VALUE);
        }

        public DoubleField(String string, Number number, Number number2) {
            super(string, number, number2, Double.MAX_VALUE);
        }

        public DoubleField(String string, Number number, Number number2, Number number3) {
            super(string, number, number2, number3);
        }

        @Override
        protected boolean checkValue() {
            try {
                Double d = Double.parseDouble(this.getText());
                if (d < this.minimum.doubleValue()) {
                    return false;
                }
                if (d > this.maximum.doubleValue()) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }

        @Override
        protected boolean doAdditionalCheck(char c) {
            boolean bl = c == '.';
            boolean bl2 = !this.getText().contains(".");
            return bl && bl2;
        }

        @Override
        public Double getValue() {
            Double d = null;
            try {
                d = Double.parseDouble(this.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return d;
        }
    }
}

