/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.menus;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JPanel;
import ur_rna.RNAstructureUI.RNAstructureBackendCalculator;
import ur_rna.RNAstructureUI.menus.MainMenu;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.RNAstructureUI.ui.FieldPanel;
import ur_rna.RNAstructureUI.ui.FileField;
import ur_rna.RNAstructureUI.ui.NumberField;
import ur_rna.RNAstructureUI.ui.RadioButtonPanel;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.ui.ValueSelectionDialog;
import ur_rna.RNAstructureUI.utilities.FileFilters;

public class ConstraintsMenu
extends MainMenu {
    private static final long serialVersionUID = 20120802L;
    private RNAstructureBackendCalculator backend;
    private int str = 0;

    public ConstraintsMenu(RNAstructureBackendCalculator rNAstructureBackendCalculator) {
        super("Force");
        this.setEnabled(false);
        this.backend = rNAstructureBackendCalculator;
    }

    @Override
    public String getMergeName() {
        return null;
    }

    public void addGeneralSection() {
        this.addItem("Force Base Pairs", "Force two bases to be paired in a folded structure.");
        this.addItem("Prohibit Base Pairs", "Mandate that certain bases be unable to pair in a structure.");
        this.addItem("Chemical Modification", "Modify specified bases chemically prior to folding.");
        this.addItem("FMN Cleavage", "Cleave a strand of interest.");
        this.addItem("Single Stranded", "Force particular regions to be single stranded.");
        this.addItem("Double Stranded", "Force particular regions to be double stranded.");
        this.addSeparator();
    }

    public void addMaxPairingDistanceSection() {
        this.addItem("Maximum Pairing Distance", "Limit the maximum distance allowed between paired bases.");
        this.addSeparator();
    }

    public void addSHAPESection() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"Hard", "Pseudo-Energy"}) {
            this.addItem("Read SHAPE Reactivity -- " + string + " Constraints", "Input constraints on SHAPE data to be used in folding.");
        }
        this.addSeparator();
    }

    public void addSaveRestoreSection() {
        this.addItem("Save Constraints", "Save folding constraints to a save file.");
        this.addItem("Restore Constraints", "Get a set of folding constraints from a save file.");
        this.addSeparator();
    }

    public void addShowResetSection() {
        this.addItem("Show Current Constraints", "View constraints that are currently applied to this sequence.");
        this.addItem("Reset Current Constraints", "Reset the constraints currently applied to this sequence.");
        this.addSeparator();
    }

    public void buildUnimolecularMenu() {
        this.addCheckItem("Forbid Unimolecular Pairs", "Forbid pairs from forming between bases of the same molecule.");
    }

    public void buildDynalignAlignmentMenu() {
        this.setText("Constraints for Alignment");
        this.addItem("Force Alignment", "Force the alignment of particular bases.");
        this.addSeparator();
        this.addItem("Show Current Alignment Constraints", "Show constraints set for this particular alignment.");
        this.addItem("Reset Alignment Constraints", "Reset the constraints that are applied to this alignment.");
        this.addSeparator();
        this.addItem("Save Alignment", "Save the alignment to a save file.");
        this.addItem("Restore Alignment From File", "Get an alignment from a save file.");
    }

    public void buildMaxLoopMenu() {
        this.setText("Maximum Loop");
        this.addItem("Set Maximum Loop Size", "Set the maximum number of unpaired nucleotides allowed.");
    }

    public ConstraintsMenu buildTemperatureMenu() {
        this.setText("Temperature");
        this.addItem("Set Temperature", "Set the temperature at which calculations occur.");
        return this;
    }

    @Override
    protected void onMenuAction(String string, ActionEvent actionEvent) {
        if (string.contains("Alignment")) {
            if (string.startsWith("Force")) {
                String string2 = "Base in Sequence 1;Base in Sequence 2";
                new NucOrHelixDialog(string, string2){

                    @Override
                    public String setConstraint(String string) {
                        String[] stringArray = string.split(" ");
                        Integer n = Integer.parseInt(stringArray[0]);
                        Integer n2 = Integer.parseInt(stringArray[1]);
                        return ConstraintsMenu.this.backend.setDynalignAlignmentConstraint(n, n2);
                    }
                };
            } else if (string.startsWith("Reset")) {
                boolean bl = this.showDeletionConfirmation();
                if (bl) {
                    this.backend.clearDynalignAlignmentConstraints();
                }
            } else if (string.startsWith("Restore")) {
                String string3 = StandardFileChooser.getOpenName(FileFilters.Constraints);
                String string4 = this.backend.readDynalignAlignmentConstraintsFile(string3);
                if (!string4.equals("")) {
                    Dialogs.showError(string4);
                }
            } else if (string.startsWith("Save")) {
                String string5 = StandardFileChooser.getSaveName(FileFilters.Constraints);
                this.backend.writeDynalignAlignmentConstraintsFile(string5);
                Dialogs.showMessage("Dynalign alignment constraints file written.");
            } else if (string.startsWith("Show")) {
                String string6 = this.backend.getDynalignAlignmentConstraints();
                Dialogs.showMessage(string6);
            }
            return;
        }
        String string7 = this.getText();
        int n = string7.endsWith("1") ? 1 : (this.str = string7.endsWith("2") ? 2 : 0);
        if (string.equals("Chemical Modification")) {
            new NucOrHelixDialog(string, "Base Number"){

                @Override
                public String setConstraint(String string) {
                    Integer n = Integer.parseInt(string);
                    return ConstraintsMenu.this.backend.setModifiedNucleotide(n, ConstraintsMenu.this.str);
                }
            };
        } else if (string.contains("Distance")) {
            boolean bl;
            String string8;
            int n2 = this.backend.getMaxPair();
            String string9 = string8 = n2 != -1 ? "Yes" : "No";
            if (n2 == -1) {
                n2 = 600;
            }
            NumberField.IntegerField integerField = new NumberField.IntegerField("Maximum Distance", n2, (Integer)1);
            String[] stringArray = new String[]{"Yes", "No"};
            RadioButtonPanel radioButtonPanel = RadioButtonPanel.makeHorizontal("Limit Distance Between Paired Bases:", stringArray);
            radioButtonPanel.setSelectedButton(string8);
            Box box = Box.createVerticalBox();
            box.add(radioButtonPanel);
            box.add(integerField);
            box.setPreferredSize(new Dimension(300, box.getPreferredSize().height));
            boolean bl2 = bl = Dialogs.showConfirm(box) && radioButtonPanel.getSelectedName().equals("Yes");
            if (bl) {
                this.backend.setMaxPair(integerField.getValue());
            }
        } else if (string.equals("Double Stranded")) {
            new NucOrHelixDialog(string, "Base Number"){

                @Override
                public String setConstraint(String string) {
                    Integer n = Integer.parseInt(string);
                    return ConstraintsMenu.this.backend.setDoubleStrandedNucleotide(n, ConstraintsMenu.this.str);
                }
            };
        } else if (string.equals("FMN Cleavage")) {
            new NucOrHelixDialog(string, "Base Number"){

                @Override
                public String setConstraint(String string) {
                    Integer n = Integer.parseInt(string);
                    return ConstraintsMenu.this.backend.setCleavedNucleotide(n, ConstraintsMenu.this.str);
                }
            };
        } else if (string.equals("Force Base Pairs")) {
            String string10 = "Base 1;Base 2;Helix Length";
            new NucOrHelixDialog(string, string10){

                @Override
                public String setConstraint(String string) {
                    String[] stringArray = string.split(" ");
                    Integer n = Integer.parseInt(stringArray[0]);
                    Integer n2 = Integer.parseInt(stringArray[1]);
                    Integer n3 = Integer.parseInt(stringArray[2]);
                    return ConstraintsMenu.this.backend.setForcedHelix(n, n2, n3, ConstraintsMenu.this.str);
                }
            };
        } else if (string.contains("Loop")) {
            String string11 = "<html>Maximum number of unpaired nucleotides<br/>in internal/bulge loops:";
            int n3 = this.backend.getMaxLoop();
            NumberField.IntegerField integerField = new NumberField.IntegerField(string11, n3, (Integer)0);
            int n4 = Dialogs.getInput(integerField);
            this.backend.setMaxLoop(n4);
        } else if (string.equals("Prohibit Base Pairs")) {
            String string12 = "Base 1;Base 2;Helix Length";
            new NucOrHelixDialog(string, string12){

                @Override
                public String setConstraint(String string) {
                    String[] stringArray = string.split(" ");
                    Integer n = Integer.parseInt(stringArray[0]);
                    Integer n2 = Integer.parseInt(stringArray[1]);
                    Integer n3 = Integer.parseInt(stringArray[2]);
                    return ConstraintsMenu.this.backend.setProhibitedHelix(n, n2, n3, ConstraintsMenu.this.str);
                }
            };
        } else if (string.startsWith("Reset")) {
            boolean bl = this.showDeletionConfirmation();
            if (bl) {
                this.backend.clearFoldingConstraints(this.str);
            }
        } else if (string.startsWith("Restore")) {
            String string13 = StandardFileChooser.getOpenName(FileFilters.Constraints);
            String string14 = this.backend.readFoldingConstraintsFile(string13, this.str);
            if (!string14.equals("")) {
                Dialogs.showError(string14);
            }
        } else if (string.startsWith("Save")) {
            String string15 = StandardFileChooser.getSaveName(FileFilters.Constraints);
            this.backend.writeFoldingConstraintsFile(string15, this.str);
            Dialogs.showMessage("Folding constraints file written.");
        } else if (string.contains("SHAPE")) {
            boolean bl = string.contains("Energy");
            String string16 = bl ? "Slope (kcal/mol):" : "Threshold for Force Single Stranded:";
            double d = bl ? 1.8 : 2.0;
            String string17 = bl ? "Intercept (kcal/mol):" : "Threshold for Chemical Modification:";
            double d2 = bl ? -0.6 : 1.0;
            final FileField fileField = FileField.createEnabled("SHAPE Data File");
            FieldPanel.FilePanel filePanel = new FieldPanel.FilePanel(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    fileField.setText(StandardFileChooser.getOpenName(FileFilters.SHAPE));
                }
            }, fileField);
            filePanel.setPanelWidth(400);
            filePanel.makePanel();
            NumberField.DoubleField doubleField = new NumberField.DoubleField(string16, d);
            NumberField.DoubleField doubleField2 = new NumberField.DoubleField(string17, d2);
            FieldPanel fieldPanel = new FieldPanel(doubleField, doubleField2);
            fieldPanel.setPanelWidth(400);
            fieldPanel.makePanel();
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)filePanel, "North");
            jPanel.add((Component)fieldPanel, "South");
            if (Dialogs.showConfirm(jPanel)) {
                this.backend.setSHAPEFile(fileField.getText().trim());
                this.backend.setSHAPEParam1(doubleField.getValue());
                this.backend.setSHAPEParam2(doubleField2.getValue());
                this.backend.setSHAPEType(bl);
            }
        } else if (string.startsWith("Show")) {
            String string18 = this.backend.getFoldingConstraints(this.str);
            Dialogs.showMessage(string18);
        } else if (string.equals("Single Stranded")) {
            new NucOrHelixDialog(string, "Base Number"){

                @Override
                public String setConstraint(String string) {
                    Integer n = Integer.parseInt(string);
                    return ConstraintsMenu.this.backend.setSingleStrandedNucleotide(n, ConstraintsMenu.this.str);
                }
            };
        } else if (string.contains("Temperature")) {
            double d = this.backend.getTemperature();
            NumberField.DoubleField doubleField = new NumberField.DoubleField("Temperature (degrees K):", d, (Number)0);
            double d3 = Dialogs.getInput(doubleField);
            this.backend.setTemperature(d3);
        }
    }

    private boolean showDeletionConfirmation() {
        String string = "This will reset all constraints.\nContinue?";
        return Dialogs.showConfirm(string);
    }

    public abstract class NucOrHelixDialog
    extends ValueSelectionDialog {
        private static final long serialVersionUID = 20120802L;

        public NucOrHelixDialog(String string, String string2) {
            super(string);
            String[] stringArray = string2.split(";");
            NumberField[] numberFieldArray = new NumberField.IntegerField[stringArray.length];
            for (int i = 1; i <= stringArray.length; ++i) {
                numberFieldArray[i - 1] = new NumberField.IntegerField(stringArray[i - 1], 1, 1, ConstraintsMenu.this.backend.getMaxConstraintIndex(ConstraintsMenu.this.str));
            }
            this.buildDialog("Apply", numberFieldArray);
        }

        @Override
        public ActionListener createSelectionAction() {
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = "";
                    for (NumberField numberField : NucOrHelixDialog.this.fields) {
                        object = (String)object + numberField.getText() + " ";
                    }
                    String string = NucOrHelixDialog.this.setConstraint(((String)object).trim());
                    if (!string.equals("")) {
                        Dialogs.showError(string);
                    }
                }
            };
        }

        public abstract String setConstraint(String var1);
    }
}

