/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.drawing.menus;

import java.awt.event.ActionEvent;
import ur_rna.RNAstructureUI.drawing.dialogs.PlotDialog;
import ur_rna.RNAstructureUI.menus.MainMenu;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileFilters;

public class PlotMenu
extends MainMenu {
    private static final long serialVersionUID = 20120615L;
    private PlotDialog dialog;

    public PlotMenu(PlotDialog plotDialog) {
        super("Output Plot");
        this.addItem("Write Dot Plot File", "Write visible dots to a text file.");
        this.addItem("Write Postscript File", "Write the visible plot to a Postscript image file.");
        this.addItem("Write SVG File", "Write the visible plot to an SVG image file.");
        if (plotDialog.getFile().endsWith("pfs")) {
            this.addSeparator();
            this.addItem("Write Probable Structures File", "Write a CT file containing structures which are composed of probable pairs of different levels.");
        }
        this.dialog = plotDialog;
    }

    @Override
    protected void onMenuAction(String string, ActionEvent actionEvent) {
        String string2;
        if (string.contains("Dot Plot")) {
            String string3 = StandardFileChooser.getSaveName(FileFilters.DotPlot);
            if (string3 != null) {
                this.dialog.writeTextFile(string3);
            }
        } else if (string.contains("Postscript")) {
            String string4 = StandardFileChooser.getSaveName(FileFilters.Postscript);
            if (string4 != null) {
                this.dialog.writePostscriptFile(string4);
            }
        } else if (string.equals("Write Probable Structures File")) {
            String string5 = StandardFileChooser.getSaveName(FileFilters.CT);
            if (string5 != null) {
                this.dialog.writeStructuresFile(string5, true);
            }
        } else if (string.contains("SVG") && (string2 = StandardFileChooser.getSaveName(FileFilters.SVG)) != null) {
            this.dialog.writeSVGFile(string2);
        }
    }
}

