/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.drawing.menus;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import ur_rna.RNAstructureUI.drawing.dialogs.PlotDialog;
import ur_rna.RNAstructureUI.menus.MainMenu;
import ur_rna.RNAstructureUI.ui.BorderBuilder;
import ur_rna.RNAstructureUI.ui.FieldPanel;
import ur_rna.RNAstructureUI.ui.NumberField;
import ur_rna.RNAstructureUI.ui.ValueSelectionDialog;

public class DotsMenu
extends MainMenu {
    private static final long serialVersionUID = 20120615L;
    private PlotDialog dialog;

    public DotsMenu(PlotDialog plotDialog) {
        super("Draw");
        this.addItem("Zoom", "Zoom this structure.");
        this.addItem("Choose Colors", "Select the number of colors in a dot plot.");
        this.addItem("Plot Range", "Select the range of values displayed in the plot.");
        this.dialog = plotDialog;
    }

    @Override
    protected void onMenuAction(String string, ActionEvent actionEvent) {
        if (string.equals("Choose Colors")) {
            new ColorDialog();
        } else if (string.equals("Plot Range")) {
            new RangeDialog();
        } else if (string.equals("Zoom")) {
            this.dialog.viewZoomDialog();
        }
    }

    private class RangeDialog
    extends ValueSelectionDialog {
        private static final long serialVersionUID = 20120802L;
        private FieldPanel range;

        public RangeDialog() {
            super("Set Plot Range");
            this.buildDialog("OK", new NumberField[0]);
        }

        @Override
        public JPanel createAdditionalControls() {
            Double[] doubleArray = DotsMenu.this.dialog.getCurrentBounds();
            Double[] doubleArray2 = DotsMenu.this.dialog.getDefaultBounds();
            NumberField.DoubleField doubleField = new NumberField.DoubleField("Minimum", doubleArray[0], doubleArray2[0], doubleArray2[1]);
            NumberField.DoubleField doubleField2 = new NumberField.DoubleField("Maximum", doubleArray[1], doubleArray2[0], doubleArray2[1]);
            this.range = new FieldPanel(doubleField, doubleField2);
            this.range.setPanelWidth(300);
            this.range.makePanel();
            JButton jButton = new JButton("Reset");
            jButton.setPreferredSize(new Dimension(125, 30));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Double[] doubleArray = DotsMenu.this.dialog.getDefaultBounds();
                    ((NumberField.DoubleField)RangeDialog.this.range.getField(1)).resetField(doubleArray[0]);
                    ((NumberField.DoubleField)RangeDialog.this.range.getField(2)).resetField(doubleArray[1]);
                }
            });
            JPanel jPanel = new JPanel();
            new BorderBuilder().makeBottomBorder(5, jPanel);
            jPanel.add(jButton);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add(this.range);
            jPanel2.add((Component)jPanel, "South");
            return jPanel2;
        }

        @Override
        public ActionListener createSelectionAction() {
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DotsMenu.this.dialog.setRange(((NumberField.DoubleField)RangeDialog.this.range.getField(1)).getValue(), ((NumberField.DoubleField)RangeDialog.this.range.getField(2)).getValue());
                    DotsMenu.this.dialog.zoomImage();
                    DotsMenu.this.dialog.repaint();
                    RangeDialog.this.dispose();
                }
            };
        }
    }

    private class ColorDialog
    extends ValueSelectionDialog {
        private static final long serialVersionUID = 20120802L;

        public ColorDialog() {
            super("Choose Colors");
            Integer[] integerArray = DotsMenu.this.dialog.getColors();
            NumberField.IntegerField integerField = new NumberField.IntegerField("Colors", integerArray[0], integerArray[1], integerArray[2]);
            this.buildDialog("OK", integerField);
        }

        @Override
        public ActionListener createSelectionAction() {
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DotsMenu.this.dialog.setColors(Integer.parseInt(ColorDialog.this.fields[0].getText()));
                    DotsMenu.this.dialog.zoomImage();
                    DotsMenu.this.dialog.repaint();
                    ColorDialog.this.dispose();
                }
            };
        }
    }
}

