/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.drawing.dialogs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import ur_rna.RNAstructureUI.drawing.dialogs.ImageDialog;
import ur_rna.RNAstructureUI.drawing.menus.AnnotationMenu;
import ur_rna.RNAstructureUI.drawing.menus.StructureMenu;
import ur_rna.RNAstructureUI.drawing.proxy.StructureBackend;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.RNAstructureUI.utilities.FileType;
import ur_rna.Utilities.Strings;

public class StructureDialog
extends ImageDialog {
    private static final long serialVersionUID = 20120802L;
    private int drawOptions;
    private StructureBackend backend;
    private String[] data;
    private boolean hasPairs = false;
    private int number;
    private String[] regex;

    public boolean getOption(DrawOptions drawOptions) {
        return (this.drawOptions & 1 << drawOptions.ordinal()) != 0;
    }

    public boolean toggleOption(DrawOptions drawOptions) {
        boolean bl = !this.getOption(drawOptions);
        this.setOption(drawOptions, bl);
        return bl;
    }

    public void setOption(DrawOptions drawOptions) {
        this.setOption(drawOptions, true);
    }

    public void setOption(DrawOptions drawOptions, boolean bl) {
        if (bl == this.getOption(drawOptions)) {
            return;
        }
        this.drawOptions = bl ? (this.drawOptions |= 1 << drawOptions.ordinal()) : (this.drawOptions &= ~(1 << drawOptions.ordinal()));
        switch (drawOptions) {
            case CIRCULAR: {
                if (bl) {
                    this.drawOptions &= ~(1 << DrawOptions.FLAT.ordinal());
                    this.backend.setBackboneStyle(2);
                    break;
                }
                this.backend.setBackboneStyle(0);
                break;
            }
            case FLAT: {
                if (bl) {
                    this.drawOptions &= ~(1 << DrawOptions.CIRCULAR.ordinal());
                    this.backend.setBackboneStyle(1);
                    break;
                }
                this.backend.setBackboneStyle(0);
                break;
            }
            case FLIPPED: {
                this.backend.flip();
                break;
            }
            case UNCIRCLED: {
                this.backend.setNucleotidesCircled(!bl);
            }
        }
        this.redrawStructure();
    }

    public StructureDialog(String string) {
        super(string);
        if (!Strings.isEmpty(this.error)) {
            return;
        }
        this.customMenus.setSubItemMergePos(200);
        this.customMenus.add(new AnnotationMenu(this), new StructureMenu(this));
        this.buildMenuBar();
        this.regex = new String[6];
        this.regex[0] = "Placed at\\: \\(([0-9]+\\.*[0-9]*)\\,([0-9]+\\.*[0-9]*)\\)";
        this.regex[1] = "Paired to\\: ([0-9]+)";
        this.regex[2] = "Control point\\: \\(([0-9]+\\.*[0-9]*)\\,([0-9]+\\.*[0-9]*)\\)";
        this.regex[3] = "Backbone stretches to: \\(([0-9]+\\.*[0-9]*)\\,([0-9]+\\.*[0-9]*)\\)";
        this.regex[4] = "Label placed at: \\(([0-9]+\\.*[0-9]*)\\,([0-9]+\\.*[0-9]*)\\)";
        this.regex[5] = "Character\\: ([A-Za-z]).*Placed at\\: \\(([0-9]+\\.*[0-9]*)\\,([0-9]+\\.*[0-9]*)\\).*Color \\(RGB\\)\\: ([0-9]+)\\,([0-9]+)\\,([0-9]+)";
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                boolean bl;
                int n = keyEvent.getKeyCode();
                int n2 = n == 38 ? 1 : (n == 40 ? -1 : 0);
                int n3 = StructureDialog.this.getStructureCount();
                boolean bl2 = bl = 0 != (keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
                if (bl && n2 != 0) {
                    int n4 = StructureDialog.this.number + n2;
                    if (n4 < 1) {
                        n4 = 1;
                    } else if (n4 > n3) {
                        n4 = n3;
                    }
                    StructureDialog.this.setStructureNumber(n4);
                }
            }
        });
        this.setStructureNumber(1);
    }

    public void clearAnnotation() {
        this.backend.removeAnnotation();
        this.buildLegend(new String[0]);
        this.refresh();
    }

    @Override
    protected void createDrawnImage(Graphics2D graphics2D) {
        Serializable serializable;
        Number number;
        Number number2;
        Serializable serializable2;
        Serializable serializable3;
        Object object;
        Serializable serializable4;
        Object object2;
        Object object3;
        Object object4;
        Matcher matcher;
        int n;
        graphics2D.setColor(Color.black);
        if (!this.hasPairs) {
            graphics2D.setFont(graphics2D.getFont().deriveFont(1, 20.0f));
            graphics2D.drawString("This structure contains no pairs.", 30, 60);
            return;
        }
        graphics2D.setStroke(new BasicStroke(3.0f));
        for (n = 1; n < this.data.length; ++n) {
            int n2;
            matcher = Pattern.compile(this.regex[1]).matcher(this.data[n]);
            int n3 = n2 = matcher.find() ? Integer.parseInt(matcher.group(1)) : 0;
            if (n2 == 0) continue;
            object4 = Pattern.compile(this.regex[0]).matcher(this.data[n]);
            ((Matcher)object4).find();
            object3 = Pattern.compile(this.regex[2]).matcher(this.data[n]);
            ((Matcher)object3).find();
            object2 = Pattern.compile(this.regex[0]).matcher(this.data[n2]);
            ((Matcher)object2).find();
            serializable4 = Double.valueOf(Double.parseDouble(((Matcher)object4).group(1)));
            object = Double.parseDouble(((Matcher)object4).group(2));
            serializable3 = Double.valueOf(Double.parseDouble(((Matcher)object3).group(1)));
            serializable2 = Double.valueOf(Double.parseDouble(((Matcher)object3).group(2)));
            number2 = Double.parseDouble(((Matcher)object2).group(1));
            number = Double.parseDouble(((Matcher)object2).group(2));
            serializable = new Path2D.Double();
            ((Path2D)((Object)serializable)).moveTo((Double)serializable4, (Double)object);
            ((Path2D)((Object)serializable)).curveTo((Double)serializable4, (Double)object, (Double)serializable3, (Double)serializable2, (Double)number2, (Double)number);
            graphics2D.draw((Shape)((Object)serializable));
        }
        graphics2D.setStroke(new BasicStroke(1.0f));
        for (n = 1; n < this.data.length; ++n) {
            matcher = Pattern.compile(this.regex[0]).matcher(this.data[n]);
            if (!matcher.find()) continue;
            Double d = Double.parseDouble(matcher.group(1));
            object4 = Double.parseDouble(matcher.group(2));
            object3 = Pattern.compile(this.regex[3]).matcher(this.data[n]);
            object2 = Pattern.compile(this.regex[4]).matcher(this.data[n]);
            if (((Matcher)object3).find()) {
                serializable4 = Double.valueOf(Double.parseDouble(((Matcher)object3).group(1)));
                object = Double.parseDouble(((Matcher)object3).group(2));
                graphics2D.draw(new Line2D.Double(d, (Double)object4, (Double)serializable4, (Double)object));
            }
            if (!((Matcher)object2).find()) continue;
            serializable4 = Double.valueOf(Double.parseDouble(((Matcher)object2).group(1)));
            object = Double.parseDouble(((Matcher)object2).group(2));
            graphics2D.draw(new Line2D.Double(d, (Double)object4, (Double)serializable4, (Double)object));
        }
        graphics2D.setFont(graphics2D.getFont().deriveFont(1, 28.0f));
        for (n = 1; n < this.data.length; ++n) {
            matcher = Pattern.compile(this.regex[4]).matcher(this.data[n]);
            if (!matcher.find()) continue;
            Integer n4 = new Double(Double.parseDouble(matcher.group(1))).intValue();
            object4 = new Double(Double.parseDouble(matcher.group(2))).intValue();
            object3 = Integer.toString(n);
            object2 = graphics2D.getFontMetrics().getStringBounds((String)object3, graphics2D).getBounds();
            serializable4 = graphics2D.getFont().createGlyphVector(graphics2D.getFontRenderContext(), (String)object3).getVisualBounds().getBounds();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(n4 - ((Rectangle)object2).width / 2 - 1, (Integer)object4 - ((Rectangle)serializable4).height / 2 - 1, ((Rectangle)object2).width + 2, ((Rectangle)serializable4).height + 2);
            graphics2D.setColor(Color.black);
            graphics2D.drawString((String)object3, n4 - ((Rectangle)object2).width / 2, (Integer)object4 - ((Rectangle)serializable4).height / 2 - ((Rectangle)serializable4).y);
        }
        n = 30;
        boolean bl = !this.getOption(DrawOptions.UNCIRCLED);
        int n5 = n / 2;
        for (int i = 1; i < this.data.length; ++i) {
            object3 = Pattern.compile(this.regex[5], 32).matcher(this.data[i]);
            if (!((Matcher)object3).find()) continue;
            object2 = new Double(Double.parseDouble(((Matcher)object3).group(2))).intValue();
            serializable4 = Integer.valueOf(new Double(Double.parseDouble(((Matcher)object3).group(3))).intValue());
            object = ((Matcher)object3).group(1);
            serializable3 = graphics2D.getFontMetrics().getStringBounds((String)object, graphics2D).getBounds();
            serializable2 = graphics2D.getFont().createGlyphVector(graphics2D.getFontRenderContext(), (String)object).getVisualBounds().getBounds();
            number2 = Integer.parseInt(((Matcher)object3).group(4));
            number = Integer.parseInt(((Matcher)object3).group(5));
            serializable = Integer.valueOf(Integer.parseInt(((Matcher)object3).group(6)));
            graphics2D.setColor(Color.white);
            graphics2D.fillOval((Integer)object2 - n5, (Integer)serializable4 - n5, n, n);
            if (bl) {
                graphics2D.setColor(Color.black);
                graphics2D.drawOval((Integer)object2 - n5, (Integer)serializable4 - n5, n, n);
            }
            graphics2D.setColor(new Color((Integer)number2, (Integer)number, (Integer)serializable));
            graphics2D.drawString((String)object, (Integer)object2 - ((Rectangle)serializable3).width / 2, (Integer)serializable4 - ((Rectangle)serializable2).height / 2 - ((Rectangle)serializable2).y);
        }
    }

    @Override
    protected void readImageData() {
        this.backend = new StructureBackend();
        this.error = this.backend.readStructureData(this.file);
    }

    public void setAnnotation(String string) {
        this.setAnnotation(string, null);
    }

    public void setAnnotation(String string, FileType fileType) {
        boolean bl;
        if (fileType == null) {
            fileType = FileType.guessTypeFromFilePath(string);
        }
        if (fileType == null) {
            Dialogs.showWarning("Could not determine the file type from the file name: " + string);
            return;
        }
        switch (fileType) {
            case PFS: {
                bl = this.backend.addAnnotationProbability(string);
                break;
            }
            case SHAPE: {
                bl = this.backend.addAnnotationSHAPE(string);
                break;
            }
            default: {
                Dialogs.showError("Cannot add annotation from this type of file: " + fileType.toString());
                return;
            }
        }
        if (!bl) {
            String string2 = "error adding annotation.";
            Dialogs.showError(string2);
            return;
        }
        String string3 = this.backend.getStructureData(1);
        if (Strings.isEmpty(string3)) {
            string3 = "ERROR: Unknown error loading data for structure 1";
        }
        if (string3.startsWith("ERROR")) {
            Dialogs.showError(string3);
            return;
        }
        string3 = string3.substring(string3.indexOf("Legend")).trim();
        string3 = string3.substring(string3.indexOf(":") + 2);
        string3 = string3.replaceAll("rgb\\(", "").replaceAll("\\)", "").replaceAll(",", " ").replaceAll("\"", "").replaceAll(" -- ", " ");
        String[] stringArray = string3.split("\\n");
        this.buildLegend(stringArray);
        JLabel jLabel = (JLabel)this.getContentPane().getComponent(0);
        String[] stringArray2 = jLabel.getText().split(" ");
        Integer n = Integer.parseInt(stringArray2[1]);
        this.setStructureNumber(n);
        this.refresh();
    }

    public void setStructureNumber(int n) {
        this.number = n;
        Object object = this.backend.getStructureData(n);
        if (Strings.isEmpty((String)object)) {
            object = "ERROR: failed to retrieve data for structure " + n + ".";
        }
        if (((String)object).startsWith("ERROR")) {
            Dialogs.showError((String)object);
            return;
        }
        this.data = ((String)object).split("Nucleotide");
        String string = ((String)object).substring(((String)object).indexOf("Max Bounds"));
        int n2 = string.indexOf("(") + 1;
        int n3 = string.indexOf(",");
        int n4 = n3 + 1;
        int n5 = string.indexOf(")");
        this.imgSizeX = Double.parseDouble(string.substring(n2, n3));
        this.imgSizeY = Double.parseDouble(string.substring(n4, n5));
        String string2 = ((String)object).substring(0, ((String)object).indexOf("Nuc")).trim();
        String string3 = ((String)object).substring(((String)object).indexOf("Description"));
        if ((string3 = string3.substring(string3.indexOf(":") + 2)).contains("Legend:")) {
            int n6 = string3.indexOf("Legend:");
            string3 = string3.substring(0, n6);
        }
        this.setTopCaption(string2 + " -- " + string3.trim());
        this.hasPairs = Pattern.compile(this.regex[1]).matcher((CharSequence)object).find();
        if (!this.hasPairs) {
            this.setScale(50);
            this.imgSizeX = 450.0;
            this.imgSizeY = 450.0;
        }
        double d = (this.isVisible() ? this.getWidth() : 450) - 5;
        double d2 = (this.isVisible() ? this.getHeight() : 450) - 5;
        double d3 = d / this.imgSizeX;
        double d4 = d2 / this.imgSizeY;
        this.scale = Math.min(d3, d4);
        this.zoomImage();
    }

    void redrawStructure() {
        this.setStructureNumber(this.getStructureNumber());
    }

    public void writeDotBracketFile(String string) {
        String string2 = this.backend.writeDotBracketFile(this.file, string);
        if (string2.equals("")) {
            Dialogs.showMessage("Dot bracket file written.");
        } else {
            Dialogs.showError("error writing dot bracket file.");
        }
    }

    public void writeHelixFile(String string) {
        String string2 = this.backend.writeHelixFile(this.file, string, this.number);
        if (string2.equals("")) {
            Dialogs.showMessage("Helix file written.");
        } else {
            Dialogs.showError("error writing helix file.");
        }
    }

    public void writePostscriptFile(String string) {
        this.backend.writePostscriptFile(string, this.number);
        Dialogs.showMessage("Postscript file written.");
    }

    public void writeSVGFile(String string) {
        this.backend.writeSVGFile(string, this.number);
        Dialogs.showMessage("SVG file written.");
    }

    public int getStructureNumber() {
        return this.number;
    }

    public int getStructureCount() {
        return this.backend.getStructureCount();
    }

    public static enum DrawOptions {
        NORMAL,
        CIRCULAR,
        FLAT,
        UNCIRCLED,
        FLIPPED;

    }
}

