/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.drawing.dialogs;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import ur_rna.RNAstructureUI.drawing.dialogs.ImageDialog;
import ur_rna.RNAstructureUI.drawing.dialogs.StructureDialog;
import ur_rna.RNAstructureUI.drawing.menus.DotsMenu;
import ur_rna.RNAstructureUI.drawing.menus.PlotMenu;
import ur_rna.RNAstructureUI.drawing.proxy.DotPlotBackend;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.RNAstructureUI.windows.ModuleWindow;

public class PlotDialog
extends ImageDialog {
    private static final long serialVersionUID = 20120802L;
    private DotPlotBackend backend;
    private int strand;
    private int plotLength;

    public PlotDialog(String string) {
        super(string);
        this.customMenus.setSubItemMergePos(200);
        this.customMenus.add(new DotsMenu(this), new PlotMenu(this));
        this.buildMenuBar();
        this.strand = 1;
        this.setTopCaption("DOT PLOT");
        this.mainPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                String string = PlotDialog.this.backend.getDotDataByLocation(mouseEvent.getX(), mouseEvent.getY(), PlotDialog.this.scale);
                if (string.equals("")) {
                    PlotDialog.this.setTopCaption("DOT PLOT");
                } else {
                    PlotDialog.this.setTopCaption(string);
                }
            }
        });
    }

    public PlotDialog(String string, int n) {
        this(string);
        this.strand = n;
    }

    @Override
    protected void createDrawnImage(Graphics2D graphics2D) {
        Object object;
        Integer n;
        Integer n2;
        Number number;
        Number number2;
        String[] stringArray;
        Object object2;
        String string;
        graphics2D.setColor(Color.BLACK);
        int n3 = 1;
        while (!(string = this.backend.getGridLine(n3)).equals("")) {
            String[] stringArray2 = string.split(" ");
            object2 = Double.parseDouble(stringArray2[0]);
            stringArray = Double.valueOf(Double.parseDouble(stringArray2[1]));
            number2 = Double.parseDouble(stringArray2[2]);
            number = Double.parseDouble(stringArray2[3]);
            graphics2D.draw(new Line2D.Double((Double)object2, stringArray.doubleValue(), (Double)number2, (Double)number));
            if (stringArray2.length > 4) {
                n2 = Integer.parseInt(stringArray2[5]);
                n = Integer.parseInt(stringArray2[6]);
                object = stringArray2[4];
                graphics2D.drawString((String)object, (int)n2, (int)n);
            }
            ++n3;
        }
        for (int i = 1; i <= this.plotLength; ++i) {
            for (int j = i; j <= this.plotLength; ++j) {
                object2 = this.backend.getDotData(i, j);
                if (((String)object2).equals("")) continue;
                stringArray = ((String)object2).split(" ");
                number2 = Integer.parseInt(stringArray[0]);
                number = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
                object = Integer.parseInt(stringArray[4]);
                graphics2D.setColor(new Color(n2, n, (Integer)object));
                graphics2D.fillRect((Integer)number2, (Integer)number, 3, 3);
            }
        }
    }

    public Integer[] getColors() {
        String[] stringArray = this.backend.getColors().split(" ");
        Integer n = Integer.parseInt(stringArray[0]);
        Integer n2 = Integer.parseInt(stringArray[1]);
        Integer n3 = Integer.parseInt(stringArray[2]);
        return new Integer[]{n, n2, n3};
    }

    public Double[] getCurrentBounds() {
        Double d = this.backend.getCurrentMin();
        Double d2 = this.backend.getCurrentMax();
        return new Double[]{d, d2};
    }

    public Double[] getDefaultBounds() {
        Double d = this.backend.getDefaultMin();
        Double d2 = this.backend.getDefaultMax();
        return new Double[]{d, d2};
    }

    @Override
    protected void readImageData() {
        this.backend = new DotPlotBackend();
        boolean bl = this.backend.readData(this.file, this.strand);
        if (!bl) {
            this.error = "error reading dot plot data.";
            return;
        }
        String[] stringArray = this.backend.getBounds().split(" ");
        this.imgSizeX = Double.parseDouble(stringArray[0]);
        this.imgSizeY = Double.parseDouble(stringArray[1]);
        this.plotLength = this.backend.getLength();
        this.buildLegend(this.backend.getLegendData().split("\n"));
        this.zoomImage();
    }

    public void setColors(int n) {
        this.backend.setColors(n);
        this.buildLegend(this.backend.getLegendData().split("\n"));
    }

    public void setRange(double d, double d2) {
        this.backend.setRange(d, d2);
        this.buildLegend(this.backend.getLegendData().split("\n"));
    }

    public void writePostscriptFile(String string) {
        this.backend.writePostscriptFile(string);
        String string2 = "Postscript file written.";
        Dialogs.showMessage(string2);
    }

    public boolean writeStructuresFile(String string, boolean bl) {
        StructureDialog structureDialog;
        String string2 = this.backend.writeStructuresFile(this.file, string);
        if (!string2.equals("")) {
            Dialogs.showError("error writing probable structures file.");
            return false;
        }
        if (bl && ModuleWindow.promptDraw() && !(structureDialog = new StructureDialog(string)).isError()) {
            structureDialog.viewDialog();
        }
        return true;
    }

    public void writeSVGFile(String string) {
        this.backend.writeSVGFile(string);
        Dialogs.showMessage("SVG file written.");
    }

    public void writeTextFile(String string) {
        this.backend.writeTextFile(string);
        Dialogs.showMessage("Dot plot text file written.");
    }
}

