/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.drawing.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ur_rna.RNAstructureUI.menus.MainMenu;
import ur_rna.RNAstructureUI.menus.MenuList;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.RNAstructureUI.ui.NumberField;
import ur_rna.RNAstructureUI.ui.ScrollerPane;
import ur_rna.RNAstructureUI.ui.ValueSelectionDialog;
import ur_rna.Utilities.OSInfo;
import ur_rna.Utilities.swing.MergeMenu;

public abstract class ImageDialog
extends JInternalFrame
implements Printable {
    private static final long serialVersionUID = 20120802L;
    protected MenuList customMenus = new MenuList();
    protected String error = "";
    protected String file;
    private JLabel label;
    private JPanel legendGrid;
    protected JPanel mainPanel;
    protected double imgSizeX = -1.7976931348623157E308;
    protected double imgSizeY = -1.7976931348623157E308;
    private PrinterJob job = PrinterJob.getPrinterJob();
    protected final int preferredDialogWidth = 450;
    protected double scale;

    protected ImageDialog(String string) {
        this.setBackground(Color.WHITE);
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle(string);
        this.addKeyListener(new KeyAdapter(){
            private boolean isControl = false;

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                this.isControl = keyEvent.isControlDown();
                if (OSInfo.isMac() && !this.isControl) {
                    this.isControl = keyEvent.isMetaDown();
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                boolean bl;
                int n = keyEvent.getKeyCode();
                boolean bl2 = bl = n == 39 || n == 37;
                if (bl && this.isControl) {
                    ImageDialog.this.scale = n == 39 ? (ImageDialog.this.scale += 0.05) : (ImageDialog.this.scale -= 0.05);
                    ImageDialog.this.setScale(new Double(ImageDialog.this.scale * 100.0).intValue());
                    ImageDialog.this.zoomImage();
                }
                this.isControl = false;
            }
        });
        this.label = new JLabel(" ");
        this.label.setHorizontalAlignment(0);
        this.label.setVerticalAlignment(0);
        this.label.setPreferredSize(new Dimension(450, 20));
        this.label.setBackground(Color.LIGHT_GRAY);
        this.label.setOpaque(true);
        this.add((Component)this.label, "North");
        this.mainPanel = new JPanel(){

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics2D.setColor(Color.black);
                graphics2D.scale(ImageDialog.this.scale, ImageDialog.this.scale);
                ImageDialog.this.createDrawnImage(graphics2D);
            }
        };
        this.mainPanel.setOpaque(true);
        this.mainPanel.setDoubleBuffered(true);
        ScrollerPane scrollerPane = new ScrollerPane(this.mainPanel, 450, 450);
        scrollerPane.getViewport().setViewPosition(new Point(0, 0));
        this.add((Component)scrollerPane, "Center");
        if (OSInfo.isMac()) {
            this.addKeyListener(scrollerPane.getKeyListeners()[0]);
        }
        this.legendGrid = new JPanel(new GridLayout(0, 1));
        this.legendGrid.setOpaque(true);
        this.legendGrid.setBackground(Color.white);
        ScrollerPane scrollerPane2 = new ScrollerPane(this.legendGrid, 450, 105);
        scrollerPane2.setBarPolicies(2, 1);
        this.buildLegend(new String[0]);
        this.add((Component)scrollerPane2, "South");
        this.file = string;
        this.readImageData();
        double d = 445.0;
        double d2 = d / this.imgSizeX;
        double d3 = d / this.imgSizeY;
        this.scale = Math.min(d2, d3);
        this.zoomImage();
        this.customMenus.add((MergeMenu)new PrintMenu());
    }

    private Integer SafeParseInt(String string, Integer n) {
        return Integer.parseInt(string);
    }

    public void buildLegend(String ... stringArray) {
        this.legendGrid.removeAll();
        this.legendGrid.revalidate();
        if (stringArray.length == 0) {
            this.legendGrid.getParent().getParent().setVisible(false);
            return;
        }
        for (String string : stringArray) {
            String[] stringArray2 = string.trim().split(" ");
            int n = stringArray2.length;
            Integer n2 = this.SafeParseInt(stringArray2[n - 3], 0);
            Integer n3 = this.SafeParseInt(stringArray2[n - 2], 0);
            Integer n4 = this.SafeParseInt(stringArray2[n - 1], 0);
            Object object = "";
            for (int i = 1; i <= n - 3; ++i) {
                object = (String)object + stringArray2[i - 1] + " ";
            }
            ((String)object).trim();
            JLabel jLabel = new JLabel((String)object);
            jLabel.setOpaque(true);
            jLabel.setBackground(Color.WHITE);
            jLabel.setForeground(new Color(n2, n3, n4));
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jLabel.setHorizontalAlignment(0);
            jLabel.setPreferredSize(new Dimension(450, 20));
            jLabel.setMaximumSize(new Dimension(450, 20));
            this.legendGrid.add(jLabel);
        }
        this.legendGrid.getParent().getParent().setVisible(true);
    }

    protected void buildMenuBar() {
    }

    public MenuList getCustomMenus() {
        return this.customMenus;
    }

    protected abstract void createDrawnImage(Graphics2D var1);

    public String getFile() {
        return this.file;
    }

    public double getScale() {
        return this.scale;
    }

    public boolean isError() {
        if (!this.error.equals("")) {
            Dialogs.showError(this.error);
            return true;
        }
        return false;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.mainPanel.printAll(graphics);
        return 0;
    }

    public void printPanel() {
        this.job.setPrintable(this);
        if (this.job.printDialog()) {
            try {
                this.job.print();
                this.job = PrinterJob.getPrinterJob();
            }
            catch (PrinterException printerException) {
                printerException.printStackTrace();
            }
        }
    }

    protected abstract void readImageData();

    public void refresh() {
        Component[] componentArray;
        for (Component component : componentArray = this.getComponents()) {
            component.validate();
        }
        this.repaint();
    }

    public void setScale(int n) {
        this.scale = (double)n / 100.0;
    }

    public void setTopCaption(String string) {
        this.label.setText(string);
        this.repaint();
    }

    public void viewDialog() {
        this.pack();
        this.setVisible(true);
    }

    public void viewZoomDialog() {
        new ZoomDialog();
    }

    public void zoomImage() {
        if (this.scale < 0.05) {
            this.scale = 0.05;
        } else if (this.scale > 10.0) {
            this.scale = 10.0;
        }
        Dimension dimension = new Dimension((int)(this.imgSizeX * this.scale), (int)(this.imgSizeY * this.scale));
        this.mainPanel.setPreferredSize(dimension);
        this.mainPanel.setMinimumSize(dimension);
        this.mainPanel.setMaximumSize(dimension);
        this.mainPanel.setSize(dimension);
        this.repaint();
        this.refresh();
    }

    private class ZoomDialog
    extends ValueSelectionDialog {
        private static final long serialVersionUID = 20120802L;

        public ZoomDialog() {
            super("Zoom");
            Integer n = new Double(ImageDialog.this.scale * 100.0).intValue();
            NumberField.IntegerField integerField = new NumberField.IntegerField("Percent Magnification", n, 5, 1000);
            this.buildDialog("OK", integerField);
        }

        @Override
        public ActionListener createSelectionAction() {
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ImageDialog.this.setScale(Integer.parseInt(ZoomDialog.this.fields[0].getText()));
                    ImageDialog.this.zoomImage();
                    ZoomDialog.this.dispose();
                }
            };
        }
    }

    protected class PrintMenu
    extends MainMenu {
        private static final long serialVersionUID = 20120802L;

        public PrintMenu() {
            super("Print", 500);
            this.addItem("Print Image", "Print the current image.");
        }

        @Override
        protected void onMenuAction(String string, ActionEvent actionEvent) {
            ImageDialog.this.printPanel();
        }
    }
}

