/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI;

import java.awt.GraphicsEnvironment;
import java.awt.SplashScreen;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import ur_rna.RNAstructureUI.AppMainFrame;
import ur_rna.RNAstructureUI.RNAstructureBackendCalculator;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.MRUFileStorage;
import ur_rna.RNAstructureUI.utilities.Resources;
import ur_rna.RNAstructureUI.utilities.UserOptions;
import ur_rna.Utilities.AppLog;
import ur_rna.Utilities.DateHelper;
import ur_rna.Utilities.JniLoader;
import ur_rna.Utilities.OSInfo;
import ur_rna.Utilities.PathTools;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.annotation.ApplicationInfo;

@ApplicationInfo(name="RNAstructure", title="RNAstructure GUI", version="6.2")
public class RNAstructure
implements Serializable {
    private static final long serialVersionUID = 20120802L;
    public static final AppLog log = AppLog.getDefault();
    public static MRUFileStorage MRUFiles = new MRUFileStorage();
    public static UserOptions options = new UserOptions();
    public static String preferencesNode = "default";
    public static final String VERSION = "6.2";
    public static final String REQUIRED_DLL_VERSION = "6.2";
    public static final String RELEASE_DATE = "November 27, 2019";
    private static String examplesDir;

    public static void main(String[] stringArray) {
        try {
            RNAstructure.parseCommandArgs(stringArray);
            log.readSystemProperties();
            if (RNAstructure.options.useNativeLAF) {
                OSInfo.applyNativeLookAndFeel();
            }
            if (RNAstructure.options.useNativeMenus) {
                OSInfo.useNativeMenus();
            }
            log.debug("OS: %s Arch: %s Bits: %s%n", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("sun.arch.data.model"));
            log.debug("user.home: " + System.getProperty("user.home"));
            log.debug("user.dir: " + System.getProperty("user.dir"));
            log.debug("CurDir: " + new File(".").getCanonicalPath());
            log.debug("java.library.path: " + System.getProperty("java.library.path"));
            log.debug("java.class.path: " + System.getProperty("java.class.path"));
            if (log.isTraceEnabled()) {
                System.getProperties().list(log.getTrStream());
            }
            log.debug("Headless: " + GraphicsEnvironment.isHeadless());
            try {
                JniLoader jniLoader = new JniLoader("RNAstructure", RNAstructureBackendCalculator::getVersion, "6.2", "RNAstructure_GUI" + JniLoader.getJvmBits(), "RNAstructure_GUI");
                jniLoader.load();
            }
            catch (JniLoader.NativeLibLoadError nativeLibLoadError) {
                RNAstructure.showWarning(nativeLibLoadError.getMessage());
                System.exit(2);
                return;
            }
            options.load(RNAstructure.getPrefs().node("options"));
            Resources.verify();
            RNAstructure.verifyDataPath();
            StandardFileChooser.loadRecentPaths(RNAstructure.getPrefs().node("recent-file-locations"));
            RNAstructure.setDefaultFileOpenDir();
            MRUFiles.loadFromStorage();
            SplashScreen splashScreen = SplashScreen.getSplashScreen();
            if (splashScreen != null && !RNAstructure.silentMode()) {
                Thread.sleep(2000L);
            }
            new AppMainFrame();
        }
        catch (Exception exception) {
            log.error("error loading RNAstructure.", exception);
            try {
                FileWriter fileWriter = new FileWriter("RNAstructure_error.log");
                fileWriter.write(DateHelper.getFormattedDate(1) + "\n");
                exception.printStackTrace(new PrintWriter(fileWriter));
                fileWriter.flush();
                fileWriter.close();
            }
            catch (Throwable throwable) {
                RNAstructure.showWarning("Could not write error log:\n" + AppLog.getErrorInfo(throwable));
            }
            System.exit(10);
        }
    }

    public static Preferences getPrefs() {
        return Preferences.userNodeForPackage(RNAstructure.class).node(preferencesNode);
    }

    public static String getPref(String string) {
        return RNAstructure.getPref(string, null);
    }

    public static String getPref(String string, String string2) {
        Preferences preferences = RNAstructure.getPrefs();
        return preferences.get(string, string2);
    }

    public static void setPref(String string, String string2) {
        Preferences preferences = RNAstructure.getPrefs();
        preferences.put(string, string2);
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    private static void setDefaultFileOpenDir() {
        File file = RNAstructure.getExamplesDir();
        if (file != null) {
            StandardFileChooser.setDefaultDir(file);
        }
    }

    public static File getExamplesDir() {
        File file = StandardFileChooser.getRecentDir("examples", true);
        String[] stringArray = new String[]{"RNAstructureExamples", "RNAstructure-Examples", "RNAstructure-examples", "RNAstructure/Examples", "RNAstructure/examples", "examples"};
        if (file == null) {
            file = PathTools.getFirstExisting(OSInfo.getDocumentsDir(), true, false, stringArray);
        }
        if (file == null) {
            file = PathTools.getFirstExisting(new File(System.getProperty("user.home")), true, false, stringArray);
        }
        if (file == null) {
            file = PathTools.findLocalPath("examples");
        }
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    public static boolean silentMode() {
        return Strings.asBool(System.getProperty("silentLaunch"), false);
    }

    private static void parseCommandArgs(String[] stringArray) {
        try {
            block22: for (int i = 0; i < stringArray.length; ++i) {
                switch (stringArray[i].toLowerCase()) {
                    case "-d": {
                        System.setProperty("log-debug", "true");
                        System.setProperty("show-gui-info-menu", "true");
                        continue block22;
                    }
                    case "-s": {
                        System.setProperty("silentLaunch", "true");
                        continue block22;
                    }
                    case "-v": {
                        System.setProperty("log-verbosity", stringArray[++i]);
                    }
                    case "-sfc": {
                        AppMainFrame.setUseSimpleFileChooser(true);
                        continue block22;
                    }
                    case "-jlaf": {
                        RNAstructure.options.useNativeLAF = false;
                        continue block22;
                    }
                    case "-jmnu": {
                        RNAstructure.options.useNativeMenus = false;
                        continue block22;
                    }
                    case "-prefs": {
                        preferencesNode = stringArray[++i];
                        continue block22;
                    }
                    case "-opt": {
                        int n = stringArray[++i].indexOf(61);
                        if (n == -1) {
                            throw new InvalidPreferencesFormatException("The -opt flag requires an argument in the form \"name=value\".");
                        }
                        UserOptions.override(stringArray[i].substring(0, n), stringArray[i].substring(n + 1));
                        continue block22;
                    }
                    default: {
                        log.error("Unknown command-line option: \"%s\" (position: %s).", stringArray[i], i);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            log.error("error parsing command line.", throwable);
        }
    }

    static String findDataPath() {
        String[] stringArray = new String[]{".", "..", "./resources", "../Resources"};
        String[] stringArray2 = new String[]{"{path}/", "{path}/data_tables", "{app}/{path}/", "{app}/{path}/data_tables"};
        String string = "{*.specification,autodetect}.dat";
        String string2 = PathTools.getAppPath(RNAstructure.class);
        for (String string3 : stringArray) {
            String[] stringArray3 = stringArray2;
            int n = stringArray3.length;
            for (int i = 0; i < n; ++i) {
                File file;
                String string4;
                String string5 = string4 = stringArray3[i];
                if (string2 != null) {
                    string5 = string5.replace("{app}", string2);
                }
                if (!(file = new File(string5 = string5.replace("{path}", string3))).exists()) continue;
                try {
                    String string6 = file.getCanonicalPath();
                    if (!PathTools.anyFilesMatch(string6, string)) continue;
                    return string6;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    static String getFullPath(String string) {
        File file = new File(string);
        if (Strings.isEmpty(string)) {
            return "<EMPTY>";
        }
        if (file.exists()) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException iOException) {
                return "ERROR: " + iOException.getMessage();
            }
        }
        return "<File not found>";
    }

    static boolean fileExists(String string) {
        return new File(string).exists();
    }

    static boolean verifyDataPath() {
        String string = System.getenv("DATAPATH");
        if (string == null) {
            string = "";
        }
        if (string.contains("{APP_PATH}")) {
            String string2 = PathTools.getAppPath(RNAstructure.class);
            if (string2 == null) {
                string2 = ".";
            }
            log.debug("Using {APP_PATH} => " + string2);
            log.debug("Before replacement: DATAPATH=" + string);
            string = string.replace("{APP_PATH}", string2);
            log.debug("After replacement: DATAPATH=" + string);
            RNAstructure.setDataPath(string);
        }
        log.debug(String.format("DATAPATH='%s' (%s)", string, RNAstructure.getFullPath(string)));
        if (RNAstructure.fileExists(string)) {
            return true;
        }
        string = RNAstructure.findDataPath();
        if (string == null) {
            RNAstructure.showWarning("The thermodynamic data tables could not be found.\nPlease set the DATAPATH environment variable to the directory where they are stored.\n\t(e.g. <PATH-TO-RNAstructure>/data_tables).");
        } else {
            log.debug("The thermodynamic data tables were located at \"" + string + "\". The DATAPATH environment variable will be set to this location.");
            RNAstructure.setDataPath(string);
        }
        return string != null;
    }

    static String arrJoin(Object[] objectArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objectArray) {
            stringBuilder.append(object.toString());
            stringBuilder.append(string);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - string.length());
        }
        return stringBuilder.toString();
    }

    static void setDataPath(String string) {
        RNAstructureBackendCalculator.setEnvVar("DATAPATH=" + string);
        System.setProperty("DATAPATH", string);
        log.debug("DATAPATH Verification (setDataPath): " + RNAstructureBackendCalculator.getEnvVar("DATAPATH"));
    }

    static void showWarning(String string) {
        log.error("Warning: " + string);
        if (!RNAstructure.silentMode()) {
            Dialogs.showWarning(string, true);
        }
    }

    static void showInfo(String string) {
        log.info("Information: " + string);
        if (!RNAstructure.silentMode()) {
            Dialogs.showMessage(string);
        }
    }

    public static void ExtractExamples() {
        try {
            File file = PathTools.findLocalPath("examples");
            if (file == null) {
                Dialogs.showError("The example files source folder could not be found.");
                return;
            }
            File file2 = OSInfo.getDocumentsDir();
            Object object = new File(file2, "RNAstructure").exists() ? "/RNAstructure/Examples" : "RNAstructure-Examples";
            object = file2.getPath() + ((String)object).replace('/', File.separatorChar);
            String string = StandardFileChooser.getFileName(true, null, "Extract Examples Files", (String)object, "*", null);
            if (string == null) {
                return;
            }
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            File file3 = new File(string);
            if (!file3.mkdirs()) {
                throw new IOException("Failed to create requested directory: " + string);
            }
            Path path = file3.toPath();
            for (File file4 : fileArray) {
                try {
                    Files.copy(file4.toPath(), path.resolve(file4.getName()), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            StandardFileChooser.setRecentDir("examples", file3);
            StandardFileChooser.setDefaultDir(file3);
        }
        catch (Exception exception) {
            Dialogs.showError("Failed to extract example files: " + exception.toString());
        }
    }

    public static boolean isExampleFile(File file) {
        try {
            if (examplesDir == null) {
                File file2 = RNAstructure.getExamplesDir();
                examplesDir = file2 == null ? "<>" : file2.getCanonicalPath();
            }
            return examplesDir.equals(file.getCanonicalFile().getParent());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static int versionCompare(String string, String string2) {
        int n;
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        for (n = 0; n < stringArray.length && n < stringArray2.length && stringArray[n].equals(stringArray2[n]); ++n) {
        }
        if (n < stringArray.length && n < stringArray2.length) {
            int n2 = Integer.valueOf(stringArray[n]).compareTo(Integer.valueOf(stringArray2[n]));
            return Integer.signum(n2);
        }
        return Integer.signum(stringArray.length - stringArray2.length);
    }

    public static void createDocsFolder() {
        File file = new File(OSInfo.getDocumentsDir(), "RNAstructure");
        if (!file.exists()) {
            file.mkdirs();
        }
    }
}

