/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructure;

public class Nucleobase {
    public static final int Unknown = 0;
    public static final int A = 1;
    public static final int C = 2;
    public static final int G = 3;
    public static final int T = 4;
    public static final int Break = 5;
    public static final char[] rnaSymbols = new char[]{'X', 'A', 'C', 'G', 'U', 'I'};
    public static final char[] rnaSymbolsLc = new char[]{'x', 'a', 'c', 'g', 'u', 'i'};
    public static final char[] dnaSymbols = new char[]{'X', 'A', 'C', 'G', 'T', 'I'};
    public static final char[] dnaSymbolsLc = new char[]{'x', 'a', 'c', 'g', 't', 'i'};
    public static final char[] allowedSymbols = new char[]{'X', 'A', 'C', 'G', 'U', 'T', 'I', 'x', 'a', 'c', 'g', 'u', 't', 'i'};

    public static final String getSymbol(int n, boolean bl, boolean bl2) {
        char[] cArray;
        if (n < 0) {
            n = 0;
        }
        char[] cArray2 = bl ? (bl2 ? rnaSymbols : rnaSymbolsLc) : (cArray = bl2 ? dnaSymbols : dnaSymbolsLc);
        if (n >= cArray.length) {
            n = 0;
        }
        return Character.toString(cArray[n]);
    }

    public static final String getSymbol(int n, boolean bl) {
        return Nucleobase.getSymbol(n, bl, true);
    }

    public static final String getSymbol(int n) {
        return Nucleobase.getSymbol(n, true, true);
    }

    public static char getVerifiedSymbol(String string) {
        return Nucleobase.getVerifiedSymbol(string, 'X');
    }

    public static char getVerifiedSymbol(String string, char c) {
        if (string != null && string.length() == 1) {
            char c2 = string.charAt(0);
            for (char c3 : allowedSymbols) {
                if (c3 != c2) continue;
                return c2;
            }
        }
        return c;
    }
}

