/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.swing;

import java.awt.Component;
import java.awt.Container;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import ur_rna.Utilities.ObjTools;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.swing.IMenuItem;
import ur_rna.Utilities.swing.IMergeItem;
import ur_rna.Utilities.swing.Menus;

public class MergeManager {
    public static final Component[] EMPTY_COMPONENT_ARRAY = new Component[0];
    private Map<Component, Integer> mergePosMap = new HashMap<Component, Integer>();
    private Map<Container, Component[]> originalComponents = new HashMap<Container, Component[]>();
    private static final Integer DEFAULT_MERGE_POS = 0;

    public void reset() {
        for (Map.Entry<Container, Component[]> entry : this.originalComponents.entrySet()) {
            this.setComponents(entry.getKey(), entry.getValue());
        }
        this.originalComponents.clear();
    }

    private String getMergeName(Object object) {
        if (object instanceof IMergeItem) {
            return ((IMergeItem)object).getMergeName();
        }
        if (object instanceof AbstractButton) {
            return IMergeItem.getMergeName((Component)object);
        }
        if (object instanceof IMenuItem) {
            return ((IMenuItem)object).getItemName();
        }
        return null;
    }

    public boolean merge(Component component, Component component2) {
        Component[] componentArray;
        Component[] componentArray2;
        JComponent jComponent = Menus.getSubItemContainer(component);
        JComponent jComponent2 = Menus.getSubItemContainer(component2);
        if (jComponent == null) {
            throw new IllegalArgumentException("Cannot merge items into a Component that is not a Container and has no associated Container.");
        }
        if (jComponent == null || jComponent2.getComponentCount() == 0) {
            return false;
        }
        Component[] componentArray3 = jComponent.getComponents();
        boolean bl = this.mergeItems(componentArray3, componentArray2 = jComponent2.getComponents(), componentArray = new Component[componentArray3.length + componentArray2.length]);
        if (bl) {
            this.storeComponents(jComponent, componentArray3);
            this.storeComponents(jComponent2, componentArray2);
            this.setComponents(jComponent, componentArray);
        }
        return bl;
    }

    public boolean merge(Component component, Component[] componentArray) {
        Component[] componentArray2;
        JComponent jComponent = Menus.getSubItemContainer(component);
        if (jComponent == null) {
            throw new IllegalArgumentException("Cannot merge items into a Component that is not a Container and has no associated Container.");
        }
        if (componentArray.length == 0) {
            return false;
        }
        Component[] componentArray3 = jComponent.getComponents();
        boolean bl = this.mergeItems(componentArray3, componentArray, componentArray2 = new Component[componentArray3.length + componentArray.length]);
        if (bl) {
            this.storeComponents(jComponent, componentArray3);
            this.setComponents(jComponent, componentArray2);
        }
        return bl;
    }

    private boolean mergeItems(Component[] componentArray, Component[] componentArray2, Component[] componentArray3) {
        int n;
        boolean bl = false;
        String[] stringArray = new String[componentArray.length];
        for (n = 0; n < componentArray.length; ++n) {
            stringArray[n] = this.getMergeName(componentArray[n]);
        }
        System.arraycopy(componentArray, 0, componentArray3, 0, componentArray.length);
        n = componentArray.length;
        for (Component component : componentArray2) {
            int n2;
            String string = this.getMergeName(component);
            int n3 = n2 = Strings.isEmpty(string) ? -1 : ObjTools.indexOf(stringArray, string, true);
            if (n2 != -1 && Menus.getSubItemContainer(componentArray[n2]) != null) {
                this.merge(componentArray[n2], component);
                continue;
            }
            bl = true;
            componentArray3[n++] = component;
        }
        return bl;
    }

    public void sort(Component component) {
        int n = Integer.MIN_VALUE;
        JComponent jComponent = Menus.getSubItemContainer(component);
        if (jComponent == null) {
            throw new IllegalArgumentException("Cannot sort items in a Component that is not a Container and has no associated Container.");
        }
        int n2 = jComponent.getComponentCount();
        boolean bl = true;
        for (int i = 0; i < n2; ++i) {
            Component component2 = jComponent.getComponent(i);
            int n3 = IMergeItem.getValidMergePos(component2);
            if (n3 < n) {
                bl = false;
                break;
            }
            n = n3;
            if (!Menus.hasSubItems(component2)) continue;
            this.sort(component2);
        }
        if (!bl) {
            Component[] componentArray = jComponent.getComponents();
            Arrays.sort(componentArray, IMergeItem::compareByMergePos);
            this.setComponents(jComponent, componentArray);
        }
    }

    private void storeComponents(Container container, Component[] componentArray) {
        if (!this.originalComponents.containsKey(container)) {
            this.originalComponents.put(container, componentArray);
        }
    }

    private void setComponents(Container container, Component[] componentArray) {
        container.removeAll();
        for (Component component : componentArray) {
            if (component == null) continue;
            container.add(component);
        }
    }

    public void clearCache(Container container) {
        this.originalComponents.remove(container);
    }
}

