/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.swing;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public abstract class InputAdapter {

    public static abstract class Mouse
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.onMouseInput(InputType.Click, mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.onMouseInput(InputType.MouseDown, mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.onMouseInput(InputType.MouseUp, mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.onMouseInput(InputType.Enter, mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.onMouseInput(InputType.Exit, mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.onMouseInput(InputType.Drag, mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.onMouseInput(InputType.Move, mouseEvent);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.onMouseInput(InputType.Wheel, mouseWheelEvent);
        }

        public void listen(Component component) {
            this.listen(component, true, true, true);
        }

        public void remove(Component component) {
            component.removeMouseListener(this);
            component.removeMouseMotionListener(this);
            component.removeMouseWheelListener(this);
        }

        public void listen(Component component, boolean bl, boolean bl2, boolean bl3) {
            if (bl) {
                component.addMouseListener(this);
            }
            if (bl2) {
                component.addMouseMotionListener(this);
            }
            if (bl3) {
                component.addMouseWheelListener(this);
            }
        }

        protected abstract void onMouseInput(InputType var1, MouseEvent var2);
    }

    public static abstract class Keyboard
    implements KeyListener {
        @Override
        public void keyTyped(KeyEvent keyEvent) {
            this.onKeyInput(InputType.KeyTyped, keyEvent);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.onKeyInput(InputType.KeyDown, keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.onKeyInput(InputType.KeyUp, keyEvent);
        }

        public void listen(Component component) {
            component.addKeyListener(this);
        }

        protected abstract void onKeyInput(InputType var1, KeyEvent var2);
    }

    public static enum InputType {
        KeyDown,
        KeyUp,
        KeyTyped,
        MouseDown,
        MouseUp,
        Drag,
        Move,
        Wheel,
        Enter,
        Exit,
        Click;

    }
}

