/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

public class Version
implements Comparable<Version> {
    public final int Major;
    public final int Minor;
    public final int Revision;
    public final int Build;

    public Version(int n, int n2, int n3, int n4) {
        this.Major = n;
        this.Minor = n2;
        this.Revision = n3;
        this.Build = n4;
    }

    public Version(int n, int n2, int n3) {
        this(n, n2, n3, -1);
    }

    public Version(int n, int n2) {
        this(n, n2, -1, -1);
    }

    public Version(String string) throws IllegalArgumentException {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        String[] stringArray = string.split("\\.");
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("A version number must have at least two components.");
        }
        n = Integer.parseInt(stringArray[0]);
        n2 = Integer.parseInt(stringArray[1]);
        if (stringArray.length > 2) {
            n3 = Integer.parseInt(stringArray[2]);
        }
        if (stringArray.length > 3) {
            n4 = Integer.parseInt(stringArray[3]);
        }
        this.Major = n;
        this.Minor = n2;
        this.Revision = n3;
        this.Build = n4;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.Major).append('.').append(this.Minor);
        if (this.Revision != -1) {
            stringBuilder.append('.').append(this.Revision);
            if (this.Build != -1) {
                stringBuilder.append('.').append(this.Build);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(Version version) {
        if (this.Major != version.Major) {
            return this.Major < version.Major ? -1 : 1;
        }
        if (this.Minor != version.Minor) {
            return this.Minor < version.Minor ? -1 : 1;
        }
        if (this.Revision != version.Revision) {
            return this.Revision < version.Revision ? -1 : 1;
        }
        if (this.Build != version.Build) {
            return this.Build < version.Build ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version version = (Version)object;
        if (this.Major != version.Major) {
            return false;
        }
        if (this.Minor != version.Minor) {
            return false;
        }
        if (this.Revision != version.Revision) {
            return false;
        }
        return this.Build == version.Build;
    }

    public int hashCode() {
        int n = this.Major;
        n = 31 * n + this.Minor;
        n = 31 * n + this.Revision;
        n = 31 * n + this.Build;
        return n;
    }

    public static boolean isVersionCompatible(Version version, Version version2) {
        if (version2.Major != version.Major) {
            return false;
        }
        if (version2.Minor < version.Minor) {
            return false;
        }
        return version2.Minor > version.Minor || version2.Revision >= version.Revision;
    }

    public static boolean isVersionCompatible(String string, String string2) {
        String[] stringArray;
        String[] stringArray2 = string.split("\\.");
        int n = Math.min(stringArray2.length, (stringArray = string2.split("\\.")).length);
        if (n < 2) {
            throw new IllegalArgumentException("A version number must have at least two components.");
        }
        if (Integer.parseInt(stringArray[0]) != Integer.parseInt(stringArray2[0])) {
            return false;
        }
        if (Integer.parseInt(stringArray[1]) < Integer.parseInt(stringArray2[1])) {
            return false;
        }
        if (Integer.parseInt(stringArray[1]) > Integer.parseInt(stringArray2[1])) {
            return true;
        }
        return n == 2 || Integer.parseInt(stringArray[2]) >= Integer.parseInt(stringArray2[2]);
    }

    public boolean isEmpty() {
        return this.Major == 0 && this.Minor == 0 && this.Revision == -1 && this.Build == -1;
    }

    public static Version tryParse(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            return new Version(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return null;
        }
    }
}

