/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import ur_rna.Utilities.annotation.NotNull;
import ur_rna.Utilities.annotation.Nullable;

public final class PathTools {
    private static final String[] documentsDirs = "Documents documents".split(" ");
    private static String[] defaultLocalSearchSubDirs = new String[]{".", "..", "../.."};

    private PathTools() {
    }

    public static String getBaseName(String string) {
        return PathTools.getBaseName(string, false);
    }

    public static String getBaseName(String string, boolean bl) {
        return PathTools.parse(string, bl).baseName();
    }

    public static String getExt(String string) {
        return PathTools.getExt(string, true, false);
    }

    public static String getExt(String string, boolean bl, boolean bl2) {
        return PathTools.parse(string, bl2).ext(bl);
    }

    public static String getDir(String string) {
        return PathTools.parse(string).dir();
    }

    public static String getDir(String string, boolean bl) {
        return PathTools.parse(string).dir(bl);
    }

    public static FileName parse(String string) {
        return PathTools.parse(string, false);
    }

    public static FileName parse(String string, boolean bl) {
        return new FileName(string, bl);
    }

    @Nullable
    public static String getAppPath(Class clazz) {
        try {
            URL uRL = clazz.getProtectionDomain().getCodeSource().getLocation();
            File file = new File(uRL.toURI());
            return file.getParent();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static File getHomeDir() {
        File file = PathTools.fileFromPath(System.getProperty("user.home"), true);
        if (file == null) {
            file = PathTools.fileFromPath(System.getProperty("user.dir"), false);
        }
        return file;
    }

    public static File getDocumentsDir() {
        File file = PathTools.getHomeDir();
        try {
            if (!file.exists()) {
                return file;
            }
            Path path = file.toPath();
            for (String string : documentsDirs) {
                File file2 = path.resolve(string).toFile();
                if (!file2.isDirectory()) continue;
                return file2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return file;
    }

    public static File fileFromPath(String string) {
        return PathTools.fileFromPath(string, false);
    }

    public static File fileFromPath(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        return bl && !file.exists() ? null : file;
    }

    public static boolean verifyWritable(File file) {
        if (file == null) {
            throw new NullPointerException("In verifyWritable: file cannot be null.");
        }
        if (file.isDirectory()) {
            try {
                Path path = Files.createTempFile(file.toPath(), "~", ".tmp", new FileAttribute[0]);
                Files.delete(path);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return file.canWrite();
    }

    public static String changeExtension(String string, String string2) {
        return new FileName(string).changeExt(string2);
    }

    public static boolean exists(String string) {
        try {
            if (string != null) {
                return new File(string).exists();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isFile(String string) {
        try {
            if (string != null) {
                return new File(string).isFile();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isDir(String string) {
        try {
            if (string != null) {
                return new File(string).isDirectory();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Nullable
    public static File getFirstExisting(@Nullable File file, boolean bl, boolean bl2, String ... stringArray) {
        if (!bl && !bl2) {
            return null;
        }
        for (String string : stringArray) {
            File file2 = new File(file, string);
            if (!file2.exists()) continue;
            if (bl && bl2) {
                return file2;
            }
            if (bl != file2.isDirectory()) continue;
            return file2;
        }
        return null;
    }

    public static String addSlash(String string) {
        if (string.endsWith("/") || string.endsWith("\\") || string.endsWith(Character.toString(File.separatorChar))) {
            return string;
        }
        return string + File.separatorChar;
    }

    public static String getCanonicalPath(String string) {
        return PathTools.getCanonicalPath(string, false, false, false, false);
    }

    public static String getCanonicalPath(String object, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object2;
        if (object == null) {
            return null;
        }
        if (((String)object).length() == 0) {
            return object;
        }
        object = ((String)object).replace("\\", "/");
        if (bl3) {
            while (((String)object).startsWith("/")) {
                object = ((String)object).substring(1);
            }
        }
        if (bl && !((String)object).endsWith("/")) {
            object = (String)object + "/";
        }
        if (bl2 && ((String)object).endsWith("/") && ((String)object).length() > 1) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        Pattern pattern = Pattern.compile("([^/]?[^/.][^/])?/\\.\\./");
        Pattern pattern2 = Pattern.compile("([^/]?[^/.][^/])?/\\.\\.$");
        do {
            object2 = object;
            object = ((String)object).replace("//", "/");
            object = ((String)object).replace("/./", "/");
            object = pattern.matcher((CharSequence)object).replaceAll("/");
        } while (!((String)object2).equals(object = pattern2.matcher((CharSequence)object).replaceAll("")));
        if (bl4 && ((String)object).startsWith("./")) {
            object = ((String)object).substring(2);
        }
        return object;
    }

    public static boolean anyFilesMatch(String string, @NotNull String string2) {
        boolean bl;
        block8: {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(string, new String[0]), string2);
            try {
                Iterator<Path> iterator = directoryStream.iterator();
                bl = iterator.hasNext();
                if (directoryStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(String.format("Error reading folder %s: %s", string, iOException.getMessage()), iOException);
                }
            }
            directoryStream.close();
        }
        return bl;
    }

    public static List<File> listFiles(String string, @NotNull String string2) {
        ArrayList<File> arrayList;
        block9: {
            Path path = Paths.get(string, new String[0]);
            ArrayList<File> arrayList2 = new ArrayList<File>();
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, string2);
            try {
                for (Path path2 : directoryStream) {
                    arrayList2.add(path2.toFile());
                }
                arrayList = arrayList2;
                if (directoryStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(String.format("Error reading folder %s: %s", path, iOException.getMessage()), iOException);
                }
            }
            directoryStream.close();
        }
        return arrayList;
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getPath();
        }
    }

    public static File findLocalPath(String string) {
        return PathTools.findLocalPath(PathTools.class, string, defaultLocalSearchSubDirs);
    }

    public static File findLocalPath(Class clazz, String string, String ... stringArray) {
        String string2 = PathTools.getAppPath(clazz);
        if (string2 == null) {
            return null;
        }
        for (String string3 : stringArray) {
            Path path = Paths.get(string2, string3, string);
            File file = path.toFile();
            if (!file.exists()) continue;
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return file;
        }
        return null;
    }

    public static class FileName {
        private static String[] EMPTY_ARRAY = new String[0];
        public final String fullPath;
        private final int sepPos;
        private final int extPos;
        private static final Pattern reSlash = Pattern.compile("[/\\\\]");

        public boolean hasDir() {
            return this.sepPos != -1;
        }

        public boolean hasExt() {
            return this.extPos != -1;
        }

        public String ext() {
            return this.extPos == -1 ? "" : this.fullPath.substring(this.extPos);
        }

        public String ext(boolean bl) {
            return this.extPos == -1 ? "" : this.fullPath.substring(this.extPos + (bl ? 0 : 1));
        }

        public String dir() {
            return this.sepPos == -1 ? "" : this.fullPath.substring(0, this.sepPos + 1);
        }

        public String dir(boolean bl) {
            return this.sepPos == -1 ? "" : this.fullPath.substring(0, this.sepPos + (bl ? 1 : 0));
        }

        public String name() {
            return this.sepPos == -1 ? this.fullPath : this.fullPath.substring(this.sepPos + 1);
        }

        public String baseName() {
            return this.extPos == -1 ? this.name() : this.fullPath.substring(this.sepPos + 1, this.extPos);
        }

        public FileName(String string) {
            this(string, false);
        }

        public FileName(String string, boolean bl) {
            int n;
            this.fullPath = string;
            this.sepPos = Math.max(string.lastIndexOf(47), string.lastIndexOf(92));
            this.extPos = bl ? string.indexOf(46, this.sepPos + 1) : (this.sepPos == -1 ? string.lastIndexOf(46) : ((n = string.substring(this.sepPos + 1).lastIndexOf(46)) == -1 ? -1 : n + this.sepPos + 1));
        }

        public String[] splitDirs() {
            if (this.sepPos == -1) {
                return EMPTY_ARRAY;
            }
            if (this.sepPos == 0) {
                return new String[]{""};
            }
            return reSlash.split(this.fullPath.substring(0, this.sepPos));
        }

        public String removeExt() {
            return this.extPos == -1 ? this.fullPath : this.fullPath.substring(0, this.extPos);
        }

        public String changeExt(String string) {
            if (string == null || string.isEmpty()) {
                return this.removeExt();
            }
            if (string.charAt(0) == '.') {
                return this.removeExt() + string;
            }
            return this.removeExt() + "." + string;
        }
    }
}

