/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import ur_rna.Utilities.annotation.NotNull;

public abstract class EventSource<TSubscriber> {
    private final Manager manager;

    public EventSource() {
        this(new Manager());
    }

    public EventSource(Manager manager) {
        this.manager = manager;
    }

    public Manager getManager() {
        return this.manager;
    }

    protected void invoke(Consumer<TSubscriber> consumer) {
        for (Object t : this.manager.get(this)) {
            consumer.accept(t);
        }
    }

    public boolean add(@NotNull TSubscriber TSubscriber) {
        return this.manager.add(this, TSubscriber);
    }

    public boolean remove(TSubscriber TSubscriber) {
        return this.manager.rem(this, TSubscriber);
    }

    public static class TwoArgs<TArg1, TArg2>
    extends EventSource<BiConsumer<TArg1, TArg2>> {
        public void invoke(TArg1 TArg1, TArg2 TArg2) {
            super.invoke(biConsumer -> biConsumer.accept(TArg1, TArg2));
        }
    }

    public static class OneArg<TArg>
    extends EventSource<Consumer<TArg>> {
        public void invoke(TArg TArg) {
            super.invoke(consumer -> consumer.accept(TArg));
        }
    }

    public static class NoArg
    extends EventSource<Runnable> {
        public void invoke() {
            super.invoke(Runnable::run);
        }
    }

    public static class Manager {
        private ArrayList<Subscriber> subscribers = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> boolean add(EventSource<T> eventSource, T t) {
            Manager manager = this;
            synchronized (manager) {
                if (this.subscribers == null) {
                    this.subscribers = new ArrayList();
                }
                return this.subscribers.add(new Subscriber(eventSource, t));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> boolean rem(EventSource<T> eventSource, T t) {
            Manager manager = this;
            synchronized (manager) {
                if (this.subscribers == null) {
                    return false;
                }
                int n = this.subscribers.size();
                for (int i = 0; i < n; ++i) {
                    if (this.subscribers.get((int)i).event != eventSource || this.subscribers.get((int)i).handler != t) continue;
                    this.subscribers.remove(i);
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> List<T> get(EventSource<T> eventSource) {
            Manager manager = this;
            synchronized (manager) {
                ArrayList<Object> arrayList = null;
                if (this.subscribers != null) {
                    for (Subscriber subscriber : this.subscribers) {
                        if (subscriber.event != eventSource) continue;
                        if (arrayList == null) {
                            arrayList = new ArrayList<Object>();
                        }
                        arrayList.add(subscriber.handler);
                    }
                }
                return arrayList == null ? Collections.emptyList() : arrayList;
            }
        }

        private static class Subscriber {
            public final Object handler;
            public final Object event;

            public <T> Subscriber(EventSource<T> eventSource, T t) {
                this.handler = t;
                this.event = eventSource;
            }
        }
    }
}

