/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class ConsoleTools {
    private static OutputStream lastStream = null;
    private static boolean isFixed = false;

    public static void fixConsole() {
        if (isFixed) {
            return;
        }
        isFixed = true;
        System.setErr(new PrintStream(new FixedStream(System.err)));
        System.setOut(new PrintStream(new FixedStream(System.out)));
    }

    private static class FixedStream
    extends OutputStream {
        private final OutputStream target;

        public FixedStream(OutputStream outputStream) {
            this.target = outputStream;
        }

        @Override
        public void write(int n) throws IOException {
            if (lastStream != this) {
                this.swap();
            }
            this.target.write(n);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            if (lastStream != this) {
                this.swap();
            }
            this.target.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (lastStream != this) {
                this.swap();
            }
            this.target.write(byArray, n, n2);
        }

        private void swap() throws IOException {
            if (lastStream != null) {
                lastStream.flush();
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            lastStream = this;
        }

        @Override
        public void close() throws IOException {
            this.target.close();
        }

        @Override
        public void flush() throws IOException {
            this.target.flush();
        }
    }
}

