/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ur_rna.Utilities.CommandLineSplitter;
import ur_rna.Utilities.KeyAlreadyExistsException;
import ur_rna.Utilities.Pair;
import ur_rna.Utilities.StringBuilderEx;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.SyntaxErrorException;
import ur_rna.Utilities.annotation.NotNull;

public class CommandLineParser {
    private final HashMap<String, FlagDef> flagDefMap = new HashMap();
    public final boolean ignoreFlagCase;
    public boolean defaultAllowRepeatFlags;
    public ParamAffinity defaultParamAffinity;
    public boolean allowUndefinedFlags;

    public CommandLineParser() {
        this(false);
    }

    public CommandLineParser(boolean bl) {
        this(bl, ParamAffinity.FORBIDDEN, false);
    }

    public CommandLineParser(boolean bl, ParamAffinity paramAffinity, boolean bl2) {
        this.ignoreFlagCase = bl;
        this.defaultParamAffinity = paramAffinity;
        this.defaultAllowRepeatFlags = bl2;
    }

    public FlagDef addFlag(String string, boolean bl) {
        ParamAffinity paramAffinity = this.defaultParamAffinity == ParamAffinity.FORBIDDEN ? ParamAffinity.FORBIDDEN : ParamAffinity.OPTIONAL;
        return this.addFlag(string, bl ? ParamAffinity.REQUIRED : paramAffinity, this.defaultAllowRepeatFlags, new String[0]);
    }

    public FlagDef addFlag(String ... stringArray) {
        return this.addFlag(stringArray[0], this.defaultParamAffinity, this.defaultAllowRepeatFlags, Arrays.copyOfRange(stringArray, 1, stringArray.length));
    }

    public FlagDef addFlag(String string, ParamAffinity paramAffinity, boolean bl, String ... stringArray) {
        FlagDef flagDef = new FlagDef(string, paramAffinity, bl, stringArray);
        this.addFlag(flagDef);
        return flagDef;
    }

    public void addFlag(FlagDef flagDef) {
        if (flagDef.name != null) {
            this.addFlagAlias(flagDef, flagDef.name);
        }
        if (flagDef.aliases != null) {
            for (String string : flagDef.aliases) {
                this.addFlagAlias(flagDef, string);
            }
        }
    }

    public void addFlagAlias(String string, String string2) {
        FlagDef flagDef = this.findFlagDef(string, true);
        if (string == null) {
            throw new IllegalArgumentException(Strings.fmt("No flag has been defined with the name '%s'.", string));
        }
        this.addFlagAlias(flagDef, string2);
    }

    public void addFlagAlias(FlagDef flagDef, String string) {
        FlagDef flagDef2 = this.flagDefMap.putIfAbsent(string, flagDef);
        if (flagDef2 != null && flagDef2 != flagDef) {
            throw new KeyAlreadyExistsException(Strings.fmt("The alias '%s' is already associated with the %s flag.", string, flagDef2.name)).initDetails(string, flagDef2);
        }
    }

    public void addFlags(String ... stringArray) {
        for (String string : stringArray) {
            this.addFlag(string, false);
        }
    }

    public void addFlagsWithParams(String ... stringArray) {
        for (String string : stringArray) {
            this.addFlag(string, true);
        }
    }

    public FlagDef findFlagDef(String string) {
        return this.flagDefMap.get(this.normalizeFlagName(string));
    }

    public FlagDef findFlagDef(String string, boolean bl) {
        FlagDef flagDef = this.flagDefMap.get(this.normalizeFlagName(string));
        if (flagDef == null && bl && !this.allowUndefinedFlags) {
            throw new IllegalArgumentException("The flag '" + string + "' has not been defined.");
        }
        return flagDef;
    }

    public Set<FlagDef> getFlagDefinitions() {
        return new HashSet<FlagDef>(this.flagDefMap.values());
    }

    public List<FlagDef> parseFlagDefs(String string) throws SyntaxErrorException {
        return this.parseFlagDefs(string, true);
    }

    public List<FlagDef> parseFlagDefs(String string, boolean bl) throws SyntaxErrorException {
        String[] stringArray = string.split(" +");
        if (stringArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<FlagDef> arrayList = new ArrayList<FlagDef>(stringArray.length);
        for (String string2 : stringArray) {
            String string3;
            String string4 = "";
            ParamAffinity paramAffinity = this.defaultParamAffinity;
            boolean bl2 = this.defaultAllowRepeatFlags;
            int n = string2.indexOf(58);
            if (n == -1) {
                string3 = string2;
            } else {
                string3 = string2.substring(0, n);
                if (++n < string2.length()) {
                    string4 = string2.substring(n);
                }
                block8: for (String string5 : (String[])string4.toUpperCase().toCharArray()) {
                    switch (string5) {
                        case 63: 
                        case 79: {
                            paramAffinity = ParamAffinity.OPTIONAL;
                            continue block8;
                        }
                        case 33: 
                        case 82: {
                            paramAffinity = ParamAffinity.REQUIRED;
                            continue block8;
                        }
                        case 47: 
                        case 70: 
                        case 88: {
                            paramAffinity = ParamAffinity.FORBIDDEN;
                            continue block8;
                        }
                        case 42: 
                        case 43: 
                        case 77: {
                            bl2 = true;
                            continue block8;
                        }
                        case 49: {
                            bl2 = false;
                            continue block8;
                        }
                        default: {
                            throw new SyntaxErrorException("Invalid flag definition option.", Character.toString((char)string5), "in the definition of " + string3);
                        }
                    }
                }
            }
            String[] stringArray2 = string3.split(",");
            if (stringArray2.length == 0 || stringArray2[0].trim().length() == 0) {
                throw new SyntaxErrorException("No aliases specified for flag.", string2, "in the definition of flag " + arrayList.size() + "1");
            }
            String string6 = stringArray2[0];
            stringArray2 = Arrays.copyOfRange(stringArray2, 1, stringArray2.length);
            arrayList.add(new FlagDef(string6, paramAffinity, bl2, stringArray2));
        }
        if (bl) {
            for (FlagDef flagDef : arrayList) {
                this.addFlag(flagDef);
            }
        }
        return arrayList;
    }

    public ParseResults parse(String string) throws SyntaxErrorException {
        return this.parse(CommandLineSplitter.split(string));
    }

    public ParseResults parse(String[] stringArray) throws SyntaxErrorException {
        ArrayList<Argument> arrayList = new ArrayList<Argument>(stringArray.length);
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = stringArray[i];
            Object object2 = object;
            if (((String)object2).startsWith("-")) {
                Pair<String, String> pair = this.splitFlagValue(this.removeFlagPrefix((String)object2));
                FlagDef flagDef = this.findFlagDef((String)pair.key);
                if (flagDef == null) {
                    if (this.allowUndefinedFlags) {
                        flagDef = this.addFlag((String)pair.key, this.defaultParamAffinity, this.defaultAllowRepeatFlags, new String[0]);
                    } else {
                        throw new SyntaxErrorException("Invalid flag or option.", (String)pair.key, "at argument " + (i + 1));
                    }
                }
                String string = (String)pair.value;
                if (flagDef.paramAffinity == ParamAffinity.REQUIRED) {
                    if (string == null) {
                        if (i + 1 >= stringArray.length) {
                            throw new SyntaxErrorException(String.format("The flag '%s' requires a parameter.", flagDef.name), (String)object2, "at the end of the argument list.");
                        }
                        string = stringArray[++i];
                        object = (String)object + " " + string;
                    }
                } else if (flagDef.paramAffinity == ParamAffinity.FORBIDDEN && string != null) {
                    throw new SyntaxErrorException(String.format("The flag '%s' does not accept a parameter value.", flagDef.name), (String)object2, "at argument " + (i + 1));
                }
                arrayList.add(new FlagArg((String)object, n++, flagDef, (String)pair.key, string, string));
                continue;
            }
            arrayList.add(new UnnamedArg((String)object, n++));
        }
        return new ParseResults(this, arrayList);
    }

    private Pair<String, String> splitFlagValue(String string) {
        int n;
        int n2 = string.indexOf(61);
        int n3 = Math.min(n2, n = string.indexOf(58));
        if (n3 == -1) {
            return new Pair<String, Object>(string, null);
        }
        return new Pair<String, String>(string.substring(0, n3), string.substring(n3 + 1, string.length()));
    }

    public String normalizeFlagName(String string) {
        String string2 = this.removeFlagPrefix(string);
        return this.ignoreFlagCase ? string2.toLowerCase() : string2;
    }

    public String removeFlagPrefix(String string) {
        return string.startsWith("-") ? string.substring(1) : string;
    }

    public String addFlagPrefix(String string) {
        return string.startsWith("-") ? string : "-" + string;
    }

    public String getUsageMessage() {
        StringBuilderEx stringBuilderEx = new StringBuilderEx();
        Set<FlagDef> set = this.getFlagDefinitions();
        HashSet<String> hashSet = new HashSet<String>(4);
        for (FlagDef flagDef : set) {
            hashSet.clear();
            hashSet.add(flagDef.name);
            hashSet.addAll(Arrays.asList(flagDef.aliases));
            for (Map.Entry<String, FlagDef> entry : this.flagDefMap.entrySet()) {
                if (entry.getValue() != flagDef) continue;
                hashSet.add(entry.getKey());
            }
            stringBuilderEx.append("Flag Names: ");
            for (String string : hashSet) {
                stringBuilderEx.append(this.addFlagPrefix(string));
                stringBuilderEx.append(", ");
            }
            stringBuilderEx.truncate(2);
            stringBuilderEx.append(";\tParameter: " + flagDef.paramAffinity.toString());
            stringBuilderEx.append(";\tRepeats: " + (flagDef.allowRepeats ? "yes" : "no"));
            stringBuilderEx.append('\n');
        }
        return stringBuilderEx.toString();
    }

    public static class ParseResults {
        public final CommandLineParser parser;
        public final List<Argument> arguments;
        public final List<FlagArg> flags;
        public final List<UnnamedArg> unnamed;
        private List<String> unnamedValues;

        public ParseResults(CommandLineParser commandLineParser, List<Argument> list) {
            this.parser = commandLineParser;
            this.arguments = list;
            this.flags = new ArrayList<FlagArg>();
            this.unnamed = new ArrayList<UnnamedArg>();
            for (Argument argument : this.arguments) {
                if (argument instanceof FlagArg) {
                    this.flags.add((FlagArg)argument);
                    continue;
                }
                if (!(argument instanceof UnnamedArg)) continue;
                this.unnamed.add((UnnamedArg)argument);
            }
        }

        public FlagArg getFlag(String string) {
            FlagDef flagDef = this.parser.findFlagDef(string, true);
            if (flagDef == null) {
                return null;
            }
            for (FlagArg flagArg : this.flags) {
                if (flagArg.flag != flagDef) continue;
                return flagArg;
            }
            return null;
        }

        public String getFlagValue(String string) {
            FlagArg flagArg = this.getFlag(string);
            if (flagArg == null) {
                return null;
            }
            return flagArg.valueText;
        }

        public boolean hasFlag(String string) {
            return this.getFlag(string) != null;
        }

        public boolean hasAnyFlag(String ... stringArray) {
            for (String string : stringArray) {
                if (!this.hasFlag(string)) continue;
                return true;
            }
            return false;
        }

        public boolean foundAllFlags(String ... stringArray) {
            for (String string : stringArray) {
                if (this.hasFlag(string)) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public List<String> getUnnamedValues() {
            if (this.unnamedValues == null) {
                this.unnamedValues = new ArrayList<String>(this.unnamed.size());
                for (UnnamedArg unnamedArg : this.unnamed) {
                    this.unnamedValues.add(unnamedArg.fullText);
                }
            }
            return this.unnamedValues;
        }
    }

    public static class FlagDef {
        public static final String[] NO_ALIASES = new String[0];
        public final String name;
        public final String[] aliases;
        public final ParamAffinity paramAffinity;
        public final boolean allowRepeats;

        public FlagDef(String string, ParamAffinity paramAffinity, boolean bl) {
            this(string, paramAffinity, bl, NO_ALIASES);
        }

        public FlagDef(String string, ParamAffinity paramAffinity, boolean bl, String ... stringArray) {
            this.name = string;
            this.paramAffinity = paramAffinity;
            this.allowRepeats = bl;
            this.aliases = stringArray == null || stringArray.length == 0 ? NO_ALIASES : stringArray;
        }
    }

    public static class UnnamedArg
    extends Argument {
        public UnnamedArg(String string, int n) {
            super(string, n);
        }
    }

    public static class FlagArg
    extends Argument {
        public final String flagText;
        public final FlagDef flag;
        public final String valueText;
        public final Object parsedValue;

        public FlagArg(String string, int n, FlagDef flagDef, String string2, String string3, Object object) {
            super(string, n);
            this.flag = flagDef;
            this.flagText = string2;
            this.valueText = string3;
            this.parsedValue = object;
        }
    }

    public static abstract class Argument {
        public final String fullText;
        public final int position;

        protected Argument(String string, int n) {
            this.fullText = string;
            this.position = n;
        }
    }

    public static enum ParamAffinity {
        REQUIRED,
        OPTIONAL,
        FORBIDDEN;

    }
}

