/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import ur_rna.RNAstructure.RnaBackendException;
import ur_rna.StructureEditor.AppActions;
import ur_rna.StructureEditor.FileType;
import ur_rna.StructureEditor.Program;
import ur_rna.StructureEditor.models.Bond;
import ur_rna.StructureEditor.models.BondType;
import ur_rna.StructureEditor.models.DrawSettings;
import ur_rna.StructureEditor.models.HistoryUpdateEvent;
import ur_rna.StructureEditor.models.Motif;
import ur_rna.StructureEditor.models.Nuc;
import ur_rna.StructureEditor.models.RnaScene;
import ur_rna.StructureEditor.models.RnaSceneGroup;
import ur_rna.StructureEditor.models.SceneUpdateInfo;
import ur_rna.StructureEditor.services.RnaDrawController;
import ur_rna.StructureEditor.services.SceneColorizer;
import ur_rna.StructureEditor.services.SceneUpdateEvent;
import ur_rna.StructureEditor.services.drawing.NucLayout;
import ur_rna.StructureEditor.services.drawing.View2D;
import ur_rna.StructureEditor.services.drawing.export.Graphics2DRecorder;
import ur_rna.StructureEditor.services.drawing.export.PageSize;
import ur_rna.StructureEditor.services.drawing.export.SvgGraphicsExporter;
import ur_rna.StructureEditor.services.fileIO.RnaFileIO;
import ur_rna.StructureEditor.ui.DrawPanel;
import ur_rna.StructureEditor.windows.ChildFrame;
import ur_rna.StructureEditor.windows.ColorizeDialog;
import ur_rna.StructureEditor.windows.InsertBasesDialog;
import ur_rna.Utilities.Colors;
import ur_rna.Utilities.PathTools;
import ur_rna.Utilities.StopWatch;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.swing.AcceleratorKey;
import ur_rna.Utilities.swing.ButtonGroupList;
import ur_rna.Utilities.swing.Dialogs;
import ur_rna.Utilities.swing.FileDialog;
import ur_rna.Utilities.swing.ImageUtil;
import ur_rna.Utilities.swing.MergeButton;
import ur_rna.Utilities.swing.MergeMenu;
import ur_rna.Utilities.swing.MergeToggleButton;
import ur_rna.Utilities.swing.UiAction;

public class DrawWindow
extends ChildFrame {
    private JScrollPane scrollPane;
    private DrawPanel panel;
    public final RnaDrawController controller = new RnaDrawController();
    private List<MergeMenu> menus = new ArrayList<MergeMenu>();
    private MergeMenu structureMenu = new MergeMenu("Choose &Structure");
    private MergeMenu formatBondType;
    private ButtonGroupList structureList = new ButtonGroupList();
    private ToolButtonList toolButtons = new ToolButtonList();
    private RnaSceneGroup scenes;
    private RnaScene currentScene;
    private SceneInfo[] sceneInfo;
    private NucLayout layout;
    private JButton structureMenuToolbarButton;
    private AbstractButton btnSelModeNuc;
    private AbstractButton btnSelModeHelix;
    private AbstractButton btnSelModeBranch;
    private DrawSettings drawSettings;
    private Timer asyncUpdateTimer;
    private JPanel pnlTaskProgress;
    private JLabel lblTaskStatus;
    private JProgressBar prgTaskProgress;
    private JLabel lblTaskProgress;
    private RnaFileIO.AsyncTask _asyncTask;
    RnaDrawController.SelectionType selType = RnaDrawController.SelectionType.Individual;
    UiAction actionSave = new UiAction("&Save Drawing", actionEvent -> this.save(FileType.NsdDrawing, false, false), (Icon)Program.getIcon("save-drawing")).setKeyStroke("*S");
    UiAction actionSaveAs = new UiAction("&Save As..", actionEvent -> this.save(FileType.NsdDrawing, true, false), (Icon)Program.getIcon("save-as")).setKeyStroke("*+S");
    UiAction actionExport = new UiAction("&Export (Image, FASTA, CT, etc)", actionEvent -> this.save(FileType.AnySaveable, true, true), (Icon)Program.getIcon("export-as")).setKeyStroke("*+E");
    UiAction actionClose = new UiAction("Close &Window", this::close).setKeyStroke("*W");
    UiAction actionEditUndo = new UiAction("&Undo", this.controller::undo, (Icon)Program.getIcon("edit-undo")).setKeyStroke("*Z");
    UiAction actionEditRedo = new UiAction("&Redo", this.controller::redo, (Icon)Program.getIcon("edit-redo")).setKeyStroke("*Y");
    UiAction actionSelectAll = new UiAction("Select &All", this.controller::selectAll).setKeyStroke("*A");
    UiAction actionSelectExpand = new UiAction("&Expand Selection", this.controller::expandSelection, (Icon)Program.getIcon("edit-sel-expand")).setKeyStroke(" ");
    UiAction actionSelectNuc = new UiAction("Select &Individual Nucleotides", actionEvent -> this.setSelMode(RnaDrawController.SelectionType.Individual), (Icon)Program.getIcon("edit-sel-single")).setKeyStroke("N");
    UiAction actionSelectHelix = new UiAction("Select &Helices and Loops", actionEvent -> this.setSelMode(RnaDrawController.SelectionType.HelixOrLoop), (Icon)Program.getIcon("edit-sel-helix")).setKeyStroke("H");
    UiAction actionSelectBranch = new UiAction("Select &Branches", actionEvent -> this.setSelMode(RnaDrawController.SelectionType.Branch), (Icon)Program.getIcon("edit-sel-branch")).setKeyStroke("B");
    UiAction actionZoomAuto = new UiAction("&Auto-Fit", this::autoScale, (Icon)Program.getIcon("zoom-fit")).setKeyStroke("*V");
    UiAction actionZoomIn = new UiAction("&Zoom In", actionEvent -> this.panel.zoom(1), (Icon)Program.getIcon("zoom-in")).setKeyStroke("*EQUALS").setKeyStroke("*UP");
    UiAction actionZoomOut = new UiAction("Zoom &Out", actionEvent -> this.panel.zoom(-1), (Icon)Program.getIcon("zoom-out")).setKeyStroke("*MINUS").setKeyStroke("*DOWN");
    UiAction actionZoomReset = new UiAction("&Reset Zoom", actionEvent -> {
        this.panel.setScale(1.0f);
        this.panel.resetOffset();
    }, (Icon)Program.getIcon("zoom-reset")).setKeyStroke("*0");
    UiAction actionChooseStructure = new UiAction("&Choose Structure", this::showStructureMenu, (Icon)Program.getIcon("structure-choose"));
    UiAction actionNextStructure = new UiAction("&Next Structure", this::showNextStructure, (Icon)Program.getIcon("structure-next")).setKeyStroke("*RIGHT");
    UiAction actionPrevStructure = new UiAction("&Previous Structure", this::showPrevStructure, (Icon)Program.getIcon("structure-prev")).setKeyStroke("*LEFT");
    UiAction actionShowEnergy = new UiAction("&Calculate Energy", this::showCalcEnergy).setKeyStroke("*E");
    UiAction actionIdentifyPseudoKnots = new UiAction("&Identify Pseudo-Knot Bonds", this::findPseudoKnots);
    UiAction actionSetBondTypePseduo = new UiAction("&Pseudo-Knot Bond", () -> this.setSelectedBondType(BondType.Pseudo), (Icon)Program.getIcon("edit-bond-pseudo"));
    UiAction actionSetBondTypeNormal = new UiAction("&Normal Basepair", () -> this.setSelectedBondType(BondType.Default), (Icon)Program.getIcon("edit-bond-normal"));
    UiAction actionSetBondTypeForced = new UiAction("&Forced pair (Folding Contstraint)", () -> this.setSelectedBondType(BondType.Forced), (Icon)Program.getIcon("edit-bond-forced"));
    UiAction actionSetBondTypeBanned = new UiAction("Forbi&dden pair (Folding Contstraint)", () -> this.setSelectedBondType(BondType.Prohibited), (Icon)Program.getIcon("edit-bond-banned"));
    UiAction actionSetBondTypeSpecial = new UiAction("Special pair (alternate color)", () -> this.setSelectedBondType(BondType.Special), (Icon)Program.getIcon("edit-bond-special"));
    UiAction actionBreakBonds = new UiAction("Remove Basepairs (on selected bases)", this.controller::breakSelectedBonds, (Icon)Program.getIcon("edit-rem-bonds")).setKeyStroke("DELETE");
    UiAction actionSplitStrand = new UiAction("&Split Strand (after each selected base)", this.controller::splitStrandsAtSelection, (Icon)Program.getIcon("edit-split-strand"));
    UiAction actionJoinStrands = new UiAction("&Join Selected Strands", this.controller::joinSelectionStrands, (Icon)Program.getIcon("edit-join-strand"));
    UiAction actionRemoveNucs = new UiAction("Delete Selected Bases", this.controller::deleteSelectedBases, (Icon)Program.getIcon("edit-rem-nucs"));
    UiAction actionInsertNucs = new UiAction("&Insert Bases", this::insertBases, (Icon)Program.getIcon("edit-insert-nucs"));
    UiAction actionEditNucs = new UiAction("Edit Selected Bases (change base type)", this::editSelectedBases, (Icon)Program.getIcon("edit-base"));
    UiAction actionFold = new UiAction("&Fold Sequence", this::foldSequence, (Icon)Program.getIcon("edit-fold")).setKeyStroke("*+F");
    UiAction actionFormatColor = new UiAction("&Color-Annotate Bases", this::showColorizeDialog, (Icon)Program.getIcon("format-color")).setKeyStroke("*F");
    UiAction actionFormatRemoveColor = new UiAction("Remove Color A&nnotations from Selected Bases", actionEvent -> this.controller.removeColors(false), (Icon)Program.getIcon("format-remove-color"));
    UiAction actionFormatRemoveAllColor = new UiAction("Remove &ALL Color Annotations", actionEvent -> this.controller.removeColors(true), (Icon)Program.getIcon("format-remove-color"));
    UiAction actionColorHelices = new UiAction("Color &Helices", this::findHelices);
    UiAction actionRedraw = new UiAction("&Redraw", this::redrawScene, (Icon)Program.getIcon("edit-redraw")).setKeyStroke("*R");
    UiAction actionRedrawCirc = new UiAction("Redraw C&ircular", this::redrawCircular, (Icon)Program.getIcon("edit-redraw-circ")).setKeyStroke("*+R");
    UiAction actionRedrawLinear = new UiAction("Redraw &Linear", this::redrawLinear, (Icon)Program.getIcon("edit-redraw-linear")).setKeyStroke("*+L");
    UiAction actionFlipScene = new UiAction("&Flip Scene", actionEvent -> this.controller.flip(true, false), (Icon)Program.getIcon("layout-flip-scene")).setDesc("Flipping a scene is equivalent to converting between Clockwise and Counter-Clockwise layouts.");
    UiAction actionLocalRedraw = new UiAction("&Repair Selected Helices and Closed-Loops", actionEvent -> this.controller.redrawSelection()).setKeyStroke("R").setDesc("Every helix in which at least one base is selected will be \"repaired\" by lining up its bases.\nEvery closed loop in which at least one base is selected will be arranged into an optimal-sized loop with branches spaced according to intervening nucleotides.");
    UiAction actionFormatRotateNumber = new UiAction("Rotate Number Label", this.controller::rotateNumber).setKeyStroke("*K");
    UiAction testAction = new UiAction("Test Operation", this::test).setKeyStroke("*F12");

    public void setSelMode(RnaDrawController.SelectionType selectionType) {
        UiAction uiAction;
        this.controller.setSelType(selectionType);
        switch (selectionType) {
            case Branch: {
                uiAction = this.actionSelectBranch;
                break;
            }
            case HelixOrLoop: {
                uiAction = this.actionSelectHelix;
                break;
            }
            case Individual: {
                uiAction = this.actionSelectNuc;
                break;
            }
            default: {
                uiAction = null;
            }
        }
        if (uiAction == null) {
            UiAction.setSelected(uiAction, false);
        }
        if (!UiAction.isSelected(uiAction)) {
            UiAction.setSelected(uiAction, true);
        }
    }

    public RnaSceneGroup getScenes() {
        return this.scenes;
    }

    public RnaScene getCurrentScene() {
        return this.currentScene;
    }

    public void loadFile(RnaSceneGroup rnaSceneGroup) {
        this.scenes = rnaSceneGroup;
        this.sceneInfo = new SceneInfo[this.scenes.size()];
        this.buildStructureMenu();
        this.loadScene((RnaScene)this.scenes.get(0));
    }

    public DrawWindow() {
        super("Untitled Drawing", true);
        this.setSize(600, 500);
        this.setLocation(0, 0);
        this.panel = new DrawPanel();
        this.drawSettings = Program.getInstance().settings().getDrawSettings();
        this.layout = new NucLayout(this.drawSettings);
        this.controller.setSettings(this.drawSettings);
        this.controller.setCanvas(this.panel);
        this.panel.setRenderer(this.controller);
        this.panel.setPreferredSize(new Dimension(200, 200));
        this.controller.programSettingsChanged(Program.getInstance().settings());
        this.createUI();
        this.createMenus();
        this.createToolButtons();
        this.controller.sceneUpdated.add(this::onSceneUpdate);
        this.controller.historyEvent.add(this::onHistoryUpdate);
        this.panel.viewChanged.add(this::updateFileUI);
        AdjustmentListener adjustmentListener = adjustmentEvent -> this.panel.updateView();
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(adjustmentListener);
        this.scrollPane.getHorizontalScrollBar().addAdjustmentListener(adjustmentListener);
        this.panel.setFocusable(true);
        this.setSelMode(RnaDrawController.SelectionType.Individual);
        this.loadSettings();
        this.updateFileUI();
        AcceleratorKey.resetTabTraversalKeys(this);
        AcceleratorKey.resetTabTraversalKeys(this.panel);
        AcceleratorKey.resetTabTraversalKeys(this.scrollPane);
    }

    @Override
    public void programSettingsUpdated() {
        this.controller.programSettingsChanged(Program.getInstance().settings());
    }

    private void createUI() {
        this.pnlTaskProgress = new JPanel();
        this.pnlTaskProgress.setLayout(new GridBagLayout());
        this.lblTaskStatus = new JLabel("Task Status");
        this.lblTaskStatus.setFont(this.lblTaskStatus.getFont().deriveFont(14.0f));
        this.prgTaskProgress = new JProgressBar(0);
        this.lblTaskProgress = new JLabel("0%");
        this.lblTaskProgress.setFont(this.lblTaskStatus.getFont());
        this.lblTaskProgress.setHorizontalTextPosition(0);
        this.pnlTaskProgress.setVisible(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.pnlTaskProgress.add((Component)this.lblTaskStatus, gridBagConstraints);
        gridBagConstraints.insets = new Insets(4, 3, 4, 3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        this.pnlTaskProgress.add((Component)this.prgTaskProgress, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.fill = 1;
        this.pnlTaskProgress.add((Component)this.lblTaskProgress, gridBagConstraints);
        this.pnlTaskProgress.setBorder(new BevelBorder(1));
        this.scrollPane = new JScrollPane(this.panel);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(16);
        this.add((Component)this.pnlTaskProgress, "North");
        this.add((Component)this.scrollPane, "Center");
    }

    private void loadSettings() {
    }

    private void onHistoryUpdate(HistoryUpdateEvent historyUpdateEvent) {
        this.updateFileUI();
    }

    private void onSceneUpdate(SceneUpdateEvent sceneUpdateEvent) {
        if (sceneUpdateEvent.scene == this.currentScene) {
            switch (sceneUpdateEvent.type) {
                case Selection: {
                    this.updateSelectionUI();
                }
            }
        }
    }

    private void updateSelectionUI() {
        Nuc[] nucArray = this.controller.getSelected();
        boolean bl = nucArray.length != 0;
        boolean bl2 = false;
        if (bl) {
            for (Nuc nuc : nucArray) {
                if (!nuc.isPaired()) continue;
                bl2 = true;
                break;
            }
        }
        this.actionBreakBonds.setEnabled(bl2);
        this.formatBondType.setEnabled(bl2);
        this.actionJoinStrands.setEnabled(nucArray.length > 1);
        this.actionSplitStrand.setEnabled(bl);
        this.actionRemoveNucs.setEnabled(bl);
        this.actionInsertNucs.setEnabled(bl);
        this.actionFormatRotateNumber.setEnabled(bl);
    }

    private void createToolButtons() {
        this.toolButtons.setMergePos(-100);
        this.toolButtons.addSeparator();
        this.toolButtons.add(this.actionSave);
        this.toolButtons.setMergePos(-80);
        this.toolButtons.addSeparator();
        this.toolButtons.add(this.actionEditUndo);
        this.toolButtons.add(this.actionEditRedo);
        this.toolButtons.addSeparator();
        this.toolButtons.add(this.actionRedraw);
        this.toolButtons.add(this.actionRedrawCirc);
        this.toolButtons.add(this.actionRedrawLinear);
        this.toolButtons.addSeparator();
        this.toolButtons.add(this.actionFold);
        this.toolButtons.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnSelModeNuc = this.toolButtons.addToggle(this.actionSelectNuc);
        buttonGroup.add(this.btnSelModeNuc);
        this.btnSelModeHelix = this.toolButtons.addToggle(this.actionSelectHelix);
        buttonGroup.add(this.btnSelModeHelix);
        this.btnSelModeBranch = this.toolButtons.addToggle(this.actionSelectBranch);
        buttonGroup.add(this.btnSelModeBranch);
        this.toolButtons.addSeparator();
        this.toolButtons.add(this.actionSelectExpand);
        this.toolButtons.setMergePos(-40);
        this.toolButtons.addSeparator();
        this.toolButtons.add(this.actionZoomAuto);
        this.toolButtons.add(this.actionZoomIn);
        this.toolButtons.add(this.actionZoomOut);
        this.toolButtons.add(this.actionZoomReset);
        this.toolButtons.addSeparator();
        this.toolButtons.add(this.actionPrevStructure);
        this.structureMenuToolbarButton = this.toolButtons.add(this.actionChooseStructure);
        this.toolButtons.add(this.actionNextStructure);
    }

    private void createMenus() {
        MergeMenu mergeMenu = new MergeMenu("File");
        mergeMenu.setSubItemMergePos(-80);
        mergeMenu.addSeparator();
        mergeMenu.add(this.actionSave);
        mergeMenu.add(this.actionSaveAs);
        mergeMenu.add(this.actionExport);
        mergeMenu.setSubItemMergePos(-70);
        mergeMenu.addSeparator();
        mergeMenu.add(this.actionClose);
        this.menus.add(mergeMenu);
        mergeMenu = new MergeMenu("Edit");
        mergeMenu.add(this.actionEditUndo);
        mergeMenu.add(this.actionEditRedo);
        mergeMenu.addSeparator();
        mergeMenu.addCheck(this.actionSelectNuc);
        mergeMenu.addCheck(this.actionSelectHelix);
        mergeMenu.addCheck(this.actionSelectBranch);
        mergeMenu.addSeparator();
        mergeMenu.add(this.actionSelectExpand);
        mergeMenu.add(this.actionSelectAll);
        this.menus.add(mergeMenu);
        mergeMenu = new MergeMenu("&View", -40);
        mergeMenu.add(this.actionZoomAuto);
        mergeMenu.add(this.actionZoomIn);
        mergeMenu.add(this.actionZoomOut);
        mergeMenu.add(this.actionZoomReset);
        mergeMenu.addSeparator();
        mergeMenu.add(this.structureMenu);
        mergeMenu.add(this.actionNextStructure);
        mergeMenu.add(this.actionPrevStructure);
        mergeMenu.addSeparator();
        mergeMenu.add(this.actionShowEnergy);
        this.menus.add(mergeMenu);
        mergeMenu = new MergeMenu("&Structure", -20);
        this.formatBondType = new MergeMenu("Set Basepair Type");
        this.formatBondType.add(this.actionSetBondTypeNormal);
        this.formatBondType.add(this.actionSetBondTypePseduo);
        this.formatBondType.add(this.actionSetBondTypeForced);
        this.formatBondType.add(this.actionSetBondTypeBanned);
        this.formatBondType.add(this.actionSetBondTypeSpecial);
        mergeMenu.add(this.formatBondType);
        mergeMenu.add(this.actionIdentifyPseudoKnots);
        mergeMenu.add(this.actionBreakBonds);
        mergeMenu.addSeparator();
        mergeMenu.add(this.actionSplitStrand);
        mergeMenu.add(this.actionJoinStrands);
        mergeMenu.addSeparator();
        mergeMenu.add(this.actionEditNucs);
        mergeMenu.add(this.actionInsertNucs);
        mergeMenu.add(this.actionRemoveNucs);
        mergeMenu.addSeparator();
        mergeMenu.add(this.actionFold);
        this.menus.add(mergeMenu);
        mergeMenu = new MergeMenu("&Format", -20);
        mergeMenu.add(this.actionFormatColor);
        mergeMenu.add(this.actionFormatRemoveColor);
        mergeMenu.add(this.actionFormatRemoveAllColor);
        mergeMenu.add(this.actionColorHelices);
        mergeMenu.addSeparator();
        mergeMenu.add(this.actionRedraw);
        mergeMenu.add(this.actionRedrawCirc);
        mergeMenu.add(this.actionRedrawLinear);
        mergeMenu.addSeparator();
        mergeMenu.add(this.actionFlipScene);
        mergeMenu.add(this.actionLocalRedraw);
        mergeMenu.addSeparator();
        mergeMenu.add(this.actionFormatRotateNumber);
        if (Strings.asBool(System.getProperty("debug"))) {
            mergeMenu.add(this.testAction);
        }
        this.menus.add(mergeMenu);
        this.structureMenu.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                ((JPopupMenu)popupMenuEvent.getSource()).setInvoker(DrawWindow.this.structureMenu);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    private void save(FileType fileType, boolean bl, boolean bl2) {
        Object object = this.scenes.getFilePath();
        FileType fileType2 = this.scenes.getFileType();
        boolean bl3 = bl || bl2 || Strings.isEmpty((String)object) || !fileType.includes(fileType2);
        FileType fileType3 = FileType.SVG;
        Preferences preferences = Program.getInstance().mruPaths();
        if (bl3) {
            Object object2;
            String string;
            if (Strings.isEmpty((String)object)) {
                object = this.scenes.getTitle() == null ? "" : this.scenes.getTitle().trim();
                if (((String)(object = ((String)object).replaceAll("[\\\\/?:\"']|\\.\\.", "_"))).isEmpty()) {
                    object = "untitled";
                }
                object = (String)object + "." + fileType.firstExtension();
            }
            if (!fileType.includes(fileType2) && !PathTools.getExt((String)object).isEmpty()) {
                object = PathTools.changeExtension((String)object, null);
            }
            if (bl2) {
                string = preferences.get("export-drawing", null);
                object2 = preferences.get("export-drawing-type", null);
                if (!Strings.isEmpty((String)object2) && FileType.fromName((String)object2) != null) {
                    fileType3 = FileType.fromName((String)object2);
                }
                String string2 = null;
                String string3 = fileType3.firstExtension();
                if (!Strings.isEmpty(string)) {
                    PathTools.FileName fileName = PathTools.parse(string);
                    string2 = fileName.dir();
                    string3 = fileName.ext(false);
                }
                if (!(string2 != null && PathTools.isDir(string2) || Strings.isEmpty(this.scenes.getFilePath()))) {
                    string2 = PathTools.getDir(this.scenes.getFilePath());
                }
                if (string2 == null || !PathTools.isDir(string2)) {
                    string2 = PathTools.getDocumentsDir().toString();
                }
                object = string2 + File.separatorChar + PathTools.getBaseName((String)object) + "." + string3;
            }
            string = bl2 ? "export" : "drawing";
            object2 = (bl2 ? "Export" : "Save") + " Drawing";
            object = FileDialog.getSaveName(fileType.getFilterString(true) + "|*", (String)object, (String)object2, string, this, fileType3.firstExtension());
            if (object == null) {
                return;
            }
            fileType = FileType.fromFilter(FileDialog.getLastChosenFilter());
            if (fileType == null) {
                fileType = FileType.NsdDrawing;
            }
        }
        try {
            if (FileType.VectorImage.includes(fileType)) {
                this.saveSceneAsVectorImage((String)object, fileType);
            } else if (FileType.Image.includes(fileType)) {
                this.saveSceneAsRastorImage((String)object, fileType);
            } else {
                AppActions.writeFile(this.scenes, (String)object, fileType, bl2, false);
            }
            if (bl2) {
                preferences.put("export-drawing", (String)object);
                preferences.put("export-drawing-type", fileType.name());
            }
            if (!bl2) {
                this.scenes.setSource((String)object, fileType);
            }
            if (FileType.AnyOpenable.includes(fileType)) {
                Program.getInstance().getMainFrame().addRecentFile((String)object, fileType);
            }
        }
        catch (Exception exception) {
            Dialogs.showWarning(AppActions.formatFileError("save", fileType, (String)object, exception));
        }
        this.updateFileUI();
    }

    private Rectangle renderFullSceneToImage(Graphics2D graphics2D, boolean bl) {
        Rectangle rectangle = this.getSceneBounds(false);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(-rectangle.x, -rectangle.y);
        rectangle.translate(-rectangle.x, -rectangle.y);
        View2D view2D = new View2D(affineTransform, rectangle);
        if (bl) {
            graphics2D.setColor(this.panel.getBackground());
            graphics2D.fill(rectangle);
        }
        this.controller.render(graphics2D, view2D, false);
        return rectangle;
    }

    private void saveSceneAsRastorImage(String string, FileType fileType) throws IOException {
        String string2;
        boolean bl = false;
        switch (fileType) {
            case PNG: {
                string2 = "PNG";
                break;
            }
            case JPEG: {
                string2 = "JPG";
                bl = true;
                break;
            }
            case GIF: {
                string2 = "GIF";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported export type: " + fileType);
            }
        }
        Rectangle rectangle = this.getSceneBounds(false);
        BufferedImage bufferedImage = ImageUtil.createCompatibleImage(rectangle.width, rectangle.height, !bl);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.renderFullSceneToImage(graphics2D, bl);
        ImageIO.write((RenderedImage)bufferedImage, string2, new File(string));
    }

    private void saveSceneAsVectorImage(String string, FileType fileType) throws IOException {
        Graphics2DRecorder graphics2DRecorder = new Graphics2DRecorder();
        Rectangle rectangle = this.renderFullSceneToImage(graphics2DRecorder, false);
        PageSize pageSize = new PageSize(rectangle.getWidth(), rectangle.getHeight());
        if (fileType != FileType.SVG) {
            throw new IllegalArgumentException("Unsupported export type: " + fileType);
        }
        new SvgGraphicsExporter(pageSize, SvgGraphicsExporter.TrueScreenDPI).write(graphics2DRecorder.getGraphicsOps(), string);
    }

    private Rectangle getSceneBounds(boolean bl) {
        Graphics2D graphics2D = (Graphics2D)this.panel.getGraphics();
        graphics2D.setClip(0, 0, 0, 0);
        Rectangle rectangle = this.controller.calcBounds(graphics2D, new View2D(), bl);
        graphics2D.dispose();
        return rectangle;
    }

    public void redrawScene() {
        try {
            this.layout.redrawRadial(this.currentScene);
            this.controller.layoutUpdated(SceneUpdateInfo.Layout.subType("Full Redraw"));
            this.autoScale();
        }
        catch (RnaBackendException rnaBackendException) {
            Dialogs.showWarning("Redraw operation failed: \n" + rnaBackendException.getMessage());
        }
    }

    private void redrawCircular() {
        this.layout.redrawCircular(this.currentScene);
        this.controller.layoutUpdated(SceneUpdateInfo.Layout.subType("Redraw Circular"));
        this.autoScale();
    }

    private void redrawLinear() {
        this.layout.redrawLinear(this.currentScene);
        this.controller.layoutUpdated(SceneUpdateInfo.Layout.subType("Redraw Linear"));
        this.autoScale();
    }

    private boolean isTaskRunning() {
        return this._asyncTask != null && !this._asyncTask.isDone();
    }

    private void monitorAsyncTask(RnaFileIO.AsyncTask asyncTask) {
        if (this.isTaskRunning()) {
            throw new UnsupportedOperationException("Another task is already running.");
        }
        this._asyncTask = asyncTask;
        if (this.asyncUpdateTimer == null) {
            this.asyncUpdateTimer = new Timer(100, actionEvent -> this.asyncTimer_elapsed());
        }
        this.asyncUpdateTimer.start();
    }

    private void asyncTimer_elapsed() {
        if (this._asyncTask.isDone()) {
            this.asyncUpdateTimer.stop();
            this.pnlTaskProgress.setVisible(false);
        } else {
            this.pnlTaskProgress.setVisible(true);
            this.lblTaskStatus.setText(this._asyncTask.getStatus());
            int n = this._asyncTask.getProgress();
            if (n < 0) {
                this.prgTaskProgress.setIndeterminate(true);
                this.lblTaskProgress.setText("...");
            } else {
                if (n > 100) {
                    n = 100;
                }
                this.prgTaskProgress.setIndeterminate(false);
                this.prgTaskProgress.setValue(n);
                this.lblTaskProgress.setText(n + "%");
            }
        }
    }

    private void insertBases() {
        if (this.controller.getFocused() == null) {
            Dialogs.showInfo("Please select the base at the position where the new bases should be inserted.");
            return;
        }
        InsertBasesDialog insertBasesDialog = new InsertBasesDialog();
        int n = insertBasesDialog.showDialog(this, "Insert Bases");
        if (0 == n) {
            this.controller.insertBases(insertBasesDialog.getSequence(), null, insertBasesDialog.isInsertAfter());
        }
    }

    private void foldSequence() {
        if (this.isTaskRunning()) {
            Dialogs.showInfo("Another task is already running. Please wait for it to complete.");
            return;
        }
        RnaFileIO.BackendCalc<RnaSceneGroup> backendCalc = RnaFileIO.foldSeq(RnaFileIO.getRNASequence(this.currentScene), 1);
        backendCalc.whenDone(backgroundWork -> {
            if (backgroundWork.hadError()) {
                Dialogs.showWarning(backgroundWork.getError().getMessage());
            } else {
                RnaSceneGroup rnaSceneGroup = (RnaSceneGroup)backgroundWork.getResult();
                this.currentScene.clearBonds();
                this.currentScene.copyBonds((RnaScene)rnaSceneGroup.get(0));
                try {
                    this.layout.redrawRadial(this.currentScene);
                }
                catch (RnaBackendException rnaBackendException) {
                    rnaBackendException.printStackTrace();
                    this.layout.redrawCircular(this.currentScene);
                }
                this.buildStructureMenu();
                this.controller.structureUpdated(SceneUpdateInfo.Bonds.subType("Re-Fold Sequence"));
                this.updateFileUI();
                this.autoScale();
            }
        });
        backendCalc.start();
        this.monitorAsyncTask(backendCalc);
    }

    private void setSelType(RnaDrawController.SelectionType selectionType) {
        this.selType = selectionType;
        this.controller.setSelType(selectionType);
        this.updateFileUI();
    }

    private int getCurrentSceneIndex() {
        return this.scenes == null || this.currentScene == null ? -1 : this.scenes.indexOf(this.currentScene);
    }

    private void updateFileUI() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.getCurrentSceneIndex();
        if (this.scenes == null) {
            stringBuilder.append("Untitled Drawing");
        } else {
            stringBuilder.append("Drawing - ").append(this.strOrDefault(RnaFileIO.stripEnergyTitle(this.scenes.getTitle()), "Untitled"));
            if (n != -1 && n < this.scenes.structureCount()) {
                stringBuilder.append(" [").append(this.strOrDefault(this.currentScene.title, "Structure " + (n + 1) + " of " + this.scenes.structureCount())).append("] ");
            }
        }
        this.setTitle(stringBuilder.toString());
        if (n == -1 || n >= this.structureList.getButtonCount()) {
            this.structureList.clearSelection();
        } else {
            this.structureList.select(n);
        }
        this.actionChooseStructure.setEnabled(this.scenes != null && this.scenes.structureCount() > 1);
        this.actionNextStructure.setEnabled(this.scenes != null && n < this.scenes.structureCount() - 1);
        this.actionPrevStructure.setEnabled(this.scenes != null && n > 0);
        this.actionEditUndo.setEnabled(this.currentScene != null && this.controller.canUndo());
        this.actionEditRedo.setEnabled(this.currentScene != null && this.controller.canRedo());
    }

    private String strOrDefault(String string, String string2) {
        if (Strings.isWhiteSpace(string)) {
            return string2;
        }
        return string;
    }

    public void loadScene(RnaScene rnaScene) {
        this.handleView(this.currentScene, true);
        this.currentScene = rnaScene;
        this.controller.setScene(rnaScene);
        this.handleView(this.currentScene, false);
        this.updateFileUI();
        this.updateSelectionUI();
    }

    private void handleView(RnaScene rnaScene, boolean bl) {
        if (rnaScene == null) {
            return;
        }
        int n = this.scenes.indexOf(rnaScene);
        if (n == -1) {
            return;
        }
        SceneInfo sceneInfo = this.sceneInfo[n];
        if (bl) {
            if (sceneInfo == null) {
                this.sceneInfo[n] = sceneInfo = new SceneInfo();
            }
            sceneInfo.scale = this.panel.getScale();
            sceneInfo.offset = this.panel.getOffset();
            sceneInfo.scrollPos = this.scrollPane.getViewport().getViewPosition();
        } else if (sceneInfo == null) {
            this.panel.setView(1.0f, new Point2D.Float());
            this.scrollPane.getViewport().setViewPosition(new Point());
            SwingUtilities.invokeLater(() -> {
                if (this.currentScene == rnaScene) {
                    this.autoScale();
                }
            });
        } else {
            this.panel.setView(sceneInfo.scale, sceneInfo.offset);
            Point point = sceneInfo.scrollPos;
            SwingUtilities.invokeLater(() -> {
                if (this.currentScene == rnaScene) {
                    this.scrollPane.getViewport().setViewPosition(point);
                }
            });
        }
    }

    public void autoScale() {
        this.panel.autoScale(this.scrollPane.getViewport().getSize());
        this.updateFileUI();
    }

    @Override
    public Collection<? extends JMenu> getMenus() {
        return this.menus;
    }

    @Override
    public Collection<? extends Component> getToolbarButtons() {
        return this.toolButtons;
    }

    private void showStructureMenu() {
        JPopupMenu jPopupMenu = this.structureMenu.getPopupMenu();
        System.out.println("before popup: " + this.structureMenu.getPopupMenu());
        this.structureMenu.getPopupMenu().show(this.structureMenuToolbarButton, 0, this.structureMenuToolbarButton.getHeight());
        System.out.println("after popup same: " + (this.structureMenu.getPopupMenu() == jPopupMenu));
        System.out.println("after popup items: " + this.structureMenu.getPopupMenu().getComponentCount());
    }

    private void showNextStructure() {
        this.loadStructure(this.getCurrentSceneIndex() + 1);
    }

    private void showPrevStructure() {
        this.loadStructure(this.getCurrentSceneIndex() - 1);
    }

    private void loadStructure(int n) {
        if (n == this.getCurrentSceneIndex()) {
            return;
        }
        if (n > -1 && n < this.scenes.structureCount()) {
            this.loadScene((RnaScene)this.scenes.get(n));
        } else {
            this.updateFileUI();
        }
    }

    private void buildStructureMenu() {
        this.structureMenu.removeAll();
        this.structureList.removeAll();
        for (int i = 0; i < this.scenes.structureCount(); ++i) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(i + 1 + ". " + this.strOrDefault(((RnaScene)this.scenes.get((int)i)).title, "Structure " + i));
            jRadioButtonMenuItem.setActionCommand(Integer.toString(i + 1));
            jRadioButtonMenuItem.addActionListener(actionEvent -> this.loadStructure(Integer.parseInt(actionEvent.getActionCommand()) - 1));
            this.structureMenu.add(jRadioButtonMenuItem);
            this.structureList.add(jRadioButtonMenuItem);
        }
    }

    private void findPseudoKnotsBackend() {
        StopWatch stopWatch = new StopWatch(true);
        try {
            RnaFileIO.identifyPseudoKnotsBackend(this.currentScene);
            this.controller.structureUpdated(SceneUpdateInfo.BondType.subType("Identified PseudoKnots"));
        }
        catch (Exception exception) {
            Dialogs.showWarning("Identifying PseudoKnot Bonds failed: \n" + exception.getMessage());
        }
        stopWatch.println("findPseudoKnots");
    }

    private void findHelices() {
        Color[] colorArray = new Color[]{Colors.Red, Colors.Orange, Colors.Yellow, Colors.DarkGreen, Colors.LimeGreen, Colors.DodgerBlue, Colors.DarkBlue, Colors.Purple, Colors.Indigo, Colors.SaddleBrown, Colors.Gray};
        int n = 0;
        for (Motif.Helix helix : this.currentScene.getHelices()) {
            for (Nuc nuc : helix.getBases()) {
                nuc.style().fillColor = colorArray[n % colorArray.length];
            }
            ++n;
        }
        this.controller.styleUpdated(SceneUpdateInfo.FormatBases);
    }

    private void findPseudoKnots() {
        StopWatch stopWatch = new StopWatch(true);
        try {
            Set<Bond> set = Motif.findNonCrossingBonds(this.currentScene);
            for (Bond bond : this.currentScene.getBonds()) {
                bond.type = set.contains(bond) ? BondType.Default : BondType.Pseudo;
            }
            this.controller.structureUpdated(SceneUpdateInfo.BondType.subType("Identified PseudoKnots"));
        }
        catch (Exception exception) {
            Dialogs.showWarning("Identifying PseudoKnot Bonds failed: \n" + exception.getMessage());
        }
        stopWatch.println("findPseudoKnots2");
    }

    public void setSelectedBondType(BondType bondType) {
        this.controller.setSelectedBondType(bondType);
    }

    private void showColorizeDialog() {
        Preferences preferences = Program.getInstance().prefs().user().node("ColorizeDialog");
        new ColorizeDialog(this, preferences, false).showDialog();
    }

    public void colorizeScenes(SceneColorizer sceneColorizer, boolean bl, boolean bl2) {
        if (bl) {
            RnaScene rnaScene = this.currentScene;
            for (RnaScene rnaScene2 : this.scenes) {
                if (rnaScene2 == rnaScene) continue;
                this.loadScene(rnaScene2);
                this.controller.colorize(sceneColorizer, !bl2);
            }
            this.loadScene(rnaScene);
        }
        this.controller.colorize(sceneColorizer, !bl2);
    }

    public void showCalcEnergy() {
        try {
            double d = RnaFileIO.calculateEnergy(this.currentScene);
            HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
            int n = 0;
            for (Nuc object : this.currentScene.allNucs()) {
                Integer n2;
                if (!object.isPaired() || object.indexInScene() >= object.getPaired().indexInScene()) continue;
                ++n;
                Object object2 = object.symbol + "-" + object.getPaired().symbol;
                if (object.symbol.compareTo(object.getPaired().symbol) > 0) {
                    object2 = object.getPaired().symbol + "-" + object.symbol;
                }
                if ((n2 = (Integer)hashMap.get(object2)) == null) {
                    n2 = 0;
                }
                hashMap.put(object2, n2 + 1);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Sequence Length: ").append(this.currentScene.getNucCount()).append('\n').append("Basepairs: ").append("\n");
            for (Object object2 : hashMap.keySet()) {
                stringBuilder.append("\t").append((String)object2).append(":\t").append(hashMap.get(object2)).append("\n");
            }
            stringBuilder.append("\t").append("Total:\t").append(n).append("\n");
            stringBuilder.append("\nGibbs Free Energy: ").append(String.format("%01.2f", d)).append(" kcal/mol\n");
            Dialogs.showInfo(stringBuilder.toString(), "Structure Energy");
        }
        catch (Exception exception) {
            Dialogs.showWarning("Unable to calculate energy due to an error: " + exception.toString(), "Energy Calculation Failed");
        }
    }

    public void editSelectedBases() {
        Object[] objectArray = this.controller.getSelected();
        Arrays.sort(objectArray);
        if (objectArray.length == 0) {
            Dialogs.showInfo("No bases were selected.");
        }
        if (objectArray.length < 4) {
            for (int i = 0; i < objectArray.length; ++i) {
                String string = Dialogs.input("Enter the replacement for " + ((Nuc)objectArray[i]).toString("$s$N"), "Edit Base", ((Nuc)objectArray[i]).symbol);
                if (string == null) {
                    return;
                }
                if ((string = string.trim()).isEmpty()) {
                    Dialogs.showWarning("You cannot enter an empty symbol. Use the \"Delete Selected Bases\" tool to remove bases.");
                    --i;
                    continue;
                }
                if (string.length() != 1) {
                    Dialogs.showWarning("The base symbol can only be a single character.");
                    --i;
                    continue;
                }
                String string2 = ((Nuc)objectArray[i]).toString("$s$N");
                ((Nuc)objectArray[i]).symbol = string;
                this.controller.structureUpdated(SceneUpdateInfo.SequenceText.subType("Changed Base " + string2 + " to " + string));
            }
        } else if (objectArray.length <= 20) {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuilder.append(((Nuc)objectArray[i]).toString("$s$N  "));
                stringBuilder2.append(((Nuc)objectArray[i]).symbol).append(' ');
            }
            String string = stringBuilder2.toString();
            char[] cArray = new char[objectArray.length + 1];
            while (true) {
                if ((string = Dialogs.input("Enter the replacements, in order, for the following bases. You must enter exactly " + objectArray.length + " bases.\n(Spaces are allowed and will be ignored.)\n\n" + stringBuilder.toString(), "Edit Base", string)) == null) {
                    return;
                }
                n = 0;
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (!Character.isWhitespace(c)) {
                        cArray[n++] = c;
                    }
                    if (n > objectArray.length) break;
                }
                if (n == objectArray.length) break;
                Dialogs.showWarning("You have entered too " + (n < objectArray.length ? "few" : "many") + " base characters.", "Edit Bases");
            }
            for (n = 0; n < objectArray.length; ++n) {
                ((Nuc)objectArray[n]).symbol = Character.toString(cArray[n]);
            }
            this.controller.structureUpdated(SceneUpdateInfo.SequenceText);
        } else {
            int n;
            objectArray = this.currentScene.allNucs().toArray(new Nuc[this.currentScene.getNucCount()]);
            StringBuilder stringBuilder = new StringBuilder(objectArray.length + objectArray.length / 10 + 1);
            char[] cArray = new char[objectArray.length + 1];
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuilder.append(((Nuc)objectArray[i]).symbol);
                if (i == 0 || i % 10 != 0) continue;
                stringBuilder.append(' ');
            }
            String string = stringBuilder.toString();
            while (true) {
                if ((string = Dialogs.input("You have selected too many bases to easily edit individually.\nPlease edit the entire sequence below, making sure to preserve the total number of bases.\nA space has been inserted every 10 bases for convenience.", "Edit Base", string)) == null) {
                    return;
                }
                n = 0;
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (!Character.isWhitespace(c)) {
                        cArray[n++] = c;
                    }
                    if (n > objectArray.length) break;
                }
                if (n == objectArray.length) break;
                Dialogs.showWarning("You have entered too " + (n < objectArray.length ? "few" : "many") + " base characters. Required: " + objectArray.length, "Edit Bases");
            }
            for (n = 0; n < objectArray.length; ++n) {
                ((Nuc)objectArray[n]).symbol = Character.toString(cArray[n]);
            }
            this.controller.structureUpdated(SceneUpdateInfo.SequenceText);
        }
    }

    private void test() {
        for (Bond bond : this.currentScene.getBonds()) {
            if (bond.isFirst()) {
                bond.n5.style().fillColor = Color.BLUE;
            }
            if (bond.isLast()) {
                bond.n3.style().fillColor = Color.ORANGE;
            }
            if (!bond.isFirst() && !bond.isLast()) continue;
            bond.right(null).style().textColor = Color.RED;
            bond.left(null).style().textColor = Color.GREEN;
        }
        this.controller.controlsUpdated();
    }

    public static class ToolButtonList
    extends ArrayList<Component> {
        private int mergePos = 0;

        public void setMergePos(int n) {
            this.mergePos = n;
        }

        public <T extends JComponent> T add(T t) {
            super.add(t);
            return t;
        }

        public MergeButton add(Action action) {
            return this.add((JComponent)new MergeButton(action, this.mergePos));
        }

        public MergeToggleButton addToggle(Action action) {
            return this.add((JComponent)new MergeToggleButton(action, this.mergePos));
        }

        public JSeparator addSeparator() {
            return this.add((JComponent)new MergeButton.Separator(this.mergePos));
        }
    }

    private static class SceneInfo {
        Point2D offset;
        float scale;
        public Point scrollPos;

        private SceneInfo() {
        }
    }
}

