/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import ur_rna.RNAstructure.backend.RNA;
import ur_rna.RNAstructure.backend.RNABackend;
import ur_rna.StructureEditor.FileType;
import ur_rna.StructureEditor.Program;
import ur_rna.StructureEditor.models.RnaScene;
import ur_rna.StructureEditor.models.RnaSceneGroup;
import ur_rna.StructureEditor.services.SceneColorizer;
import ur_rna.StructureEditor.windows.DrawWindow;
import ur_rna.Utilities.Colors;
import ur_rna.Utilities.ObjTools;
import ur_rna.Utilities.PathTools;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.annotation.Nullable;
import ur_rna.Utilities.swing.Dialogs;
import ur_rna.Utilities.swing.FileDialog;
import ur_rna.Utilities.swing.TextDocListener;

public class ColorizeDialog
extends JDialog
implements ActionListener {
    private JPanel pnlMain;
    private JButton btnClose;
    private JButton btnApplyText;
    private JRadioButton optStructuresAll;
    private JTabbedPane tabs;
    private JTextArea txtBase;
    private JCheckBox chkUse;
    private JRadioButton optBasesSelected;
    private JButton btnChooseColor;
    private JTextArea txtColor;
    private JButton btnAddSymbolRule;
    private JPanel pnlSymbolColors;
    private JLabel lblColor;
    private JRadioButton optStructuresCurrent;
    private JRadioButton optBasesAll;
    private JButton btnResetSymbolRules;
    private JTextField txtSingleColor;
    private JLabel lblSingleColor;
    private JButton btnSingleColor;
    private JCheckBox chkIgnoreCase;
    private JTextArea txtModData;
    private JButton btnLoadModFile;
    private JButton btnHelpMod;
    private JTextField txtValueLimit;
    private JTextField txtValueColor;
    private JLabel lblValueColor;
    private JButton btnResetValueRules;
    private JButton btnValueChooseColor;
    private JPanel pnlValueColors;
    private JButton btnAddValueRule;
    private JButton btnRemValueRule;
    private JButton btnClearValueText;
    private JComboBox cmbValueComparison;
    private JLabel lblValueColorHeader;
    private JTextArea txtProbData;
    private JLabel lblProbColorHeader;
    private JPanel pnlProbColors;
    private JButton btnAddProbRule;
    private JButton btnRemProbRule;
    private JButton btnResetProbRules;
    private JButton btnLoadProbFile;
    private JButton btnClearProbText;
    private JButton btnHelpProb;
    private JButton btnRemSymbolRule;
    private JComboBox cmbProbComparison;
    private JButton btnApplyFill;
    private JButton btnApplyOutline;
    private JButton btnApplyBond;
    private JButton btnResetText;
    private JButton btnResetFill;
    private JButton btnResetOutline;
    private JButton btnResetBond;
    private JButton btnResetAll;
    private Timer updateTimer = new Timer(100, this::updateTimerElapsed);
    private TextDocListener docListener = new TextDocListener();
    private Preferences prefs;
    private SimpleColorControl singleColor;
    private String lastValueDataPath;
    private String lastProbDataPath;
    private Font buttonFont;
    private Font buttonFontBold;
    private static String[] valueComparisonSymbols = "< <= > >=".split(" ");
    private ArrayList<SymbolColorRule> symbolColorRules;
    private ArrayList<ValueColorRule> valueColorRules;
    private ArrayList<ValueColorRule> probColorRules;
    private String _lastColorEffect;

    public ColorizeDialog(DrawWindow drawWindow, @Nullable Preferences preferences, boolean bl) {
        super(SwingUtilities.getWindowAncestor(drawWindow), "Color Annotations", bl ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        this.$$$setupUI$$$();
        this.symbolColorRules = new ArrayList();
        this.valueColorRules = new ArrayList();
        this.probColorRules = new ArrayList();
        this._lastColorEffect = "apply-text";
        this.setDefaultCloseOperation(2);
        this.prefs = preferences;
        this.addActionListeners(this.btnApplyText, this.btnApplyFill, this.btnApplyOutline, this.btnApplyBond, this.btnResetText, this.btnResetFill, this.btnResetOutline, this.btnResetBond, this.btnResetAll, this.btnClose, this.btnAddSymbolRule, this.btnAddValueRule, this.btnAddProbRule);
        this.cmbValueComparison.addItemListener(this::valueComparisonChanged);
        this.cmbProbComparison.addItemListener(this::probComparisonChanged);
        this.btnClearValueText.addActionListener(actionEvent -> this.txtModData.setText(""));
        this.btnClearProbText.addActionListener(actionEvent -> this.txtProbData.setText(""));
        this.btnResetSymbolRules.addActionListener(actionEvent -> this.resetSymbolColorRules());
        this.btnResetProbRules.addActionListener(actionEvent -> this.resetProbColorRules());
        this.btnResetValueRules.addActionListener(actionEvent -> this.resetValueColorRules());
        this.btnRemSymbolRule.addActionListener(actionEvent -> this.removeLastRule(this.symbolColorRules));
        this.btnRemValueRule.addActionListener(actionEvent -> this.removeLastRule(this.valueColorRules));
        this.btnRemProbRule.addActionListener(actionEvent -> this.removeLastRule(this.probColorRules));
        this.btnSingleColor.addActionListener(actionEvent -> this.showColorChooser(this.singleColor));
        this.btnLoadModFile.addActionListener(actionEvent -> this.browseLoadValueData());
        this.btnLoadProbFile.addActionListener(actionEvent -> this.browseLoadProbData());
        this.btnHelpMod.addActionListener(actionEvent -> this.showHelp("mod"));
        this.singleColor = new SimpleColorControl(this.txtSingleColor, this.lblSingleColor);
        this.docListener.listen(this.txtSingleColor);
        this.singleColor.addBoxClickHandler(this);
        this.resetProbColorRules();
        this.resetValueColorRules();
        this.resetSymbolColorRules();
        this.optStructuresAll.setSelected(true);
        this.optBasesAll.setSelected(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlMain, gridBagConstraints);
        this.pack();
        this.setSize(new Dimension(700, this.getHeight()));
        this.buttonFont = this.btnApplyText.getFont();
        this.buttonFontBold = this.buttonFont.deriveFont(1);
        this.loadSettings();
        this.updateUI();
        this.updateTimer.start();
        SwingUtilities.invokeLater(() -> {
            this.txtProbData.select(0, 0);
            this.txtModData.select(0, 0);
        });
    }

    private void addActionListeners(AbstractButton ... abstractButtonArray) {
        for (AbstractButton abstractButton : abstractButtonArray) {
            abstractButton.addActionListener(this);
        }
    }

    private void showHelp(String string) {
        Dialogs.showMessage(Program.getResourceText("colorize-help", string), "Colorize Drawing Help", Dialogs.INFO);
    }

    private void removeNonHeaders(JComponent jComponent) {
        for (int i = jComponent.getComponentCount() - 1; i > -1; --i) {
            String string = jComponent.getComponent(i).getName();
            if (string != null && string.startsWith("header")) continue;
            jComponent.remove(i);
        }
    }

    private void resetSymbolColorRules() {
        this.removeNonHeaders(this.pnlSymbolColors);
        this.symbolColorRules.clear();
        this.addSymbolColorRule("A a", Colors.Red);
        this.addSymbolColorRule("U u T t", Colors.Orange);
        this.addSymbolColorRule("G g", Colors.Blue);
        this.addSymbolColorRule("C c", Colors.Green);
        this.addSymbolColorRule("X x N n", Colors.Gray);
        this.addSymbolColorRule("PpRrZz", Colors.Purple);
        this.addSymbolColorRule("XxYy", Colors.Teal);
        this.pnlSymbolColors.revalidate();
    }

    private void resetValueColorRules() {
        this.correctPreferredHeight(this.txtValueColor, this.txtValueLimit);
        this.lblValueColor.setPreferredSize(new Dimension(this.lblValueColor.getPreferredSize().width, this.txtValueColor.getPreferredSize().height));
        this.removeNonHeaders(this.pnlValueColors);
        this.valueColorRules.clear();
        this.addValueColorRule("0.85", Colors.Red);
        this.addValueColorRule("0.40", Colors.Orange);
        this.addValueColorRule("-INF", Colors.Black);
        this.setValueComparison(">=");
        this.pnlValueColors.revalidate();
    }

    private void resetProbColorRules() {
        this.correctPreferredHeight(this.txtValueColor, this.txtValueLimit);
        this.lblValueColor.setPreferredSize(new Dimension(this.lblValueColor.getPreferredSize().width, this.txtValueColor.getPreferredSize().height));
        this.removeNonHeaders(this.pnlProbColors);
        this.probColorRules.clear();
        this.addProbColorRule(".99", Colors.Red);
        this.addProbColorRule(".95", Colors.Orange);
        this.addProbColorRule(".90", Colors.Yellow);
        this.addProbColorRule(".80", Colors.DarkGreen);
        this.addProbColorRule(".70", Colors.LimeGreen);
        this.addProbColorRule(".60", Colors.DodgerBlue);
        this.addProbColorRule(".50", Colors.DarkBlue);
        this.addProbColorRule("0", Colors.HotPink);
        this.setProbComparison(">=");
        this.pnlValueColors.revalidate();
    }

    private void updateUI() {
        if (this._lastColorEffect == null) {
            this._lastColorEffect = "<none>";
        }
        JRootPane jRootPane = SwingUtilities.getRootPane(this);
        for (JButton jButton : new JButton[]{this.btnApplyText, this.btnApplyFill, this.btnApplyOutline, this.btnApplyBond}) {
            if (this._lastColorEffect.equals(jButton.getActionCommand())) {
                jButton.setFont(this.buttonFontBold);
                if (jRootPane == null) continue;
                jRootPane.setDefaultButton(jButton);
                continue;
            }
            jButton.setFont(this.buttonFont);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTimerElapsed(ActionEvent actionEvent) {
        if (!this.docListener.resetIfChanged()) {
            return;
        }
        this.docListener.suspendUpdates();
        try {
            for (ColorEditControl colorEditControl : this.probColorRules) {
                colorEditControl.setColorFromText();
            }
            for (ColorEditControl colorEditControl : this.valueColorRules) {
                colorEditControl.setColorFromText();
            }
            for (ColorEditControl colorEditControl : this.symbolColorRules) {
                colorEditControl.setColorFromText();
            }
            this.singleColor.setColorFromText();
        }
        finally {
            this.docListener.resumeUpdates();
        }
    }

    private void setValueComparison(String string) {
        this.cmbValueComparison.setSelectedIndex(ObjTools.indexOf(valueComparisonSymbols, string));
    }

    private String getValueComparisonSymbol() {
        int n = this.cmbValueComparison.getSelectedIndex();
        return valueComparisonSymbols[n == -1 ? 0 : n];
    }

    private void valueComparisonChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.lblValueColorHeader.setText(String.format("Color (if value %s Limit)", this.getValueComparisonSymbol()));
        }
    }

    private void setProbComparison(String string) {
        this.cmbProbComparison.setSelectedIndex(ObjTools.indexOf(valueComparisonSymbols, string));
    }

    private String getProbComparisonSymbol() {
        int n = this.cmbProbComparison.getSelectedIndex();
        return valueComparisonSymbols[n == -1 ? 0 : n];
    }

    private void probComparisonChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.lblProbColorHeader.setText(String.format("Color (if prob. %s Limit)", this.getProbComparisonSymbol()));
        }
    }

    private void browseLoadValueData() {
        String string = FileDialog.getOpenName(FileType.SHAPE.getFilterString() + ";txt;chem;mod|*", this.lastValueDataPath, "Open Data File", "chem-data", this);
        if (string != null) {
            this.lastValueDataPath = string;
            try {
                this.txtModData.setText(Strings.readAll(new FileInputStream(string)));
                SwingUtilities.invokeLater(() -> this.txtModData.select(0, 0));
            }
            catch (IOException iOException) {
                Dialogs.showWarning("The data file could not be read: " + iOException.getMessage(), "Error Reading File");
            }
        }
    }

    private void browseLoadProbData() {
        String string = FileDialog.getOpenName(FileType.PartitionSav.getFilterString() + "|Probability Text File|txt;prob;part|*", this.lastProbDataPath, "Open Probability Data File", "prob-data", this);
        if (string != null) {
            this.lastProbDataPath = string;
            if (PathTools.getExt(string, false, false).toUpperCase().equals("PFS")) {
                RNA rNA = new RNA(string, RNABackend.FILE_PFS, "rna", true, true);
                if (rNA.GetErrorCode() == 0) {
                    int n = rNA.GetSequenceLength();
                    double[] dArray = new double[(n - 1) * n / 2];
                    int n2 = rNA.GetPairProbabilities(dArray, dArray.length);
                    if (n2 < 0) {
                        Dialogs.showWarning("Error reading probabilities: " + RNA.GetErrorMessage(-n2) + "\nFile: " + string, "Data File Error");
                        return;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    File file = new File(string);
                    stringBuilder.append("# PFS File: ").append(file.getName()).append('\n').append("# Modified: ").append(new Date(file.lastModified()).toString()).append('\n').append("# Sequence-Length: ").append(n).append('\n');
                    int n3 = 0;
                    String string2 = "%" + (Integer.toString(n).length() + 1) + "d";
                    for (int i = 0; i < n; ++i) {
                        for (int j = i + 1; j < n; ++j) {
                            stringBuilder.append(String.format(string2, i + 1)).append(String.format(string2, j + 1)).append(' ').append(dArray[n3++]).append('\n');
                        }
                    }
                    this.txtProbData.setText(stringBuilder.toString());
                    SwingUtilities.invokeLater(() -> this.txtProbData.select(0, 0));
                } else {
                    Dialogs.showWarning("The PFS file could not be read: " + rNA.GetFullErrorMessage(), "Error Reading PFS File");
                }
            } else {
                try {
                    this.txtProbData.setText(Strings.readAll(new FileInputStream(string)));
                    SwingUtilities.invokeLater(() -> this.txtProbData.select(0, 0));
                }
                catch (IOException iOException) {
                    Dialogs.showWarning("The data file could not be read: " + iOException.getMessage(), "Error Reading File");
                }
            }
        }
    }

    public void showDialog() {
        this.setVisible(true);
    }

    private void $$$setupUI$$$() {
        this.pnlMain = new JPanel();
        this.pnlMain.setLayout(new GridBagLayout());
        this.tabs = new JTabbedPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.pnlMain.add((Component)this.tabs, gridBagConstraints);
        this.tabs.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), null));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setName("prob");
        this.tabs.addTab("Basepair Probability", jPanel);
        JLabel jLabel = new JLabel();
        jLabel.setAutoscrolls(false);
        jLabel.setText("<html>This tool sets the color of each base according the probability of it being correctly basepaired (or correctly single-stranded).  \nData can be loaded from a <b>Partition Save File (<i>pfs</i>)</b> obtained from running <b><tt>partition</tt></b> or from a text file that lists pairwise basepairing probabilities in three columns: <tt>BASE1  BASE2  PROB(BASE1:BASE2) </tt><br>\nClick the <b>Help</b> button for more information.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 8, 3);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerLocation(230);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setResizeWeight(0.5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jSplitPane, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jSplitPane.setLeftComponent(jPanel2);
        JLabel jLabel2 = new JLabel();
        jLabel2.setFont(new Font(jLabel2.getFont().getName(), 1, jLabel2.getFont().getSize()));
        jLabel2.setName("headerData");
        jLabel2.setText("Probability Data");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)jScrollPane, gridBagConstraints);
        this.txtProbData = new JTextArea();
        this.txtProbData.setText("1  1\t0.949369084\n1  2\t0.008434194\n1  3\t0.115617068\n1  4\t0.182823643\n2  2\t0.656706731\n2  3\t0.761605327\n2  4\t0.115617068\n...");
        jScrollPane.setViewportView(this.txtProbData);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        this.btnLoadProbFile = new JButton();
        this.btnLoadProbFile.setText("Load File...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        jPanel3.add((Component)this.btnLoadProbFile, gridBagConstraints);
        this.btnHelpProb = new JButton();
        this.btnHelpProb.setText("Help");
        this.btnHelpProb.setMnemonic('H');
        this.btnHelpProb.setDisplayedMnemonicIndex(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        jPanel3.add((Component)this.btnHelpProb, gridBagConstraints);
        this.btnClearProbText = new JButton();
        this.btnClearProbText.setActionCommand("clearModText");
        this.btnClearProbText.setText("Clear");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        jPanel3.add((Component)this.btnClearProbText, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        jSplitPane.setRightComponent(jPanel4);
        JScrollPane jScrollPane2 = new JScrollPane();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel4.add((Component)jScrollPane2, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        jScrollPane2.setViewportView(jPanel5);
        this.pnlProbColors = new JPanel();
        this.pnlProbColors.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        jPanel5.add((Component)this.pnlProbColors, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        jLabel3.setFont(new Font(jLabel3.getFont().getName(), 1, jLabel3.getFont().getSize()));
        jLabel3.setName("headerLimit");
        jLabel3.setText("Probability Limit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlProbColors.add((Component)jLabel3, gridBagConstraints);
        this.lblProbColorHeader = new JLabel();
        this.lblProbColorHeader.setFont(new Font(this.lblProbColorHeader.getFont().getName(), 1, this.lblProbColorHeader.getFont().getSize()));
        this.lblProbColorHeader.setName("headerColor");
        this.lblProbColorHeader.setRequestFocusEnabled(true);
        this.lblProbColorHeader.setText("Color (if prob. < Limit)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlProbColors.add((Component)this.lblProbColorHeader, gridBagConstraints);
        JButton jButton = new JButton();
        jButton.setActionCommand("color");
        jButton.setText("...");
        jButton.setToolTipText("Choose Color...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlProbColors.add((Component)jButton, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        jLabel4.setAutoscrolls(false);
        jLabel4.setBackground(new Color(-16711936));
        jLabel4.setOpaque(true);
        jLabel4.setPreferredSize(new Dimension(40, 24));
        jLabel4.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlProbColors.add((Component)jLabel4, gridBagConstraints);
        JTextField jTextField = new JTextField();
        jTextField.setPreferredSize(new Dimension(100, 24));
        jTextField.setText("INF");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pnlProbColors.add((Component)jTextField, gridBagConstraints);
        JTextField jTextField2 = new JTextField();
        jTextField2.setPreferredSize(new Dimension(100, 24));
        jTextField2.setText("Lime");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlProbColors.add((Component)jTextField2, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        jLabel5.setMaximumSize(new Dimension(200, 300));
        jLabel5.setText("INF = infinity;  -INF = negative infinity");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 2, 4, 2);
        jPanel5.add((Component)jLabel5, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Probability must be ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel5.add((Component)jLabel6, gridBagConstraints);
        this.cmbProbComparison = new JComboBox();
        this.cmbProbComparison.setActionCommand("valueComparisonChanged");
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("<  less than");
        defaultComboBoxModel.addElement("<= less than or equal to");
        defaultComboBoxModel.addElement(">  greater than");
        defaultComboBoxModel.addElement(">= greater than or equal to");
        this.cmbProbComparison.setModel(defaultComboBoxModel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel5.add((Component)this.cmbProbComparison, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText(" each limit.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel5.add((Component)jLabel7, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        jLabel8.setFont(new Font(jLabel8.getFont().getName(), 1, jLabel8.getFont().getSize()));
        jLabel8.setName("headerValues");
        jLabel8.setText("Probability Ranges and Colors:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel4.add((Component)jLabel8, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel4.add((Component)jPanel6, gridBagConstraints);
        this.btnAddProbRule = new JButton();
        this.btnAddProbRule.setActionCommand("addProbRule");
        this.btnAddProbRule.setText("Add Rule");
        this.btnAddProbRule.setMnemonic('A');
        this.btnAddProbRule.setDisplayedMnemonicIndex(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        jPanel6.add((Component)this.btnAddProbRule, gridBagConstraints);
        this.btnResetProbRules = new JButton();
        this.btnResetProbRules.setText("Reset List");
        this.btnResetProbRules.setMnemonic('R');
        this.btnResetProbRules.setDisplayedMnemonicIndex(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        jPanel6.add((Component)this.btnResetProbRules, gridBagConstraints);
        this.btnRemProbRule = new JButton();
        this.btnRemProbRule.setActionCommand("remProbRule");
        this.btnRemProbRule.setText("Remove Last Rule");
        this.btnRemProbRule.setMnemonic('A');
        this.btnRemProbRule.setDisplayedMnemonicIndex(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        jPanel6.add((Component)this.btnRemProbRule, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridBagLayout());
        jPanel7.setName("mod");
        this.tabs.addTab("Chemical Modification (e.g. SHAPE)", jPanel7);
        JLabel jLabel9 = new JLabel();
        jLabel9.setAutoscrolls(false);
        jLabel9.setText("<html>This tool sets the color of each base according to a data table arranged in two columns.<br>\nThe data can represent chemical modification reactvities (e.g. SHAPE) or any arbitrary criteria.<br>\nIt is <b>not</b> necessary to include a line for each base (unlisted bases will not be colored).<br>\nClick the <b>Help</b> button for more information.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 8, 3);
        jPanel7.add((Component)jLabel9, gridBagConstraints);
        JSplitPane jSplitPane2 = new JSplitPane();
        jSplitPane2.setContinuousLayout(true);
        jSplitPane2.setOneTouchExpandable(false);
        jSplitPane2.setResizeWeight(0.5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel7.add((Component)jSplitPane2, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridBagLayout());
        jSplitPane2.setLeftComponent(jPanel8);
        JLabel jLabel10 = new JLabel();
        jLabel10.setFont(new Font(jLabel10.getFont().getName(), 1, jLabel10.getFont().getSize()));
        jLabel10.setName("headerData");
        jLabel10.setText("Numeric Data");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel8.add((Component)jLabel10, gridBagConstraints);
        JScrollPane jScrollPane3 = new JScrollPane();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel8.add((Component)jScrollPane3, gridBagConstraints);
        this.txtModData = new JTextArea();
        this.txtModData.setText("1\t0.949369084\n2\t0.008434194\n3\t0.115617068\n4\t0.182823643\n5\t0.656706731\n6\t0.761605327");
        jScrollPane3.setViewportView(this.txtModData);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 3;
        jPanel8.add((Component)jPanel9, gridBagConstraints);
        this.btnLoadModFile = new JButton();
        this.btnLoadModFile.setText("Load File...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        jPanel9.add((Component)this.btnLoadModFile, gridBagConstraints);
        this.btnHelpMod = new JButton();
        this.btnHelpMod.setText("Help");
        this.btnHelpMod.setMnemonic('H');
        this.btnHelpMod.setDisplayedMnemonicIndex(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        jPanel9.add((Component)this.btnHelpMod, gridBagConstraints);
        this.btnClearValueText = new JButton();
        this.btnClearValueText.setActionCommand("clearModText");
        this.btnClearValueText.setText("Clear");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        jPanel9.add((Component)this.btnClearValueText, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridBagLayout());
        jSplitPane2.setRightComponent(jPanel10);
        JScrollPane jScrollPane4 = new JScrollPane();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel10.add((Component)jScrollPane4, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridBagLayout());
        jScrollPane4.setViewportView(jPanel11);
        this.pnlValueColors = new JPanel();
        this.pnlValueColors.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        jPanel11.add((Component)this.pnlValueColors, gridBagConstraints);
        JLabel jLabel11 = new JLabel();
        jLabel11.setFont(new Font(jLabel11.getFont().getName(), 1, jLabel11.getFont().getSize()));
        jLabel11.setName("headerLimit");
        jLabel11.setText("Numeric Limit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlValueColors.add((Component)jLabel11, gridBagConstraints);
        this.lblValueColorHeader = new JLabel();
        this.lblValueColorHeader.setFont(new Font(this.lblValueColorHeader.getFont().getName(), 1, this.lblValueColorHeader.getFont().getSize()));
        this.lblValueColorHeader.setName("headerColor");
        this.lblValueColorHeader.setRequestFocusEnabled(true);
        this.lblValueColorHeader.setText("Color (if value < Limit)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlValueColors.add((Component)this.lblValueColorHeader, gridBagConstraints);
        this.btnValueChooseColor = new JButton();
        this.btnValueChooseColor.setActionCommand("color");
        this.btnValueChooseColor.setText("...");
        this.btnValueChooseColor.setToolTipText("Choose Color...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlValueColors.add((Component)this.btnValueChooseColor, gridBagConstraints);
        this.lblValueColor = new JLabel();
        this.lblValueColor.setAutoscrolls(false);
        this.lblValueColor.setBackground(new Color(-16711936));
        this.lblValueColor.setOpaque(true);
        this.lblValueColor.setPreferredSize(new Dimension(40, 24));
        this.lblValueColor.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlValueColors.add((Component)this.lblValueColor, gridBagConstraints);
        this.txtValueLimit = new JTextField();
        this.txtValueLimit.setPreferredSize(new Dimension(100, 24));
        this.txtValueLimit.setText("INF");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pnlValueColors.add((Component)this.txtValueLimit, gridBagConstraints);
        this.txtValueColor = new JTextField();
        this.txtValueColor.setPreferredSize(new Dimension(100, 24));
        this.txtValueColor.setText("Lime");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlValueColors.add((Component)this.txtValueColor, gridBagConstraints);
        JLabel jLabel12 = new JLabel();
        jLabel12.setMaximumSize(new Dimension(200, 300));
        jLabel12.setText("INF = infinity;  -INF = negative infinity");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 2, 4, 2);
        jPanel11.add((Component)jLabel12, gridBagConstraints);
        JLabel jLabel13 = new JLabel();
        jLabel13.setText("Value must be ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel11.add((Component)jLabel13, gridBagConstraints);
        this.cmbValueComparison = new JComboBox();
        this.cmbValueComparison.setActionCommand("valueComparisonChanged");
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel2.addElement("<  less than");
        defaultComboBoxModel2.addElement("<= less than or equal to");
        defaultComboBoxModel2.addElement(">  greater than");
        defaultComboBoxModel2.addElement(">= greater than or equal to");
        this.cmbValueComparison.setModel(defaultComboBoxModel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel11.add((Component)this.cmbValueComparison, gridBagConstraints);
        JLabel jLabel14 = new JLabel();
        jLabel14.setText(" each limit.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel11.add((Component)jLabel14, gridBagConstraints);
        JLabel jLabel15 = new JLabel();
        jLabel15.setFont(new Font(jLabel15.getFont().getName(), 1, jLabel15.getFont().getSize()));
        jLabel15.setName("headerValues");
        jLabel15.setText("Value Ranges and Colors:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel10.add((Component)jLabel15, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel10.add((Component)jPanel12, gridBagConstraints);
        this.btnAddValueRule = new JButton();
        this.btnAddValueRule.setActionCommand("addValueRule");
        this.btnAddValueRule.setText("Add Rule");
        this.btnAddValueRule.setMnemonic('A');
        this.btnAddValueRule.setDisplayedMnemonicIndex(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        jPanel12.add((Component)this.btnAddValueRule, gridBagConstraints);
        this.btnResetValueRules = new JButton();
        this.btnResetValueRules.setText("Reset List");
        this.btnResetValueRules.setMnemonic('R');
        this.btnResetValueRules.setDisplayedMnemonicIndex(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        jPanel12.add((Component)this.btnResetValueRules, gridBagConstraints);
        this.btnRemValueRule = new JButton();
        this.btnRemValueRule.setActionCommand("remValueRule");
        this.btnRemValueRule.setText("Remove Last Rule");
        this.btnRemValueRule.setMnemonic('A');
        this.btnRemValueRule.setDisplayedMnemonicIndex(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        jPanel12.add((Component)this.btnRemValueRule, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new GridBagLayout());
        jPanel13.setName("base");
        this.tabs.addTab("Nucleobase Identity", jPanel13);
        JLabel jLabel16 = new JLabel();
        jLabel16.setAutoscrolls(false);
        jLabel16.setText("<html>This tool sets the color of each base according to its identity (i.e. the symbol/character used to represent it).<br>\nYou can enter as many or as few symbols as desired. Nucleobases that are not listed will not be affected.<br>\nYou can disable a rule below by unchecking the box next to it or by deleting the symbol from the text box.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel13.add((Component)jLabel16, gridBagConstraints);
        JScrollPane jScrollPane5 = new JScrollPane();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel13.add((Component)jScrollPane5, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new GridBagLayout());
        jPanel14.setAlignmentX(0.0f);
        jPanel14.setAlignmentY(0.0f);
        jScrollPane5.setViewportView(jPanel14);
        this.pnlSymbolColors = new JPanel();
        this.pnlSymbolColors.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        jPanel14.add((Component)this.pnlSymbolColors, gridBagConstraints);
        JLabel jLabel17 = new JLabel();
        jLabel17.setFont(new Font(jLabel17.getFont().getName(), 1, 14));
        jLabel17.setName("headerSymbol");
        jLabel17.setText("Nucleobase(s)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSymbolColors.add((Component)jLabel17, gridBagConstraints);
        this.txtBase = new JTextArea();
        this.txtBase.setText("A");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlSymbolColors.add((Component)this.txtBase, gridBagConstraints);
        this.chkUse = new JCheckBox();
        this.chkUse.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.pnlSymbolColors.add((Component)this.chkUse, gridBagConstraints);
        this.txtColor = new JTextArea();
        this.txtColor.setPreferredSize(new Dimension(150, 17));
        this.txtColor.setText("Red");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlSymbolColors.add((Component)this.txtColor, gridBagConstraints);
        JLabel jLabel18 = new JLabel();
        jLabel18.setFont(new Font(jLabel18.getFont().getName(), 1, 14));
        jLabel18.setName("headerColor");
        jLabel18.setText("Color (name or RGB code)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSymbolColors.add((Component)jLabel18, gridBagConstraints);
        this.btnChooseColor = new JButton();
        this.btnChooseColor.setActionCommand("color");
        this.btnChooseColor.setText("Choose...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.pnlSymbolColors.add((Component)this.btnChooseColor, gridBagConstraints);
        this.lblColor = new JLabel();
        this.lblColor.setAutoscrolls(false);
        this.lblColor.setBackground(new Color(-16711936));
        this.lblColor.setOpaque(true);
        this.lblColor.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.pnlSymbolColors.add((Component)this.lblColor, gridBagConstraints);
        this.btnAddSymbolRule = new JButton();
        this.btnAddSymbolRule.setActionCommand("addSymbolRule");
        this.btnAddSymbolRule.setText("Add Rule");
        this.btnAddSymbolRule.setMnemonic('A');
        this.btnAddSymbolRule.setDisplayedMnemonicIndex(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        jPanel14.add((Component)this.btnAddSymbolRule, gridBagConstraints);
        this.btnResetSymbolRules = new JButton();
        this.btnResetSymbolRules.setActionCommand("resetSymbolRules");
        this.btnResetSymbolRules.setText("Reset List");
        this.btnResetSymbolRules.setMnemonic('R');
        this.btnResetSymbolRules.setDisplayedMnemonicIndex(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel14.add((Component)this.btnResetSymbolRules, gridBagConstraints);
        this.chkIgnoreCase = new JCheckBox();
        this.chkIgnoreCase.setActionCommand("");
        this.chkIgnoreCase.setSelected(true);
        this.chkIgnoreCase.setText("Ignore Case (G = g etc.)");
        this.chkIgnoreCase.setToolTipText("If selected the character case of bases will be ignored. So if \"G\" is red then \"g\" will be also.  Otherwise \"G\" and \"g\" are treated as different entities and they must each be listed separately in order to color both.");
        this.chkIgnoreCase.setVisible(false);
        this.chkIgnoreCase.putClientProperty("html.disable", Boolean.FALSE);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        jPanel14.add((Component)this.chkIgnoreCase, gridBagConstraints);
        this.btnRemSymbolRule = new JButton();
        this.btnRemSymbolRule.setActionCommand("remSymbolRule");
        this.btnRemSymbolRule.setText("Remove Last Rule");
        this.btnRemSymbolRule.setMnemonic('A');
        this.btnRemSymbolRule.setDisplayedMnemonicIndex(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        jPanel14.add((Component)this.btnRemSymbolRule, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new GridBagLayout());
        jPanel15.setName("single");
        this.tabs.addTab("Single Color", jPanel15);
        JLabel jLabel19 = new JLabel();
        jLabel19.setText("<html>This tool can be used to color all bases (or all <i>selected</i> bases) the same color.<br>\nFor example, you can select a domain and apply a single color to all bases in that domain.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel15.add((Component)jLabel19, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        jPanel15.add((Component)jPanel16, gridBagConstraints);
        this.btnSingleColor = new JButton();
        this.btnSingleColor.setActionCommand("chooseSingleColor");
        this.btnSingleColor.setText("Choose...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel16.add((Component)this.btnSingleColor, gridBagConstraints);
        this.lblSingleColor = new JLabel();
        this.lblSingleColor.setAutoscrolls(false);
        this.lblSingleColor.setBackground(new Color(-16711936));
        this.lblSingleColor.setOpaque(true);
        this.lblSingleColor.setPreferredSize(new Dimension(100, 20));
        this.lblSingleColor.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel16.add((Component)this.lblSingleColor, gridBagConstraints);
        this.txtSingleColor = new JTextField();
        this.txtSingleColor.setPreferredSize(new Dimension(120, 24));
        this.txtSingleColor.setText("Red");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel16.add((Component)this.txtSingleColor, gridBagConstraints);
        JLabel jLabel20 = new JLabel();
        jLabel20.setText("Color (name or RGB code): ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel16.add((Component)jLabel20, gridBagConstraints);
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.pnlMain.add((Component)jPanel17, gridBagConstraints);
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel17.add((Component)jPanel18, gridBagConstraints);
        jPanel18.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Scope of Operation"));
        JLabel jLabel21 = new JLabel();
        jLabel21.setText("Structures Affected:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel18.add((Component)jLabel21, gridBagConstraints);
        this.optBasesAll = new JRadioButton();
        this.optBasesAll.setText("All Bases");
        this.optBasesAll.setMnemonic('B');
        this.optBasesAll.setDisplayedMnemonicIndex(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel18.add((Component)this.optBasesAll, gridBagConstraints);
        this.optStructuresAll = new JRadioButton();
        this.optStructuresAll.setText("All Structures");
        this.optStructuresAll.setMnemonic('S');
        this.optStructuresAll.setDisplayedMnemonicIndex(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel18.add((Component)this.optStructuresAll, gridBagConstraints);
        this.optStructuresCurrent = new JRadioButton();
        this.optStructuresCurrent.setText("Current Structure");
        this.optStructuresCurrent.setMnemonic('C');
        this.optStructuresCurrent.setDisplayedMnemonicIndex(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel18.add((Component)this.optStructuresCurrent, gridBagConstraints);
        this.optBasesSelected = new JRadioButton();
        this.optBasesSelected.setText("Selected Bases Only");
        this.optBasesSelected.setMnemonic('S');
        this.optBasesSelected.setDisplayedMnemonicIndex(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel18.add((Component)this.optBasesSelected, gridBagConstraints);
        JLabel jLabel22 = new JLabel();
        jLabel22.setText("Nucleobases Affected:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel18.add((Component)jLabel22, gridBagConstraints);
        JPanel jPanel19 = new JPanel();
        jPanel19.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel17.add((Component)jPanel19, gridBagConstraints);
        this.btnClose = new JButton();
        this.btnClose.setActionCommand("close");
        this.btnClose.setHorizontalTextPosition(0);
        this.btnClose.setText("Close");
        this.btnClose.setMnemonic('C');
        this.btnClose.setDisplayedMnemonicIndex(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel19.add((Component)this.btnClose, gridBagConstraints);
        JLabel jLabel23 = new JLabel();
        jLabel23.setText("Apply To:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel19.add((Component)jLabel23, gridBagConstraints);
        this.btnApplyText = new JButton();
        this.btnApplyText.setActionCommand("apply-text");
        this.btnApplyText.setHorizontalAlignment(0);
        this.btnApplyText.setPreferredSize(new Dimension(180, 32));
        this.btnApplyText.setText("Text (symbols)");
        this.btnApplyText.setMnemonic('T');
        this.btnApplyText.setDisplayedMnemonicIndex(0);
        this.btnApplyText.setToolTipText("Apply the color operation to the Text (symbols) of bases.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel19.add((Component)this.btnApplyText, gridBagConstraints);
        this.btnApplyFill = new JButton();
        this.btnApplyFill.setActionCommand("apply-fill");
        this.btnApplyFill.setHorizontalAlignment(0);
        this.btnApplyFill.setPreferredSize(new Dimension(180, 32));
        this.btnApplyFill.setText("Fill (background)");
        this.btnApplyFill.setMnemonic('F');
        this.btnApplyFill.setDisplayedMnemonicIndex(0);
        this.btnApplyFill.setToolTipText("Apply the color operation to fill in the background of bases.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel19.add((Component)this.btnApplyFill, gridBagConstraints);
        this.btnApplyOutline = new JButton();
        this.btnApplyOutline.setActionCommand("apply-line");
        this.btnApplyOutline.setHorizontalAlignment(0);
        this.btnApplyOutline.setPreferredSize(new Dimension(180, 32));
        this.btnApplyOutline.setText("Outlines");
        this.btnApplyOutline.setMnemonic('O');
        this.btnApplyOutline.setDisplayedMnemonicIndex(0);
        this.btnApplyOutline.setToolTipText("Apply the color operation to the circle outline around bases.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel19.add((Component)this.btnApplyOutline, gridBagConstraints);
        this.btnApplyBond = new JButton();
        this.btnApplyBond.setActionCommand("apply-bond");
        this.btnApplyBond.setHorizontalAlignment(0);
        this.btnApplyBond.setPreferredSize(new Dimension(180, 32));
        this.btnApplyBond.setText("Base-Pair Bonds");
        this.btnApplyBond.setMnemonic('B');
        this.btnApplyBond.setDisplayedMnemonicIndex(10);
        this.btnApplyBond.setToolTipText("Apply the color operation to the bonds that connect base-pairs. (This has no effect on unpaired bases.)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel19.add((Component)this.btnApplyBond, gridBagConstraints);
        JPanel jPanel20 = new JPanel();
        jPanel20.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.ipady = 3;
        jPanel17.add((Component)jPanel20, gridBagConstraints);
        jPanel20.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Reset to Defaults"));
        this.btnResetText = new JButton();
        this.btnResetText.setActionCommand("reset-text");
        this.btnResetText.setHorizontalAlignment(0);
        this.btnResetText.setPreferredSize(new Dimension(180, 32));
        this.btnResetText.setText("Reset Text");
        this.btnResetText.setToolTipText("Reset the Text color of bases to the default color.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel20.add((Component)this.btnResetText, gridBagConstraints);
        this.btnResetFill = new JButton();
        this.btnResetFill.setActionCommand("reset-fill");
        this.btnResetFill.setHorizontalAlignment(0);
        this.btnResetFill.setPreferredSize(new Dimension(180, 32));
        this.btnResetFill.setText("Reset Fill");
        this.btnResetFill.setToolTipText("Reset the Fill color of bases to the default color.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel20.add((Component)this.btnResetFill, gridBagConstraints);
        this.btnResetAll = new JButton();
        this.btnResetAll.setActionCommand("reset-all");
        this.btnResetAll.setFont(new Font(this.btnResetAll.getFont().getName(), this.btnResetAll.getFont().getStyle(), this.btnResetAll.getFont().getSize()));
        this.btnResetAll.setHorizontalAlignment(0);
        this.btnResetAll.setPreferredSize(new Dimension(180, 32));
        this.btnResetAll.setText("Reset All");
        this.btnResetAll.setToolTipText("Reset/Clear all custom Color annotations.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel20.add((Component)this.btnResetAll, gridBagConstraints);
        this.btnResetOutline = new JButton();
        this.btnResetOutline.setActionCommand("reset-line");
        this.btnResetOutline.setHorizontalAlignment(0);
        this.btnResetOutline.setPreferredSize(new Dimension(180, 32));
        this.btnResetOutline.setText("Reset Outlines");
        this.btnResetOutline.setToolTipText("Reset the Outline color of bases to the default color.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel20.add((Component)this.btnResetOutline, gridBagConstraints);
        this.btnResetBond = new JButton();
        this.btnResetBond.setActionCommand("reset-bond");
        this.btnResetBond.setHorizontalAlignment(0);
        this.btnResetBond.setPreferredSize(new Dimension(180, 32));
        this.btnResetBond.setText("Reset Bonds");
        this.btnResetBond.setToolTipText("Reset the Bond color of bases to the default color.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel20.add((Component)this.btnResetBond, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.optStructuresAll);
        buttonGroup.add(this.optStructuresCurrent);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.optBasesAll);
        buttonGroup.add(this.optBasesSelected);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.pnlMain;
    }

    public void showColorChooser(ColorEditControl colorEditControl) {
        Color color = JColorChooser.showDialog(this, "Choose a Color", colorEditControl.getColor());
        if (color != null) {
            colorEditControl.setColor(color);
        }
    }

    private static void addClickHandler(JComponent jComponent, final Consumer<MouseEvent> consumer) {
        jComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                consumer.accept(mouseEvent);
            }
        });
    }

    private void correctPreferredHeight(JComponent ... jComponentArray) {
        for (JComponent jComponent : jComponentArray) {
            Dimension dimension = jComponent.getPreferredSize();
            jComponent.setPreferredSize(null);
            jComponent.setPreferredSize(new Dimension(dimension.width, jComponent.getPreferredSize().height));
        }
    }

    private void addSymbolColorRule(String string, Color color) {
        SymbolColorRule symbolColorRule = new SymbolColorRule(this);
        symbolColorRule.setColor(color);
        symbolColorRule.setSymbol(string);
        this.symbolColorRules.add(symbolColorRule);
        symbolColorRule.addToPanel(this.pnlSymbolColors, this.symbolColorRules.size());
    }

    private void addValueColorRule(String string, Color color) {
        ValueColorRule valueColorRule = new ValueColorRule(this);
        valueColorRule.setValue(string);
        valueColorRule.setColor(color);
        this.valueColorRules.add(valueColorRule);
        valueColorRule.addToPanel(this.pnlValueColors, this.valueColorRules.size());
    }

    private void addProbColorRule(String string, Color color) {
        ValueColorRule valueColorRule = new ValueColorRule(this);
        valueColorRule.setValue(string);
        valueColorRule.setColor(color);
        this.probColorRules.add(valueColorRule);
        valueColorRule.addToPanel(this.pnlProbColors, this.probColorRules.size());
    }

    private void invokeScrollToComponent(Component component) {
        SwingUtilities.invokeLater(() -> ((JComponent)component.getParent()).scrollRectToVisible(component.getBounds()));
    }

    private boolean removeLastRule(List<? extends SimpleColorControl> list) {
        if (list.size() <= 1) {
            return false;
        }
        SimpleColorControl simpleColorControl = list.get(list.size() - 1);
        JComponent jComponent = simpleColorControl.getPanel();
        simpleColorControl.remove();
        list.remove(list.size() - 1);
        jComponent.revalidate();
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        switch (actionEvent.getActionCommand()) {
            case "addSymbolRule": {
                this.addSymbolColorRule("", Color.GRAY);
                this.pnlSymbolColors.revalidate();
                this.invokeScrollToComponent(this.btnAddSymbolRule);
                break;
            }
            case "addValueRule": {
                this.addValueColorRule("", Color.GRAY);
                this.pnlValueColors.revalidate();
                this.invokeScrollToComponent(this.pnlValueColors.getComponent(this.pnlValueColors.getComponentCount() - 1));
                break;
            }
            case "addProbRule": {
                this.addProbColorRule("", Color.GRAY);
                this.pnlProbColors.revalidate();
                this.invokeScrollToComponent(this.pnlProbColors.getComponent(this.pnlProbColors.getComponentCount() - 1));
                break;
            }
            case "apply-text": {
                this.applyColors(2);
                break;
            }
            case "apply-fill": {
                this.applyColors(1);
                break;
            }
            case "apply-line": {
                this.applyColors(4);
                break;
            }
            case "apply-bond": {
                this.applyColors(8);
                break;
            }
            case "reset-text": {
                this.resetExistingBaseColors(2);
                break;
            }
            case "reset-fill": {
                this.resetExistingBaseColors(1);
                break;
            }
            case "reset-line": {
                this.resetExistingBaseColors(4);
                break;
            }
            case "reset-bond": {
                this.resetExistingBaseColors(8);
                break;
            }
            case "reset-all": {
                this.resetExistingBaseColors(15);
                break;
            }
            case "close": {
                this.close();
            }
        }
    }

    private void close() {
        this.dispose();
    }

    private boolean applyColors(int n) {
        this.saveSettings();
        DrawWindow drawWindow = this.getActiveDrawing(true);
        if (drawWindow == null) {
            return false;
        }
        SceneColorizer sceneColorizer = null;
        switch (this.getTab()) {
            case "prob": {
                SceneColorizer.NumberRangeList numberRangeList = this.readNumericRules(this.probColorRules, "probability", this.getProbComparisonSymbol());
                if (numberRangeList == null) {
                    return false;
                }
                SceneColorizer.PairProbabilityData pairProbabilityData = this.parseProbData(this.txtProbData.getText(), this.calcMaxNucCount(drawWindow.getScenes()));
                if (pairProbabilityData == null) {
                    return false;
                }
                sceneColorizer = SceneColorizer.ColorByProbability(pairProbabilityData, numberRangeList, n);
                break;
            }
            case "mod": {
                SceneColorizer.NumberRangeList numberRangeList = this.readNumericRules(this.valueColorRules, "numeric", this.getValueComparisonSymbol());
                if (numberRangeList == null) {
                    return false;
                }
                double[] dArray = this.parseModData(this.txtModData.getText(), this.calcMaxNucCount(drawWindow.getScenes()));
                if (dArray == null) {
                    return false;
                }
                sceneColorizer = SceneColorizer.ColorByDataValue(dArray, numberRangeList, n);
                break;
            }
            case "base": {
                HashMap<String, Color> hashMap = new HashMap<String, Color>();
                for (SymbolColorRule symbolColorRule : this.symbolColorRules) {
                    if ((!symbolColorRule.isEnabled() || symbolColorRule.getSymbol().trim().isEmpty()) && symbolColorRule.getColorText().trim().isEmpty()) continue;
                    for (char c : symbolColorRule.getSymbol().toCharArray()) {
                        if (Character.isWhitespace(c)) continue;
                        hashMap.put(Character.toString(c), symbolColorRule.getColor());
                    }
                }
                sceneColorizer = SceneColorizer.ColorBySymbol(hashMap, n);
                break;
            }
            case "single": {
                sceneColorizer = SceneColorizer.SingleColor(this.singleColor.getColor(), n);
                break;
            }
            default: {
                Dialogs.showWarning("Unknown tab: " + this.getTab());
            }
        }
        if (sceneColorizer == null) {
            return false;
        }
        drawWindow.colorizeScenes(sceneColorizer, this.optStructuresAll.isSelected(), this.optBasesSelected.isSelected());
        return true;
    }

    private int calcMaxNucCount(RnaSceneGroup rnaSceneGroup) {
        int n = 0;
        for (RnaScene rnaScene : rnaSceneGroup) {
            n = Math.max(n, rnaScene.getNucCount());
        }
        return n;
    }

    private SceneColorizer.NumberRangeList readNumericRules(List<ValueColorRule> list, String string, String string2) {
        double[] dArray = new double[list.size()];
        Color[] colorArray = new Color[list.size()];
        int n = 0;
        for (ValueColorRule valueColorRule : list) {
            if (valueColorRule.getValue().trim().isEmpty() || valueColorRule.getColorText().trim().isEmpty()) continue;
            dArray[n] = this.parseDouble(valueColorRule.getValue());
            colorArray[n] = valueColorRule.getColor();
            if (Double.isNaN(dArray[n])) {
                Dialogs.showWarning("The " + string + " limit in rule %d is not a valid number. Please correct this to continue.");
                valueColorRule.txtValue.grabFocus();
                return null;
            }
            ++n;
        }
        if (n < dArray.length) {
            dArray = Arrays.copyOf(dArray, n);
            colorArray = Arrays.copyOf(colorArray, n);
        }
        SceneColorizer.NumberRangeList numberRangeList = new SceneColorizer.NumberRangeList(dArray, colorArray, string2, null);
        numberRangeList.sortForComparison();
        return numberRangeList;
    }

    private SceneColorizer.PairProbabilityData parseProbData(String string, int n) {
        int n2;
        String[] stringArray = string.split("\r?\n");
        Pattern pattern = Pattern.compile("(\\d+)\\s+(\\d+)\\s+([-\\d.,+eEdD]+)");
        String string2 = ";#!/";
        Object object = null;
        SceneColorizer.PairProbabilityData pairProbabilityData = new SceneColorizer.PairProbabilityData(n);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            String string3 = stringArray[n2].trim();
            if (string3.isEmpty() || string2.indexOf(string3.charAt(0)) != -1) continue;
            Matcher matcher = pattern.matcher(string3);
            if (matcher.matches()) {
                int n3 = this.parseInt(matcher.group(1), Integer.MIN_VALUE);
                int n4 = this.parseInt(matcher.group(2), Integer.MIN_VALUE);
                double d = this.parseDouble(matcher.group(3));
                if (n3 == Integer.MIN_VALUE || n3 > 50000) {
                    object = "invalid nucleobase index: " + matcher.group(1) + " (outside of valid range)";
                    break;
                }
                if (n4 == Integer.MIN_VALUE || n4 > 50000) {
                    object = "invalid nucleobase index: " + matcher.group(2) + " (outside of valid range)";
                    break;
                }
                if (n3 < 1 || n4 < 1) {
                    object = "invalid nucleobase index: " + Math.min(n3, n4) + " (less than 1)";
                    break;
                }
                if (Double.isNaN(d)) {
                    object = "invalid numeric value: \"" + matcher.group(3) + "\"";
                    break;
                }
                if (n3 == n4 && Math.abs(d) > 1.0E-7) {
                    object = "invalid pair: " + n3 + " cannot pair with itself";
                    break;
                }
                if (n3 > n || n4 > n) continue;
                pairProbabilityData.setPair(n3 - 1, n4 - 1, d);
                continue;
            }
            object = "invalid text (malformed number or wrong data format, etc.)";
            break;
        }
        if (object != null) {
            Dialogs.showWarning("The data table contains an error: " + object + " on line " + (n2 + 1) + ".\nPlease correct the problem before continuing.\n\n\nYou can click the Help button to see details about the expected data format.");
            pairProbabilityData = null;
            try {
                int n5 = this.txtProbData.getLineStartOffset(n2);
                int n6 = this.txtProbData.getLineEndOffset(n2);
                this.txtProbData.select(n5, n6 - 1);
                this.txtProbData.grabFocus();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return pairProbabilityData;
    }

    private double[] parseModData(String string, int n) {
        int n2;
        String[] stringArray = string.split("\r?\n");
        Pattern pattern = Pattern.compile("(\\d+)\\s+([-\\d.,+eEdD]+)");
        String string2 = ";#!/";
        Object object = null;
        double[] dArray = new double[n];
        Arrays.fill(dArray, Double.NaN);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            String string3 = stringArray[n2].trim();
            if (string3.isEmpty() || string2.indexOf(string3.charAt(0)) != -1) continue;
            Matcher matcher = pattern.matcher(string3);
            if (matcher.matches()) {
                int n3 = this.parseInt(matcher.group(1), Integer.MIN_VALUE);
                double d = this.parseDouble(matcher.group(2));
                if (n3 == Integer.MIN_VALUE || n3 > 50000) {
                    object = "invalid nucleobase index: " + matcher.group(1) + " (outside of valid range)";
                    break;
                }
                if (n3 < 1) {
                    object = "invalid nucleobase index: " + n3 + " (less than 1)";
                    break;
                }
                if (Double.isNaN(d)) {
                    object = "invalid numeric value: \"" + matcher.group(2) + "\"";
                    break;
                }
                if (n3 >= dArray.length) continue;
                dArray[n3 - 1] = d;
                continue;
            }
            object = "invalid text (malformed number or wrong data format, etc.)";
            break;
        }
        if (object != null) {
            Dialogs.showWarning("The data table contains an error: " + object + " on line " + (n2 + 1) + ".\nPlease correct the problem before continuing.\n\n\nYou can click the Help button to see details about the expected data format.");
            dArray = null;
            try {
                int n4 = this.txtModData.getLineStartOffset(n2);
                int n5 = this.txtModData.getLineEndOffset(n2);
                this.txtModData.select(n4, n5 - 1);
                this.txtModData.grabFocus();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return dArray;
    }

    private int parseInt(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    private double parseDouble(String string) {
        if ((string = string.trim().toUpperCase()).equals("INF") || string.equals("+INF")) {
            return Double.POSITIVE_INFINITY;
        }
        if (string.equals("-INF") || string.equals("- INF") || string.equals("NEGINF")) {
            return Double.NEGATIVE_INFINITY;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    private DrawWindow getActiveDrawing(boolean bl) {
        DrawWindow drawWindow = Program.getInstance().getMainFrame().getActiveDrawing();
        if (bl && drawWindow == null) {
            Dialogs.showWarning("No drawing window is currently active.\nPlease make sure a drawing is open and active, and that no other program windows are covering it.", "No Active Drawing");
        }
        return drawWindow;
    }

    private void resetExistingBaseColors(int n) {
        DrawWindow drawWindow = this.getActiveDrawing(true);
        if (drawWindow != null) {
            drawWindow.colorizeScenes(SceneColorizer.ColorRemover(n), this.optStructuresAll.isSelected(), this.optBasesSelected.isSelected());
        }
    }

    private String getTab() {
        return this.tabs.getSelectedComponent().getName();
    }

    private void saveSettings() {
        try {
            if (this.prefs == null) {
                return;
            }
            this.prefs.put("tab", this.getTab());
            this.prefs.put("bases", this.optBasesAll.isSelected() ? "all" : "sel");
            this.prefs.put("structures", this.optStructuresAll.isSelected() ? "all" : "current");
            this.prefs.put("effect", this._lastColorEffect);
            switch (this.getTab()) {
                case "prob": {
                    Preferences preferences = this.prefs.node("probColors");
                    if (preferences.childrenNames().length > this.probColorRules.size() + 5) {
                        preferences.clear();
                    }
                    int n = 0;
                    for (ValueColorRule valueColorRule : this.probColorRules) {
                        if (valueColorRule.getValue().trim().isEmpty() && valueColorRule.getColorText().trim().isEmpty()) continue;
                        preferences.put("V" + n, valueColorRule.getValue());
                        preferences.put("C" + n, valueColorRule.getColorText().trim());
                        ++n;
                    }
                    preferences.putInt("count", n);
                    this.writeTempFile(this.txtProbData.getText(), ".rnaProbData");
                    this.prefs.put("comparison", this.getProbComparisonSymbol());
                }
                case "mod": {
                    Preferences preferences = this.prefs.node("valueColors");
                    if (preferences.childrenNames().length > this.valueColorRules.size() + 5) {
                        preferences.clear();
                    }
                    int n = 0;
                    for (ValueColorRule valueColorRule : this.valueColorRules) {
                        if (valueColorRule.getValue().trim().isEmpty() && valueColorRule.getColorText().trim().isEmpty()) continue;
                        preferences.put("V" + n, valueColorRule.getValue());
                        preferences.put("C" + n, valueColorRule.getColorText().trim());
                        ++n;
                    }
                    preferences.putInt("count", n);
                    this.writeTempFile(this.txtModData.getText(), ".rnaModData");
                    this.prefs.put("comparison", this.getValueComparisonSymbol());
                    break;
                }
                case "base": {
                    Preferences preferences = this.prefs.node("symbolColors");
                    if (preferences.childrenNames().length > this.symbolColorRules.size() + 5) {
                        preferences.clear();
                    }
                    int n = 0;
                    for (SymbolColorRule symbolColorRule : this.symbolColorRules) {
                        if (symbolColorRule.getSymbol().trim().isEmpty() && symbolColorRule.getColorText().trim().isEmpty()) continue;
                        preferences.put("S" + n, symbolColorRule.getSymbol());
                        preferences.put("C" + n, symbolColorRule.getColorText().trim());
                        preferences.putBoolean("U" + n, symbolColorRule.isEnabled());
                        ++n;
                    }
                    preferences.putInt("count", n);
                    preferences.putBoolean("ignoreCase", this.chkIgnoreCase.isSelected());
                    break;
                }
                case "single": {
                    this.prefs.put("singleColor", this.singleColor.getColorText());
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    private void loadSettings() {
        int n;
        SimpleColorControl simpleColorControl;
        int n2;
        if (this.prefs == null) {
            return;
        }
        this.setTab(this.prefs.get("tab", null));
        if (this.optBasesAll.isEnabled()) {
            ("all".equals(this.prefs.get("bases", "all")) ? this.optBasesAll : this.optBasesSelected).setSelected(true);
        }
        if (this.optStructuresAll.isEnabled()) {
            ("all".equals(this.prefs.get("structures", "all")) ? this.optStructuresAll : this.optStructuresCurrent).setSelected(true);
        }
        this._lastColorEffect = this.prefs.get("effect", this._lastColorEffect);
        Preferences preferences = this.prefs.node("symbolColors");
        int n3 = preferences.getInt("count", this.symbolColorRules.size());
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.symbolColorRules.size() <= n2) {
                this.addSymbolColorRule("", Color.BLACK);
            }
            simpleColorControl = this.symbolColorRules.get(n2);
            ((SymbolColorRule)simpleColorControl).setSymbol(preferences.get("S" + n2, ((SymbolColorRule)simpleColorControl).getSymbol()));
            simpleColorControl.setColorText(preferences.get("C" + n2, simpleColorControl.getColorText()));
            if (preferences.getBoolean("U" + n2, true)) continue;
            ((SymbolColorRule)simpleColorControl).setEnabled(false);
        }
        for (n2 = this.symbolColorRules.size() - 1; n2 >= n3; --n2) {
            this.symbolColorRules.get(n2).remove();
            this.symbolColorRules.remove(n2);
        }
        this.pnlSymbolColors.revalidate();
        this.chkIgnoreCase.setSelected(preferences.getBoolean("ignoreCase", this.chkIgnoreCase.isSelected()));
        preferences = this.prefs.node("valueColors");
        n3 = preferences.getInt("count", this.valueColorRules.size());
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.valueColorRules.size() <= n2) {
                this.addValueColorRule("", Color.BLACK);
            }
            simpleColorControl = this.valueColorRules.get(n2);
            ((ValueColorRule)simpleColorControl).setValue(preferences.get("V" + n2, ((ValueColorRule)simpleColorControl).getValue()));
            simpleColorControl.setColorText(preferences.get("C" + n2, simpleColorControl.getColorText()));
        }
        for (n2 = this.valueColorRules.size() - 1; n2 >= n3; --n2) {
            this.valueColorRules.get(n2).remove();
            this.valueColorRules.remove(n2);
        }
        this.pnlValueColors.revalidate();
        String string = this.readTempFile(".rnaModData");
        if (string != null) {
            this.txtModData.setText(string);
        }
        this.setValueComparison(preferences.get("comparison", this.getValueComparisonSymbol()));
        preferences = this.prefs.node("probColors");
        n3 = preferences.getInt("count", this.probColorRules.size());
        for (n = 0; n < n3; ++n) {
            if (this.probColorRules.size() <= n) {
                this.addProbColorRule("", Color.BLACK);
            }
            ValueColorRule valueColorRule = this.probColorRules.get(n);
            valueColorRule.setValue(preferences.get("V" + n, valueColorRule.getValue()));
            valueColorRule.setColorText(preferences.get("C" + n, valueColorRule.getColorText()));
        }
        for (n = this.probColorRules.size() - 1; n >= n3; --n) {
            this.probColorRules.get(n).remove();
            this.probColorRules.remove(n);
        }
        this.pnlProbColors.revalidate();
        string = this.readTempFile(".rnaProbData");
        if (string != null) {
            this.txtProbData.setText(string);
        }
        this.setProbComparison(preferences.get("comparison", this.getProbComparisonSymbol()));
        this.singleColor.setColorText(this.prefs.get("singleColor", this.singleColor.getColorText()));
    }

    private boolean writeTempFile(String string, String string2) {
        try {
            Path path = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
            Strings.writeAll(string, new FileOutputStream(path.resolve(string2).toFile()));
            return true;
        }
        catch (IOException iOException) {
            System.err.println("Failed to write temporary colorize data file.");
            iOException.printStackTrace();
            return false;
        }
    }

    private String readTempFile(String string) {
        try {
            Path path = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
            File file = path.resolve(string).toFile();
            if (file.exists()) {
                return Strings.readAll(new FileInputStream(file));
            }
        }
        catch (IOException iOException) {
            System.err.println("Failed to read temporary colorize data file.");
            iOException.printStackTrace();
        }
        return null;
    }

    private void setTab(String string) {
        if (string == null) {
            return;
        }
        for (int i = 0; i < this.tabs.getTabCount(); ++i) {
            if (!string.equals(this.tabs.getComponentAt(i).getName())) continue;
            this.tabs.setSelectedIndex(i);
            break;
        }
    }

    private void createUIComponents() {
    }

    private static class SymbolColorRule
    extends SimpleColorControl {
        private JCheckBox chkEnable;
        private JTextField txtSymbol;
        private JTextField txtColor;
        private JButton btnChoose;
        private JLabel lblColor;

        public boolean isEnabled() {
            return this.chkEnable.isSelected();
        }

        public void setEnabled(boolean bl) {
            this.chkEnable.setSelected(bl);
        }

        public void setSymbol(String string) {
            this.txtSymbol.setText(string);
        }

        public String getSymbol() {
            return this.txtSymbol.getText().trim();
        }

        public SymbolColorRule(ColorizeDialog colorizeDialog) {
            super(new JTextField(), new JLabel(""));
            this.txtColor = (JTextField)this.txt;
            this.lblColor = (JLabel)this.box;
            this.chkEnable = new JCheckBox("");
            this.txtSymbol = new JTextField();
            this.btnChoose = new JButton("Choose...");
            this.chkEnable.setSelected(true);
            this.lblColor.setOpaque(true);
            this.chkEnable.addItemListener(this::updateEnabledUI);
            this.txtColor.setPreferredSize(new Dimension(120, this.txtColor.getPreferredSize().height));
            this.addBoxClickHandler(colorizeDialog);
            this.btnChoose.addActionListener(actionEvent -> colorizeDialog.showColorChooser(this));
            colorizeDialog.docListener.listen(this.txtColor);
        }

        private void updateEnabledUI(ItemEvent itemEvent) {
            boolean bl = this.isEnabled();
            this.txtSymbol.setEnabled(bl);
            this.txtColor.setEnabled(bl);
            this.btnChoose.setEnabled(bl);
        }

        public void addToPanel(JComponent jComponent) {
            this.addToPanel(jComponent, -1);
        }

        public void addToPanel(JComponent jComponent, int n) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 2, 0, 2);
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            jComponent.add((Component)this.chkEnable, gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.gridx = 1;
            jComponent.add((Component)this.txtSymbol, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            jComponent.add((Component)this.txtColor, gridBagConstraints);
            gridBagConstraints.gridx = 4;
            jComponent.add((Component)this.btnChoose, gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            jComponent.add((Component)this.lblColor, gridBagConstraints);
        }

        @Override
        public void remove() {
            JComponent jComponent = (JComponent)this.btnChoose.getParent();
            if (jComponent == null) {
                return;
            }
            jComponent.remove(this.lblColor);
            jComponent.remove(this.btnChoose);
            jComponent.remove(this.txtColor);
            jComponent.remove(this.txtSymbol);
            jComponent.remove(this.chkEnable);
        }
    }

    private static class ValueColorRule
    extends SimpleColorControl {
        private JTextField txtValue;
        private JTextField txtColor;
        private JButton btnChoose;
        private JLabel lblColor;

        public void setValue(String string) {
            this.txtValue.setText(string);
        }

        public String getValue() {
            return this.txtValue.getText().trim();
        }

        public ValueColorRule(ColorizeDialog colorizeDialog) {
            super(new JTextField(), new JLabel(""));
            this.txtColor = (JTextField)this.txt;
            this.lblColor = (JLabel)this.box;
            this.txtValue = new JTextField();
            this.btnChoose = new JButton(colorizeDialog.btnValueChooseColor.getText());
            this.btnChoose.setToolTipText(colorizeDialog.btnValueChooseColor.getToolTipText());
            this.txtValue.setPreferredSize(colorizeDialog.txtValueLimit.getPreferredSize());
            this.lblColor.setPreferredSize(colorizeDialog.lblValueColor.getPreferredSize());
            this.txtColor.setPreferredSize(colorizeDialog.txtValueColor.getPreferredSize());
            this.lblColor.setOpaque(true);
            this.addBoxClickHandler(colorizeDialog);
            this.btnChoose.addActionListener(actionEvent -> colorizeDialog.showColorChooser(this));
            colorizeDialog.docListener.listen(this.txtColor);
        }

        public void addToPanel(JComponent jComponent) {
            this.addToPanel(jComponent, -1);
        }

        public void addToPanel(JComponent jComponent, int n) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 2, 0, 2);
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            jComponent.add((Component)this.txtValue, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jComponent.add((Component)this.txtColor, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            jComponent.add((Component)this.lblColor, gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            jComponent.add((Component)this.btnChoose, gridBagConstraints);
        }

        @Override
        public void remove() {
            JComponent jComponent = (JComponent)this.btnChoose.getParent();
            if (jComponent == null) {
                return;
            }
            jComponent.remove(this.lblColor);
            jComponent.remove(this.btnChoose);
            jComponent.remove(this.txtColor);
            jComponent.remove(this.txtValue);
        }
    }

    private static class SimpleColorControl
    implements ColorEditControl {
        protected final JTextComponent txt;
        protected final JComponent box;

        public SimpleColorControl(JTextComponent jTextComponent, JComponent jComponent) {
            this.txt = jTextComponent;
            this.box = jComponent;
        }

        @Override
        public void setColor(Color color) {
            if (color != null && !color.equals(Colors.getColor(this.getColorText(), true))) {
                this.txt.setText(Colors.getName(color));
            }
            this.box.setBackground(color == null ? Color.GRAY : color);
        }

        @Override
        public Color getColor() {
            return this.box.getBackground();
        }

        @Override
        public String getColorText() {
            return this.txt.getText();
        }

        @Override
        public void setColorText(String string) {
            this.txt.setText(string);
        }

        public void addBoxClickHandler(ColorizeDialog colorizeDialog) {
            this.box.setCursor(Cursor.getPredefinedCursor(12));
            ColorizeDialog.addClickHandler(this.box, mouseEvent -> colorizeDialog.showColorChooser(this));
        }

        public JComponent getPanel() {
            return (JComponent)this.txt.getParent();
        }

        public void remove() {
        }
    }

    private static interface ColorEditControl {
        public String getColorText();

        public void setColorText(String var1);

        public void setColor(Color var1);

        public Color getColor();

        default public void setColorFromText() {
            this.setColor(Colors.getColor(this.getColorText(), true));
        }
    }
}

