/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.services.drawing.export;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import ur_rna.Utilities.annotation.NotNull;
import ur_rna.Utilities.annotation.Nullable;
import ur_rna.Utilities.geom.ShapeUtil;

public class GraphicsStyle
implements Cloneable {
    public static final Color DEFAULT_BACKGROUND = Color.BLACK;
    public static final Color DEFAULT_COLOR = Color.WHITE;
    public static final Shape DEFAULT_CLIP = null;
    public static final Composite DEFAULT_COMPOSITE = AlphaComposite.SrcOver;
    public static final Font DEFAULT_FONT = Font.decode(null);
    public static final Color DEFAULT_PAINT = DEFAULT_COLOR;
    public static final Stroke DEFAULT_STROKE = new BasicStroke();
    public static final AffineTransform DEFAULT_TRANSFORM = new AffineTransform();
    public static final Color COLOR_EMPTY;
    public static final Color DEFAULT_XOR_MODE;
    private RenderingHints hints;
    private Color color;
    private Color background;
    private Composite composite;
    private Stroke stroke;
    private Font font;
    private Paint paint;
    private Shape clip;
    private Color xorMode;
    private AffineTransform transform;

    public GraphicsStyle() {
        this.reset();
    }

    public GraphicsStyle clone() {
        try {
            GraphicsStyle graphicsStyle = (GraphicsStyle)super.clone();
            graphicsStyle.hints = (RenderingHints)this.hints.clone();
            graphicsStyle.clip = ShapeUtil.clone(this.clip);
            graphicsStyle.transform = new AffineTransform(this.transform);
            return graphicsStyle;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }

    public Shape transformShape(Shape shape) {
        return ShapeUtil.transform(shape, this.transform);
    }

    public Shape untransformShape(Shape shape) {
        return ShapeUtil.inverseTransform(shape, this.transform);
    }

    public RenderingHints getHints() {
        return this.hints;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.paint = color;
    }

    public Shape getClip() {
        return this.clip;
    }

    public void setClip(Shape shape) {
        this.clip = shape;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    @NotNull
    public Color getXorMode() {
        return this.xorMode;
    }

    public void setXorMode(@Nullable Color color) {
        this.xorMode = color == null ? DEFAULT_XOR_MODE : color;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
        this.xorMode = COLOR_EMPTY;
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform.setTransform(affineTransform);
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public boolean equals(Object object) {
        return object instanceof GraphicsStyle && this.equals((GraphicsStyle)object);
    }

    public boolean equals(GraphicsStyle graphicsStyle) {
        return graphicsStyle == this || graphicsStyle != null && this.hints.equals(graphicsStyle.hints) && this.background.equals(graphicsStyle.background) && this.color.equals(graphicsStyle.color) && this.composite.equals(graphicsStyle.composite) && this.font.equals(graphicsStyle.font) && this.paint.equals(graphicsStyle.paint) && this.stroke.equals(graphicsStyle.stroke) && this.transform.equals(graphicsStyle.transform) && this.xorMode.equals(graphicsStyle.xorMode) && (this.clip == graphicsStyle.clip || this.clip != null && this.clip.equals(graphicsStyle.clip));
    }

    public boolean isDefault() {
        return this.hints.isEmpty() && DEFAULT_XOR_MODE.equals(this.xorMode) && DEFAULT_BACKGROUND.equals(this.background) && DEFAULT_COLOR.equals(this.color) && DEFAULT_COMPOSITE.equals(this.composite) && DEFAULT_FONT.equals(this.font) && DEFAULT_PAINT.equals(this.paint) && DEFAULT_STROKE.equals(this.stroke) && this.clip == DEFAULT_CLIP && DEFAULT_TRANSFORM.equals(this.transform);
    }

    public void reset() {
        this.hints = new RenderingHints(null);
        this.background = DEFAULT_BACKGROUND;
        this.color = DEFAULT_COLOR;
        this.clip = DEFAULT_CLIP;
        this.composite = DEFAULT_COMPOSITE;
        this.font = DEFAULT_FONT;
        this.paint = DEFAULT_PAINT;
        this.stroke = DEFAULT_STROKE;
        this.xorMode = DEFAULT_XOR_MODE;
        this.transform = new AffineTransform(DEFAULT_TRANSFORM);
    }

    public void copyFrom(Graphics2D graphics2D) {
        this.transform = graphics2D.getTransform();
        this.clip = this.transformShape(graphics2D.getClip());
        this.hints = graphics2D.getRenderingHints();
        this.background = graphics2D.getBackground();
        this.color = graphics2D.getColor();
        this.paint = graphics2D.getPaint();
        this.stroke = graphics2D.getStroke();
        this.font = graphics2D.getFont();
        this.composite = graphics2D.getComposite();
        if (this.composite == AlphaComposite.Xor) {
            this.xorMode = Color.GRAY;
        }
    }

    static {
        DEFAULT_XOR_MODE = COLOR_EMPTY = new Color(0, true);
    }
}

