/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.services.drawing;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class View2D {
    public static final View2D IDENTITY = new View2D();
    public final AffineTransform trToScreen;
    public final AffineTransform trToModel;
    public final Rectangle screenBounds;
    public final Rectangle2D modelBounds;
    public final Dimension screenMargin;
    private final Point2D.Double tmpPt1 = new Point2D.Double();
    private final Point2D.Double tmpPt2 = new Point2D.Double();

    public View2D() {
        this.trToScreen = new AffineTransform();
        this.trToModel = new AffineTransform();
        this.screenBounds = new Rectangle();
        this.modelBounds = new Rectangle2D.Float();
        this.screenMargin = new Dimension(0, 0);
    }

    public View2D(AffineTransform affineTransform, Rectangle rectangle) {
        this();
        this.setView(affineTransform, rectangle);
    }

    public void setView(View2D view2D) {
        this.trToScreen.setTransform(view2D.trToScreen);
        this.trToModel.setTransform(view2D.trToModel);
        this.screenBounds.setBounds(view2D.screenBounds);
        this.modelBounds.setRect(view2D.modelBounds);
        this.screenMargin.setSize(view2D.screenMargin);
    }

    public void setView(AffineTransform affineTransform, Rectangle rectangle) {
        this.trToScreen.setTransform(affineTransform);
        this.trToModel.setTransform(affineTransform);
        try {
            this.trToModel.invert();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            this.trToModel.setToTranslation(-this.trToScreen.getTranslateX(), -this.trToScreen.getTranslateY());
            this.trToModel.scale(1.0 / this.trToScreen.getScaleX(), 1.0 / this.trToScreen.getScaleY());
        }
        this.screenBounds.setRect(rectangle);
        this.toModel(rectangle, this.modelBounds);
    }

    public boolean isInScreenBounds(Point2D point2D) {
        return this.screenBounds.contains(point2D);
    }

    public boolean isInModelBounds(Point2D point2D) {
        return this.modelBounds.contains(point2D);
    }

    public boolean isInScreenBounds(Shape shape) {
        return this.screenBounds.contains(shape.getBounds2D());
    }

    public boolean isInModelBounds(Shape shape) {
        return this.modelBounds.contains(shape.getBounds2D());
    }

    public Point2D toScreen(Point2D point2D) {
        return this.trToScreen.transform(point2D, point2D);
    }

    public Point2D toModel(Point2D point2D) {
        return this.trToModel.transform(point2D, point2D);
    }

    public Point2D rayToScreen(Point2D point2D) {
        return this.trToScreen.deltaTransform(point2D, point2D);
    }

    public Point2D rayToModel(Point2D point2D) {
        return this.trToModel.deltaTransform(point2D, point2D);
    }

    public Point2D toScreen(Point2D point2D, Point2D point2D2) {
        return this.trToScreen.transform(point2D, point2D2);
    }

    public Point2D toModel(Point2D point2D, Point2D point2D2) {
        return this.trToModel.transform(point2D, point2D2);
    }

    public Point2D rayToScreen(Point2D point2D, Point2D point2D2) {
        return this.trToScreen.deltaTransform(point2D, point2D2);
    }

    public Point2D rayToModel(Point2D point2D, Point2D point2D2) {
        return this.trToModel.deltaTransform(point2D, point2D2);
    }

    public Rectangle2D toModel(Rectangle2D rectangle2D) {
        return this.toModel(rectangle2D, rectangle2D);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle2D toModel(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (rectangle2D2 == null) {
            rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        }
        Point2D.Double double_ = this.tmpPt1;
        synchronized (double_) {
            this.tmpPt1.setLocation(rectangle2D.getX(), rectangle2D.getY());
            this.tmpPt2.setLocation(this.tmpPt1.x + rectangle2D.getWidth(), this.tmpPt1.y + rectangle2D.getHeight());
            rectangle2D2.setFrameFromDiagonal(this.toModel(this.tmpPt1), this.toModel(this.tmpPt2));
        }
        return rectangle2D2;
    }

    public Rectangle2D toScreen(Rectangle2D rectangle2D) {
        return this.toScreen(rectangle2D, rectangle2D);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle2D toScreen(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (rectangle2D2 == null) {
            rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        }
        Point2D.Double double_ = this.tmpPt1;
        synchronized (double_) {
            this.tmpPt1.setLocation(rectangle2D.getX(), rectangle2D.getY());
            this.tmpPt2.setLocation(this.tmpPt1.x + rectangle2D.getWidth(), this.tmpPt1.y + rectangle2D.getHeight());
            rectangle2D2.setFrameFromDiagonal(this.toScreen(this.tmpPt1), this.toScreen(this.tmpPt2));
        }
        return rectangle2D2;
    }

    public int hashCode() {
        return this.trToScreen.hashCode() * 7247 ^ this.screenBounds.hashCode();
    }
}

