/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.services.drawing;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import ur_rna.RNAstructure.RnaBackendException;
import ur_rna.RNAstructure.backend.RNA;
import ur_rna.StructureEditor.Program;
import ur_rna.StructureEditor.models.Bond;
import ur_rna.StructureEditor.models.DrawSettings;
import ur_rna.StructureEditor.models.Motif;
import ur_rna.StructureEditor.models.Nuc;
import ur_rna.StructureEditor.models.RnaScene;
import ur_rna.StructureEditor.models.RnaSceneGroup;
import ur_rna.StructureEditor.models.Strand;
import ur_rna.StructureEditor.services.SceneController;
import ur_rna.StructureEditor.services.SceneDrawMode;
import ur_rna.StructureEditor.services.fileIO.RnaFileIO;
import ur_rna.Utilities.geom.Ellipses;
import ur_rna.Utilities.geom.Vec2D;

public class NucLayout {
    private DrawSettings drawSettings;

    public NucLayout() {
        this(new DrawSettings());
    }

    public NucLayout(DrawSettings drawSettings) {
        this.drawSettings = drawSettings;
    }

    public void redrawRadial(RnaScene rnaScene) throws RnaBackendException {
        RNA rNA = RnaFileIO.createRNAfromScene(rnaScene, true, true, true);
        this.backendRedrawRadial(rnaScene, rNA, 1);
    }

    private void backendRedrawRadial(RnaScene rnaScene, RNA rNA, int n) {
        int n2 = (int)this.drawSettings.nucRadius;
        boolean bl = Program.getInstance().settings().DrawClockwise;
        int n3 = rNA.GetSequenceLength();
        if (n3 == 0) {
            return;
        }
        if (!rnaScene.hasBonds()) {
            this.redrawCircular(rnaScene);
            return;
        }
        rnaScene.drawMode = SceneDrawMode.Standard;
        rnaScene.drawFlipped = bl;
        RnaFileIO.breakBackendPseudoknots(rnaScene, rNA, n);
        int n4 = NucLayout.iceil(2.0f * this.drawSettings.nucRadius);
        rNA.DetermineDrawingCoordinates(n4, n4, n);
        Rectangle rectangle = new Rectangle();
        rectangle.setLocation(rNA.GetNucleotideXCoordinate(1), rNA.GetNucleotideYCoordinate(1));
        int n5 = 0;
        int n6 = 0;
        Strand strand = rnaScene.strands.get(n6);
        char[] cArray = rNA.GetSequence().toCharArray();
        for (int i = 1; i <= n3; ++i) {
            if (RnaFileIO.isInterStrandLinker(cArray[i - 1])) {
                if (n5 == 0) continue;
                n5 = 0;
                strand = rnaScene.strands.get(++n6);
                while (strand.isEmpty()) {
                    strand = rnaScene.strands.get(++n6);
                }
                continue;
            }
            int n7 = rNA.GetNucleotideXCoordinate(i);
            int n8 = rNA.GetNucleotideYCoordinate(i);
            if (bl) {
                n7 = -n7;
            }
            strand.get((int)n5).location.setLocation(n7, n8);
            rectangle.add(n7, n8);
            ++n5;
        }
        float f = n2 - rectangle.x;
        float f2 = n2 - rectangle.y;
        for (Strand strand2 : rnaScene.strands) {
            for (Nuc nuc : strand2) {
                nuc.translate(f, f2);
            }
        }
    }

    private static int iceil(double d) {
        return (int)Math.ceil(d);
    }

    public void redrawRadial(RnaSceneGroup rnaSceneGroup) throws RnaBackendException {
        RNA rNA = RnaFileIO.writeRNAstructureGroup(rnaSceneGroup, true, true);
        for (int i = 0; i < rnaSceneGroup.size(); ++i) {
            this.backendRedrawRadial((RnaScene)rnaSceneGroup.get(i), rNA, 1 + i);
        }
    }

    public void redrawCircular(RnaScene rnaScene) {
        int n = rnaScene.getNucCount() + rnaScene.strands.size();
        float f = this.drawSettings.calcOptimalLoopDistance(n, 1);
        double d = (double)f / (Math.PI * 2);
        int n2 = Program.getInstance().settings().DrawClockwise ? -1 : 1;
        double d2 = this.drawSettings.circularStartAngle;
        int n3 = 0;
        for (Strand strand : rnaScene.strands) {
            for (Nuc nuc : strand) {
                double d3 = d2 + (double)(n2 * n3) * (Math.PI * 2) / (double)n;
                nuc.location.setLocation(d * Math.cos(d3), d * -Math.sin(d3));
                ++n3;
            }
            ++n3;
        }
        rnaScene.drawMode = SceneDrawMode.Circular;
        rnaScene.drawFlipped = n2 == -1;
    }

    public static QuadCurve2D getCircularBond(Bond bond) {
        Vec2D vec2D = new Vec2D(bond.n5.location);
        Vec2D vec2D2 = new Vec2D(bond.n3.location);
        Vec2D vec2D3 = Vec2D.getMidpoint(vec2D, vec2D2);
        double d = vec2D.angleBetween(vec2D2);
        vec2D3.scale(Math.min(1.0, 1.0 - 4.0 * d / (Math.PI * 3)));
        return new QuadCurve2D.Float(bond.n5.location.x, bond.n5.location.y, (float)vec2D3.x, (float)vec2D3.y, bond.n3.location.x, bond.n3.location.y);
    }

    public void redrawLinear(RnaScene rnaScene) {
        float f = this.drawSettings.nucDiameter() + this.drawSettings.nucSpacing;
        int n = 0;
        for (Strand strand : rnaScene.strands) {
            for (Nuc nuc : strand) {
                nuc.location.setLocation(f * (float)n, 0.0f);
                ++n;
            }
            ++n;
        }
        rnaScene.drawMode = SceneDrawMode.Linear;
        rnaScene.drawFlipped = false;
    }

    public static Arc2D getLinearBond(Bond bond) {
        Vec2D vec2D = Vec2D.getMidpoint(bond.n5.location, bond.n3.location);
        Vec2D vec2D2 = new Vec2D(vec2D, bond.n5.location);
        Vec2D vec2D3 = new Vec2D(vec2D, bond.n3.location);
        double d = vec2D2.arcAngleTo(vec2D3, false);
        return Ellipses.arc(vec2D, vec2D2.length(), vec2D2.getAngle(), d, 0);
    }

    public void setDrawSettings(DrawSettings drawSettings) {
        this.drawSettings = drawSettings;
    }

    public void redrawHelix(Motif.Helix helix) {
        Bond bond = helix.first();
        Bond bond2 = helix.last();
        Point2D point2D = bond.midpoint(null);
        Point2D point2D2 = bond2.midpoint(null);
        Vec2D vec2D = Vec2D.getMidpoint(point2D, point2D2);
        Vec2D vec2D2 = new Vec2D(point2D, point2D2);
        Vec2D vec2D3 = bond.normal(null);
        if (point2D.distanceSq(point2D2) < 1.0) {
            vec2D2 = vec2D3;
        }
        boolean bl = vec2D3.dot(vec2D2) < 0.0;
        int n = helix.size();
        float f = this.drawSettings.calcOptimalNuc2NucDistance(bond.n5, bond2.n5) / (float)(n - 1);
        vec2D2.setLength(f);
        float f2 = this.drawSettings.bondLength / 2.0f + this.drawSettings.nucRadius;
        Vec2D vec2D4 = vec2D2.getRotated90().setLength(bl ? (double)(-f2) : (double)f2);
        vec2D.add(vec2D2.x * -0.5 * (double)(n - 1), vec2D2.y * -0.5 * (double)(n - 1));
        Vec2D vec2D5 = new Vec2D();
        for (int i = 0; i < n; ++i) {
            Bond bond3 = helix.getPair(i);
            bond3.n5.location.setLocation(vec2D5.setTo(vec2D).add(vec2D4));
            bond3.n3.location.setLocation(vec2D5.setTo(vec2D).subtr(vec2D4));
            vec2D.add(vec2D2);
        }
    }

    public float calcOptimalMultiLoopRadius(Motif.MultiLoop multiLoop) {
        int n = multiLoop.loopNucCount();
        int n2 = multiLoop.helixCount();
        float f = this.drawSettings.calcOptimalOuterDistance(2 * n2, 0);
        float f2 = this.drawSettings.calcOptimalLoopDistance(n, 2);
        double d = Ellipses.Circle.getRadiusFromArcAndChord(f2, f);
        if (Double.isNaN(d)) {
            d = ((double)f2 + (double)f * 1.4) / (Math.PI * 2);
        }
        return (float)d;
    }

    public Ellipses.Circle calcLoopBestFitCircle(Motif.Loop loop) {
        Nuc nuc = loop.getNuc5().getPrev();
        Nuc nuc2 = loop.getNuc3().getNext();
        Point2D[] point2DArray = new Point2D[loop.size() + (nuc == null ? 0 : 1) + (nuc2 == null ? 0 : 1)];
        int n = 0;
        if (nuc != null) {
            point2DArray[n++] = nuc.getPairBond().midpoint();
        }
        for (int i = 0; i < loop.size(); ++i) {
            point2DArray[n++] = loop.getNucAt((int)i).location;
        }
        if (nuc2 != null) {
            point2DArray[n] = nuc2.getPairBond().midpoint();
        }
        return Ellipses.Circle.calcLeastSquaresFit(point2DArray);
    }

    public Ellipses.Circle calcMultiLoopBestFitCircle(Motif.MultiLoop multiLoop) {
        Point2D[] point2DArray = new Point2D[multiLoop.loopNucCount() + multiLoop.helixCount()];
        int n = 0;
        for (Object object : multiLoop.elements) {
            if (object instanceof Motif.Loop) {
                for (Nuc nuc : ((Motif.Loop)object).getBases()) {
                    point2DArray[n++] = nuc.location;
                }
                continue;
            }
            if (!(object instanceof Bond)) continue;
            point2DArray[n++] = ((Bond)object).midpoint(null);
        }
        return Ellipses.Circle.calcLeastSquaresFit(point2DArray);
    }

    public void redrawMultiLoop(Motif.MultiLoop multiLoop, SceneController sceneController) {
        double d;
        int n = multiLoop.loopNucCount();
        int n2 = multiLoop.helixCount();
        float f = this.drawSettings.calcOptimalOuterDistance(2 * n2, 0);
        float f2 = this.drawSettings.calcOptimalLoopDistance(n, 2);
        double d2 = Ellipses.Circle.getRadiusFromArcAndChord(f2, f);
        if (Double.isNaN(d2)) {
            d2 = ((double)f2 + (double)f * 1.4) / (Math.PI * 2);
        }
        float f3 = Math.min(this.drawSettings.nucRadius, this.drawSettings.calcOptimalOuterDistance(n / 2 + n2, 0));
        Ellipses.Circle circle = this.calcMultiLoopBestFitCircle(multiLoop);
        if (circle == null) {
            d = d2;
        } else {
            d = circle.radius();
            if (d < (double)f3 || d < d2 / 10.0) {
                d = d2;
            } else if (d > d2 * 100.0) {
                d = d2;
            }
        }
        Bond bond = multiLoop.getTrunk();
        Vec2D vec2D = bond.midpoint();
        Vec2D vec2D2 = bond.normal();
        boolean bl = bond.getScene().drawFlipped;
        if (bl) {
            vec2D2.negate();
        }
        Ellipses.Circle circle2 = new Ellipses.Circle(vec2D2.getPointAlong(vec2D, d), d);
        double d3 = (double)f2 / d2 / (double)n;
        double d4 = (Math.PI * 2 * d2 - (double)f2) / d2 / (double)n2;
        double d5 = new Vec2D(circle2.center(), vec2D).getAngle();
        int n3 = bl ? 1 : -1;
        d5 += (double)n3 * d4 / 2.0;
        Vec2D vec2D3 = new Vec2D();
        Vec2D vec2D4 = new Vec2D();
        AffineTransform affineTransform = new AffineTransform();
        for (Object object : multiLoop.elements) {
            if (object instanceof Motif.Loop) {
                for (Nuc nuc : ((Motif.Loop)object).getBases()) {
                    nuc.location.setLocation(circle2.getCircleX(d5 += (double)n3 * d3 / 2.0), circle2.getCircleY(d5));
                    d5 += (double)n3 * d3 / 2.0;
                }
                continue;
            }
            if (!(object instanceof Bond) || object == bond) continue;
            Bond bond2 = (Bond)object;
            circle2.getPoint(d5 += (double)n3 * d4 / 2.0, vec2D4);
            vec2D4.subtr(bond2.midpoint(vec2D));
            Motif.Branch branch = bond2.getScene().getBranch(bond2.n5);
            bond2.normal(vec2D3);
            if (bl) {
                vec2D3.negate();
            }
            affineTransform.setToTranslation(vec2D4.x, vec2D4.y);
            affineTransform.rotate(d5 - vec2D3.getAngle(), vec2D.x, vec2D.y);
            branch.transformAll(affineTransform);
            d5 += (double)n3 * d4 / 2.0;
        }
    }

    public void redrawLoop(Motif.Loop loop) {
    }
}

