/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.services.drawing;

import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import ur_rna.StructureEditor.Program;
import ur_rna.StructureEditor.models.Bond;
import ur_rna.StructureEditor.models.Motif;
import ur_rna.StructureEditor.models.Nuc;
import ur_rna.StructureEditor.models.SceneUpdateInfo;
import ur_rna.StructureEditor.services.SceneController;
import ur_rna.StructureEditor.services.drawing.DrawHandle;
import ur_rna.Utilities.geom.Ellipses;
import ur_rna.Utilities.geom.PointMath;
import ur_rna.Utilities.geom.Vec2D;

public class BranchSlider
extends DrawHandle {
    private Motif.Helix helix;
    private Bond base;
    private Bond b5;
    private Bond b3;
    private Motif.Loop l5;
    private Motif.Loop l3;
    private Set<Nuc> branchNucs = new HashSet<Nuc>();
    private Point handleOffset = new Point();
    private Point2D.Float _ptModel = new Point2D.Float();
    private static final SceneUpdateInfo SlideBranch = SceneUpdateInfo.Layout.subType("Rotated/Adjusted Branch");

    public BranchSlider(SceneController sceneController) {
        super(sceneController);
        this.boxSize = 20;
        this.setIcon(Program.getImage("slide-branch-handle"));
    }

    @Override
    public boolean isValid() {
        return this.helix != null;
    }

    @Override
    public void setSelection(Nuc nuc, Collection<Nuc> collection) {
        super.setSelection(nuc, collection);
    }

    @Override
    protected void nucPositionsChanged() {
    }

    @Override
    protected void performDrag(Point point, Point point2, Point point3, SceneController.DragOpts dragOpts) {
        this.moveLocation(point, point3);
        this.getModelSpaceDeltaTransform(point, point3).transform(this.targetNuc.location, this._ptModel);
        this.positionNucs(this._ptModel, dragOpts);
    }

    private void positionNucs(Point2D.Float float_, SceneController.DragOpts dragOpts) {
        double d;
        boolean bl;
        Vec2D vec2D;
        if (this.base == null) {
            return;
        }
        Vec2D vec2D2 = Vec2D.getMidpoint(this.base.n5.location, this.base.n3.location);
        Vec2D vec2D3 = this.b5 == null ? null : Vec2D.getMidpoint(this.b5.n5.location, this.b5.n3.location);
        Vec2D vec2D4 = vec2D = this.b3 == null ? null : Vec2D.getMidpoint(this.b3.n5.location, this.b3.n3.location);
        if (vec2D3 == null && this.l5 != null && this.l5.getType() == Motif.Loop.LoopType.Terminal) {
            vec2D3 = new Vec2D(this.l5.getNuc5().location);
        }
        if (vec2D == null && this.l3 != null && this.l3.getType() == Motif.Loop.LoopType.Terminal) {
            vec2D = new Vec2D(this.l3.getNuc3().location);
        }
        Ellipses.Circle circle = null;
        if (vec2D3 != null && vec2D != null) {
            circle = vec2D3.equals(vec2D) || vec2D3.distanceSq(vec2D) < 5.0 ? (this.l3 != null ? Ellipses.Circle.calcFromPoints(vec2D, vec2D2, this.l3.getNucAt((int)(this.l3.size() / 2)).location) : (this.l5 != null ? Ellipses.Circle.calcFromPoints(vec2D, vec2D2, this.l5.getNucAt((int)(this.l5.size() / 2)).location) : Ellipses.Circle.calcFromPoints(vec2D2, this.b3.n3.location, this.b3.n5.location))) : Ellipses.Circle.calcFromPoints(vec2D, vec2D3, vec2D2);
        }
        if (circle == null) {
            this.positionNucsRotate(float_, dragOpts);
            return;
        }
        if (!dragOpts.disableHints) {
            this.controller.addHint(circle).fromModel();
        }
        float f = this.controller.getSettings().nucleotideRadius(this.targetNuc);
        double d2 = Math.min(Vec2D.distanceSq(circle.center(), this.base.n5.location), Vec2D.distanceSq(circle.center(), this.base.n3.location));
        double d3 = Vec2D.distanceSq(circle.center(), this.targetNuc.location);
        boolean bl2 = d3 < d2 - (double)(f * f);
        Vec2D vec2D5 = new Vec2D(circle.center(), vec2D2);
        Vec2D vec2D6 = new Vec2D(this.base.n5.location, this.base.n3.location).rotate90();
        boolean bl3 = bl = vec2D5.dot(vec2D6) < 0.0;
        if (!dragOpts.disableHints) {
            this.controller.addHint(vec2D6.toLine(circle.center(), vec2D5.length() * 1.25)).color(bl ? Color.RED : Color.ORANGE).fromModel();
        }
        if (bl2 != bl) {
            vec2D6.negate();
        }
        if (Math.abs(d = vec2D6.angleTo(vec2D5)) > Math.PI / 90) {
            this.controller.rotateNucs(this.branchNucs, vec2D2, d);
        }
        this.controller.rotateNucs(this.branchNucs, circle.center(), this.startLocation, this.location, dragOpts, this.helix, false);
        this.controller.addHint(new Ellipses.Circle(this.base.n5.location, 4.0)).fromModel().color(Color.RED);
        this.controller.addHint(new Ellipses.Circle(this.base.n3.location, 4.0)).fromModel().color(Color.ORANGE);
        if (this.l5 != null) {
            this.positionLoopNucs(new Motif.Segment(this.b5 == null ? this.l5.start : this.b5.right(this.base.n5), this.base.n5), circle, bl);
        }
        if (this.l3 != null && this.l3 != this.l5) {
            this.positionLoopNucs(new Motif.Segment(this.base.n3, this.b3 == null ? this.l3.end : this.b3.left(this.base.n3)), circle, bl);
        }
        this.controller.controlsUpdated();
    }

    private void positionLoopNucs(Motif.Segment segment, Ellipses.Circle circle, boolean bl) {
        Point2D.Float float_ = circle.center();
        Vec2D vec2D = new Vec2D(float_, segment.start.location);
        Vec2D vec2D2 = new Vec2D(float_, segment.end.location);
        double d = vec2D.arcAngleTo(vec2D2, !bl);
        double d2 = vec2D.getAngle();
        int n = segment.size();
        for (int i = 1; i < n - 1; ++i) {
            double d3 = d2 + d * (double)i / (double)(n - 1);
            segment.getNucAt((int)i).location.setLocation(circle.getCircleX(d3), circle.getCircleY(d3));
        }
    }

    private void positionNucsRotate(Point2D.Float float_, SceneController.DragOpts dragOpts) {
        this.controller.rotateNucs(new HashSet<Nuc>(this.targetNuc.getBranch().getBases()), null, this.startLocation, this.location, dragOpts);
    }

    @Override
    protected void prepareDraw(boolean bl) {
        if (!this.isValid()) {
            return;
        }
        if (!bl) {
            double d = (double)this.controller.getSettings().nucleotideRadius(null) * this.view.trToScreen.getScaleX() + (double)this.getBoxSize() * Math.sqrt(2.0) / 2.0;
            PointMath.scale(this.handleOffset, d / PointMath.magnitude(this.handleOffset));
            this.view.toScreen(this.targetNuc.location, this.location);
            this.location.translate(Math.round(this.handleOffset.x), Math.round(this.handleOffset.y));
        }
    }

    @Override
    protected void selectionChanged() {
        this.b3 = null;
        this.b5 = null;
        this.base = null;
        this.l3 = null;
        this.l5 = null;
        this.helix = this.targetNuc == null ? null : this.targetNuc.getHelix();
        this.branchNucs.clear();
        if (this.helix != null) {
            this.branchNucs.addAll(this.targetNuc.getBranch().getBases());
            this.base = this.helix.getPair(0);
            Nuc nuc = this.base.n5.getPrev();
            if (nuc != null) {
                this.l5 = nuc.getLoop();
                this.b5 = nuc.getPairBond();
                if (this.l5 != null && this.b5 == null && (nuc = this.l5.getNuc5().getPrev()) != null) {
                    this.b5 = nuc.getPairBond();
                }
            }
            if ((nuc = this.base.n3.getNext()) != null) {
                this.l3 = nuc.getLoop();
                this.b3 = nuc.getPairBond();
                if (this.l3 != null && this.b3 == null && (nuc = this.l3.getNuc3().getNext()) != null) {
                    this.b3 = nuc.getPairBond();
                }
            }
        }
        this.calcHandleOffset();
        this.view.rayToScreen(this.handleOffset);
    }

    private void calcHandleOffset() {
        if (this.targetNuc == null || this.targetNuc.getPaired() == null) {
            return;
        }
        Vec2D vec2D = new Vec2D(this.targetNuc.getPaired().location, this.targetNuc.location);
        this.handleOffset.setLocation(vec2D);
    }

    @Override
    public SceneUpdateInfo getCompletionEvent() {
        return SlideBranch;
    }
}

