/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.services;

import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.function.Consumer;
import ur_rna.StructureEditor.Program;
import ur_rna.StructureEditor.Settings;
import ur_rna.StructureEditor.models.DrawSettings;
import ur_rna.StructureEditor.models.HistoryUpdateEvent;
import ur_rna.StructureEditor.models.Motif;
import ur_rna.StructureEditor.models.Nuc;
import ur_rna.StructureEditor.models.SceneUpdateInfo;
import ur_rna.StructureEditor.services.SceneUpdateEvent;
import ur_rna.StructureEditor.services.drawing.DrawHint;
import ur_rna.StructureEditor.services.drawing.ICanvas;
import ur_rna.Utilities.geom.Vec2D;

public interface SceneController {
    public void addUndo(SceneUpdateInfo var1);

    public boolean canUndo();

    public boolean canRedo();

    public void redo();

    public void undo();

    public void clearUndo();

    public void selectionUpdated();

    public void viewUpdated();

    public void historyUpdated();

    public void controlsUpdated();

    public void layoutUpdated(SceneUpdateInfo var1);

    public void layoutUpdated(SceneUpdateInfo var1, boolean var2);

    public void styleUpdated(SceneUpdateInfo var1);

    public void structureUpdated(SceneUpdateInfo var1);

    public void notifyUpdate(SceneUpdateInfo var1);

    public void notifyUpdate(SceneUpdateInfo var1, boolean var2);

    public boolean addSceneUpdateListener(Consumer<SceneUpdateEvent> var1);

    public boolean removeSceneUpdateListener(Consumer<SceneUpdateEvent> var1);

    public boolean addHistoryListener(Consumer<HistoryUpdateEvent> var1);

    public boolean removeHistoryListener(Consumer<HistoryUpdateEvent> var1);

    public ICanvas getCanvas();

    public DrawSettings getSettings();

    public void rotateNucs(Collection<Nuc> var1, Point2D var2, Point var3, Point var4, DragOpts var5);

    public void rotateNucs(Collection<Nuc> var1, Point2D var2, Point var3, Point var4, DragOpts var5, Motif.Helix var6, boolean var7);

    public void rotateNucs(Collection<Nuc> var1, Point2D var2, double var3);

    public Motif.Helix findBaseHelix(Collection<Nuc> var1);

    public DrawHint addHint(Shape var1);

    public DrawHint addHint(String var1, double var2, double var4);

    public Vec2D calcNormalToNuc(Nuc var1);

    default public Settings programSettings() {
        return Program.getInstance().settings();
    }

    public static class DragOpts {
        public boolean expandMotif;
        public boolean disableHints;
        public boolean special;

        public DragOpts() {
        }

        public DragOpts(boolean bl, boolean bl2, boolean bl3) {
            this.expandMotif = bl;
            this.special = bl2;
            this.disableHints = !bl3;
        }
    }
}

