/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.services;

import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import ur_rna.StructureEditor.models.Bond;
import ur_rna.StructureEditor.models.Nuc;

public abstract class SceneColorizer {
    protected int colorMode;

    protected SceneColorizer(int n) {
        this.colorMode = n;
    }

    public static SceneColorizer ColorRemover(int n) {
        return SceneColorizer.SingleColor(null, n);
    }

    public static SceneColorizer SingleColor(final Color color, int n) {
        return new SceneColorizer(n){

            @Override
            public boolean color(Nuc nuc) {
                return this.setColor(nuc, color);
            }
        };
    }

    public static SceneColorizer ColorBySymbol(final Map<String, Color> map, int n) {
        return new SceneColorizer(n){

            @Override
            public boolean color(Nuc nuc) {
                Color color = (Color)map.get(nuc.symbol);
                return color != null && this.setColor(nuc, color);
            }
        };
    }

    public static SceneColorizer ColorByDataValue(final double[] dArray, final NumberRangeList numberRangeList, int n) {
        return new SceneColorizer(n){

            @Override
            public boolean color(Nuc nuc) {
                int n = nuc.indexInScene();
                if (n >= dArray.length || Double.isNaN(dArray[n])) {
                    return false;
                }
                double d = dArray[n];
                Color color = numberRangeList.lookup(d);
                return color != null && this.setColor(nuc, color);
            }
        };
    }

    public static SceneColorizer ColorByProbability(final PairProbabilityData pairProbabilityData, final NumberRangeList numberRangeList, int n) {
        return new SceneColorizer(n){

            @Override
            public boolean color(Nuc nuc) {
                Bond bond = nuc.getPairBond();
                double d = bond == null ? pairProbabilityData.getSingle(nuc.indexInScene()) : pairProbabilityData.getPair(bond.n5.indexInScene(), bond.n3.indexInScene());
                Color color = numberRangeList.lookup(d);
                return color != null && this.setColor(nuc, color);
            }
        };
    }

    public boolean color(Collection<Nuc> collection) {
        boolean bl = false;
        for (Nuc nuc : collection) {
            bl |= this.color(nuc);
        }
        return bl;
    }

    public abstract boolean color(Nuc var1);

    protected boolean setColor(Nuc nuc, Color color) {
        return this.setColor(nuc, color, this.colorMode);
    }

    protected boolean setColor(Nuc nuc, Color color, int n) {
        switch (n) {
            case 0: {
                return false;
            }
            case 1: {
                if (SceneColorizer.colorsEqual(nuc.style == null ? null : nuc.style.fillColor, color)) break;
                nuc.style().fillColor = color;
                return true;
            }
            case 2: {
                if (SceneColorizer.colorsEqual(nuc.style == null ? null : nuc.style.textColor, color)) break;
                nuc.style().textColor = color;
                return true;
            }
            case 4: {
                if (SceneColorizer.colorsEqual(nuc.style == null ? null : nuc.style.outlineColor, color)) break;
                nuc.style().outlineColor = color;
                return true;
            }
            case 8: {
                if (SceneColorizer.colorsEqual(nuc.style == null ? null : nuc.style.bondColor, color)) break;
                nuc.style().bondColor = color;
                return true;
            }
            default: {
                return (0 != (n & 1) && this.setColor(nuc, color, 1)) | (0 != (n & 2) && this.setColor(nuc, color, 2)) | (0 != (n & 4) && this.setColor(nuc, color, 4)) | (0 != (n & 8) && this.setColor(nuc, color, 8));
            }
        }
        return false;
    }

    private static boolean colorsEqual(Color color, Color color2) {
        return color == color2 || color != null && color.equals(color2);
    }

    public static interface ColorMode {
        public static final int None = 0;
        public static final int Fill = 1;
        public static final int Text = 2;
        public static final int Outline = 4;
        public static final int Bond = 8;
    }

    public static enum Comparison {
        Less("<", (d, d2) -> d < d2),
        Greater(">", (d, d2) -> d > d2),
        LessOrEqual("<=", (d, d2) -> d <= d2),
        GreaterOrEqual(">=", (d, d2) -> d >= d2);

        public final String symbol;
        public final DoubleComparer comparer;
        private static Comparison[] values;

        private Comparison(String string2, DoubleComparer doubleComparer) {
            this.symbol = string2;
            this.comparer = doubleComparer;
        }

        public static Comparison fromSymbol(String string) {
            for (Comparison comparison : values) {
                if (!comparison.symbol.equals(string)) continue;
                return comparison;
            }
            return null;
        }

        public boolean compare(double d, double d2) {
            return this.comparer.compare(d, d2);
        }

        public DoubleComparer getComparer() {
            return this.comparer;
        }

        static {
            values = Comparison.values();
        }
    }

    private static interface DoubleComparer {
        public boolean compare(double var1, double var3);
    }

    public static class PairProbabilityData {
        private int N;
        private double[] values;

        public PairProbabilityData(int n) {
            this.N = n;
            this.values = new double[n * (n - 1) / 2];
        }

        public double getPair(int n, int n2) {
            if (n > n2) {
                int n3 = n;
                n = n2;
                n2 = n3;
            }
            return this.values[(2 * this.N - n - 1) * n / 2 + n2 - n - 1];
        }

        public void setPair(int n, int n2, double d) {
            if (n > n2) {
                int n3 = n;
                n = n2;
                n2 = n3;
            }
            this.values[(2 * this.N - n - 1) * n / 2 + n2 - n - 1] = d;
        }

        public double getSingle(int n) {
            int n2;
            double d = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                d += this.getPair(n, n2);
            }
            for (n2 = this.N - 1; n2 > n; --n2) {
                d += this.getPair(n2, n);
            }
            return 1.0 - d;
        }
    }

    public static class NumberRangeList {
        public double[] limits;
        public Color[] colors;
        public Comparison comparison;
        public DoubleComparer cmp;
        public Color defaultColor;

        public NumberRangeList() {
        }

        public NumberRangeList(double[] dArray, Color[] colorArray, String string, Color color) {
            this(dArray, colorArray, Comparison.fromSymbol(string), color);
        }

        public NumberRangeList(double[] dArray, Color[] colorArray, Comparison comparison, Color color) {
            this.limits = dArray;
            this.colors = colorArray;
            this.comparison = comparison;
            this.cmp = this.comparison.getComparer();
            this.defaultColor = color;
        }

        public Color lookup(double d) {
            for (int i = 0; i < this.limits.length; ++i) {
                if (!this.cmp.compare(d, this.limits[i])) continue;
                return this.colors[i];
            }
            return this.defaultColor;
        }

        public void sortForComparison() {
            boolean bl = this.comparison == Comparison.Less | this.comparison == Comparison.LessOrEqual;
            for (int i = 1; i < this.limits.length; ++i) {
                double d = this.limits[i];
                Color color = this.colors[i];
                for (int j = i - 1; j >= 0 && bl == this.limits[j] > d; --j) {
                    this.limits[j + 1] = this.limits[j];
                    this.colors[j + 1] = this.colors[j];
                }
                this.limits[j + 1] = d;
                this.colors[j + 1] = color;
            }
        }
    }
}

