/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.services;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import ur_rna.StructureEditor.FileType;

public class RecentFileList
implements Iterable<RecentFile> {
    private int maxItemCount = 16;
    private LinkedList<RecentFile> list = new LinkedList();

    public List<RecentFile> getFiles() {
        return Collections.unmodifiableList(this.list);
    }

    public int getMaxItemCount() {
        return this.maxItemCount;
    }

    public void setMaxItemCount(int n) {
        this.maxItemCount = n;
    }

    public int size() {
        return this.list.size();
    }

    public void clear() {
        this.list.clear();
    }

    public void remove(RecentFile recentFile) {
        this.list.remove(recentFile);
    }

    public boolean contains(String string) {
        return this.indexOf(string) != -1;
    }

    public int indexOf(String string) {
        int n = 0;
        for (RecentFile recentFile : this.list) {
            if (string.equalsIgnoreCase(recentFile.path)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void remove(String string) {
        int n = this.indexOf(string);
        if (n != -1) {
            this.list.remove(n);
        }
    }

    public void add(String string) {
        this.add(string, null);
    }

    public void add(String string, FileType fileType) {
        this.remove(string);
        this.prepareAdd();
        this.list.addFirst(new RecentFile(string, fileType));
    }

    private void prepareAdd() {
        while (this.list.size() >= this.maxItemCount) {
            this.list.removeLast();
        }
    }

    public void addToBottom(String string, FileType fileType) {
        this.prepareAdd();
        this.list.addLast(new RecentFile(string, fileType));
    }

    public void load(Preferences preferences) {
        this.list.clear();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        try {
            String[] stringArray = preferences.keys();
            Arrays.sort(stringArray);
            for (Object object : stringArray) {
                linkedHashSet.add(preferences.get((String)object, null));
            }
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        for (String string : linkedHashSet) {
            int n = string.indexOf(9);
            if (n == -1) {
                this.list.addLast(new RecentFile(string, RecentFileList.parseFileType(null, string)));
                continue;
            }
            String string2 = string.substring(0, n);
            this.list.addLast(new RecentFile(string2, RecentFileList.parseFileType(string.substring(n + 1), string2)));
        }
    }

    public static FileType parseFileType(String string, String string2) {
        return FileType.fromAny(string, null, null, string2, null);
    }

    public void save(Preferences preferences) {
        int n = 0;
        try {
            preferences.clear();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        for (RecentFile recentFile : this.list) {
            if (n++ > this.maxItemCount) {
                return;
            }
            Object object = "00" + Integer.toString(n);
            if (((String)object).length() > 3) {
                object = ((String)object).substring(((String)object).length() - 3);
            }
            preferences.put((String)object, recentFile.path + "\t" + (recentFile.type == null ? "" : recentFile.type.name()));
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    @Override
    public Iterator<RecentFile> iterator() {
        return this.list.iterator();
    }

    @Override
    public void forEach(Consumer<? super RecentFile> consumer) {
        this.list.forEach(consumer);
    }

    @Override
    public Spliterator<RecentFile> spliterator() {
        return this.list.spliterator();
    }

    public static class RecentFile {
        public final String path;
        public final FileType type;

        public RecentFile(String string) {
            this(string, null);
        }

        public RecentFile(String string, FileType fileType) {
            this.path = string;
            this.type = fileType;
        }
    }
}

