/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.models;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import ur_rna.StructureEditor.models.Nuc;
import ur_rna.StructureEditor.models.RnaScene;
import ur_rna.StructureEditor.models.Strand;

public class StrandList
extends AbstractList<Strand> {
    private final RnaScene scene;
    private List<Nuc> nucs;
    private List<Nuc> readOnlyNucs;
    int size;
    Strand s1;
    Strand s2;
    List<Strand> others = null;
    static final int NO_REINDEX = Integer.MAX_VALUE;
    private int suppressUpdateCounter = 0;
    private int lowestUpdateNucIndex = Integer.MAX_VALUE;

    public List<Nuc> allNucs() {
        return this.readOnlyNucs;
    }

    public RnaScene getScene() {
        return this.scene;
    }

    public StrandList(RnaScene rnaScene, List<Nuc> list) {
        this.scene = rnaScene;
        this.nucs = list;
        this.readOnlyNucs = Collections.unmodifiableList(list);
        this.s1 = this.newStrand(0);
        this.size = 1;
    }

    private Strand newStrand(int n) {
        return this.newStrand(n, 0, 0);
    }

    private Strand newStrand(int n, int n2, int n3) {
        return new Strand(this.scene, this, n, this.nucs, n2, n3);
    }

    private UnsupportedOperationException noChangeError() {
        return new UnsupportedOperationException("Strands cannot be added or removed. Use the divide methods instead.");
    }

    @Override
    @Deprecated
    public boolean add(Strand strand) {
        throw this.noChangeError();
    }

    @Override
    @Deprecated
    public boolean remove(Object object) {
        throw this.noChangeError();
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends Strand> collection) {
        throw this.noChangeError();
    }

    @Override
    @Deprecated
    public boolean addAll(int n, Collection<? extends Strand> collection) {
        throw this.noChangeError();
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> collection) {
        throw this.noChangeError();
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> collection) {
        throw this.noChangeError();
    }

    @Override
    @Deprecated
    public void clear() {
        throw this.noChangeError();
    }

    @Override
    @Deprecated
    public Strand set(int n, Strand strand) {
        throw this.noChangeError();
    }

    @Override
    @Deprecated
    public void add(int n, Strand strand) {
        throw this.noChangeError();
    }

    @Override
    @Deprecated
    public Strand remove(int n) {
        throw this.noChangeError();
    }

    private void rangeCheck(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    private String outOfBoundsMsg(int n) {
        return "Invalid Strand index: " + n + (String)(this.size == 0 ? ". The list is empty." : ", Valid indices are 0 to " + (this.size - 1) + ".");
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object object) {
        return object != null && this.s1 == object || this.s2 == object || this.others != null && this.others.contains(object);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray;
        if (this.size == 1) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.s1;
        } else if (this.size == 2) {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = this.s1;
            objectArray = objectArray3;
            objectArray3[1] = this.s2;
        } else {
            objectArray = this.toArray(new Object[this.size]);
        }
        return objectArray;
    }

    @Override
    public Strand get(int n) {
        this.rangeCheck(n);
        return n == 0 ? this.s1 : (n == 1 ? this.s2 : this.others.get(n - 2));
    }

    @Override
    public int indexOf(Object object) {
        return object == null ? -1 : (object == this.s1 ? 0 : (object == this.s2 ? 1 : (this.others == null ? -1 : this.others.indexOf(object) + 2)));
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    public Strand first() {
        return this.s1;
    }

    public Strand second() {
        return this.s2;
    }

    public Strand last() {
        return this.size == 1 ? this.s1 : (this.size == 2 ? this.s2 : this.others.get(this.size - 3));
    }

    public Strand add() {
        return this.add(this.size);
    }

    public Strand add(int n) {
        int n2;
        Strand strand;
        if (n == 0) {
            if (this.size > 1) {
                this.others().add(0, this.s2);
            }
            this.s2 = this.s1;
            strand = this.s1 = this.newStrand(0);
        } else if (n == 1) {
            if (this.size > 1) {
                this.others().add(0, this.s2);
            }
            strand = this.s2 = this.newStrand(1, this.s1.size, 0);
        } else {
            n2 = this.get(n - 1).getEnd();
            strand = this.newStrand(n, n2, 0);
            this.others().add(n - 2, strand);
        }
        ++this.size;
        for (n2 = 0; n2 < this.size; ++n2) {
            this.get((int)n2).index = n2;
        }
        return strand;
    }

    public Strand removeDirect(int n) {
        Strand strand = this.get(n);
        if (n == 0) {
            if (this.size > 1) {
                this.s1 = this.s2;
            }
            this.s2 = this.size > 2 ? this.others.remove(0) : null;
        } else if (n == 1) {
            this.s2 = this.size > 2 ? this.others.remove(0) : null;
        } else {
            this.others().remove(n - 2);
        }
        --this.size;
        for (int i = 0; i < this.size; ++i) {
            this.get((int)i).index = i;
        }
        return strand;
    }

    private List<Strand> others() {
        if (this.others == null) {
            this.others = new ArrayList<Strand>(4);
        }
        return this.others;
    }

    public void divideStrand(Strand strand, int n) {
        int n2 = this.indexOf(strand);
        if (n2 == -1) {
            throw new IllegalArgumentException("Strand does not belong to this list.");
        }
        this.divideStrand(n2, n);
    }

    public void divideStrand(int n, int n2) {
        Strand strand = this.get(n);
        Strand strand2 = this.add(n + 1);
        strand2.offset = strand.offset + n2;
        strand2.setEnd(strand.getEnd());
        strand.setEnd(strand2.offset);
        this.reIndexNucs(strand2.offset);
    }

    public void joinStrands(Strand strand, Strand strand2) {
        int n = Math.abs(strand.index - strand2.index);
        int n2 = Math.min(strand.index, strand2.index);
        if (n == 0) {
            throw new IllegalArgumentException("Cannot join a strand to itself.");
        }
        if (n != 1) {
            throw new IllegalArgumentException("Only sequential strands can be joined.");
        }
        strand = this.get(n2);
        strand2 = this.get(n2 + 1);
        strand.size += strand2.size;
        strand2.size = 0;
        this.removeDirect(strand2.index);
        this.reIndexNucs(strand2.offset);
    }

    public void suspendUpdate() {
        ++this.suppressUpdateCounter;
    }

    public void resumeUpdate() {
        this.resumeUpdate(false);
    }

    public void resumeUpdate(boolean bl) {
        --this.suppressUpdateCounter;
        if (bl && this.suppressUpdateCounter == 0) {
            this.updateStrands(0);
        }
    }

    public void updateStrands(int n) {
        this.lowestUpdateNucIndex = Math.min(this.lowestUpdateNucIndex, n);
        if (this.suppressUpdateCounter != 0) {
            return;
        }
        int n2 = this.s1.size;
        if (this.size > 1) {
            this.s2.offset = n2;
            n2 += this.s2.size;
        }
        if (this.size > 2) {
            for (int i = 0; i < this.size - 2; ++i) {
                Strand strand = this.others.get(i);
                strand.offset = n2;
                n2 += strand.size;
            }
        }
        this.last().setEnd(this.nucs.size());
        this.reIndexNucs(Math.max(0, this.lowestUpdateNucIndex));
        this.lowestUpdateNucIndex = Integer.MAX_VALUE;
    }

    private void reIndexNucs(int n) {
        if (n >= this.nucs.size()) {
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            Strand strand = this.get(i);
            if (n < strand.size) {
                int n2;
                int n3 = n2 = n < 0 ? 0 : n;
                while (n2 < strand.size) {
                    Nuc nuc = strand.get(n2);
                    nuc.strand = strand;
                    nuc.indexInScene = strand.offset + n2;
                    ++n2;
                }
            }
            n -= strand.size;
        }
    }
}

