/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.models;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import ur_rna.StructureEditor.models.INucGroup;
import ur_rna.StructureEditor.models.Nuc;
import ur_rna.StructureEditor.models.RnaScene;
import ur_rna.StructureEditor.models.StrandList;
import ur_rna.Utilities.Strings;

public class Strand
extends AbstractList<Nuc>
implements INucGroup {
    private RnaScene scene;
    protected final StrandList owner;
    protected final List<Nuc> source;
    int index;
    int offset;
    int size;

    Strand(RnaScene rnaScene, StrandList strandList, int n, List<Nuc> list, int n2, int n3) {
        this.owner = strandList;
        this.index = n;
        this.source = list;
        this.offset = n2;
        this.size = n3;
        this.scene = rnaScene;
    }

    public RnaScene getScene() {
        return this.scene;
    }

    public int getSceneStart() {
        return this.offset;
    }

    public int getSceneEnd() {
        return this.offset + this.size;
    }

    public int strandToSceneIndex(int n) {
        return n + this.offset;
    }

    public int sceneToStrandIndex(int n) {
        return n - this.offset;
    }

    @Override
    public Collection<Nuc> getBases() {
        return this;
    }

    public Nuc getNext(Nuc nuc) {
        return this.getNext(nuc, 1);
    }

    public Nuc getPrev(Nuc nuc) {
        return this.getNext(nuc, -1);
    }

    public Nuc getNextInScene(Nuc nuc, int n, boolean bl) {
        int n2 = nuc.indexInScene + n;
        int n3 = this.source.size();
        if (n2 < 0 || n2 >= n3) {
            if (!bl) {
                return null;
            }
            if ((n2 %= n3) < 0) {
                n2 += n3;
            }
        }
        return this.source.get(n2);
    }

    public Nuc getNext(Nuc nuc, int n) {
        int n2 = nuc.indexInScene + n;
        return n2 >= this.offset && n2 < this.offset + this.size ? this.source.get(n2) : null;
    }

    public Nuc add(String string) {
        Nuc nuc = new Nuc(string);
        this.add(nuc);
        return nuc;
    }

    public Nuc add() {
        return this.add("");
    }

    public int getIndex() {
        return this.index;
    }

    int getEnd() {
        return this.offset + this.size;
    }

    void setEnd(int n) {
        this.size = n - this.offset;
    }

    public Nuc first() {
        return this.size == 0 ? null : this.source.get(this.offset);
    }

    public Nuc last() {
        return this.size == 0 ? null : this.source.get(this.offset + this.size - 1);
    }

    protected void rangeCheck(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    protected void rangeCheckForAdd(int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    protected String outOfBoundsMsg(int n) {
        return "Invalid Nucleotide index: " + n + ", Valid indices are " + this.offset + " to " + (this.offset + this.size - 1) + ".";
    }

    @Override
    public Nuc set(int n, Nuc nuc) {
        this.rangeCheck(n);
        return this.source.set(n + this.offset, nuc);
    }

    private UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException("This modification is not permitted on strands. Use the RnaScene or the StrandList to modify the nucleotides in a Strand.");
    }

    @Override
    public Nuc get(int n) {
        this.rangeCheck(n);
        return this.source.get(n + this.offset);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(int n, Nuc nuc) {
        this.rangeCheckForAdd(n);
        this.source.add(n + this.offset, nuc);
        nuc.indexInScene = this.offset + n;
        nuc.strand = this;
        ++this.size;
        this.owner.updateStrands(this.offset + n + 1);
    }

    @Override
    public Nuc remove(int n) {
        this.rangeCheck(n);
        Nuc nuc = this.source.remove(this.offset + n);
        --this.size;
        this.owner.updateStrands(this.offset + n);
        return nuc;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl;
        this.owner.suspendUpdate();
        try {
            bl = super.removeAll(collection);
        }
        finally {
            this.owner.resumeUpdate();
        }
        if (bl) {
            this.owner.updateStrands(Integer.MAX_VALUE);
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl;
        this.owner.suspendUpdate();
        try {
            bl = super.retainAll(collection);
        }
        finally {
            this.owner.resumeUpdate();
        }
        if (bl) {
            this.owner.updateStrands(Integer.MAX_VALUE);
        }
        return bl;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.owner.suspendUpdate();
        try {
            super.clear();
        }
        finally {
            this.owner.resumeUpdate();
        }
        this.owner.updateStrands(this.offset);
    }

    public List<Nuc> addPlaceholders(int n, int n2) {
        return this.addAll(n, Strings.fromChar('\u0000', n2));
    }

    public List<Nuc> addPlaceholders(int n) {
        return this.addPlaceholders(this.size, n);
    }

    public List<Nuc> addAll(CharSequence charSequence) {
        return this.addAll(this.size, charSequence);
    }

    public List<Nuc> addAll(int n, CharSequence charSequence) {
        Nuc[] nucArray = new Nuc[charSequence.length()];
        for (int i = 0; i < nucArray.length; ++i) {
            nucArray[i] = new Nuc(Character.toString(charSequence.charAt(i)));
        }
        List<Nuc> list = Arrays.asList(nucArray);
        this.addAll(n, (Collection<? extends Nuc>)list);
        return list;
    }

    @Override
    public boolean addAll(Collection<? extends Nuc> collection) {
        return this.addAll(this.size, collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int n, Collection<? extends Nuc> collection) {
        this.rangeCheckForAdd(n);
        int n2 = collection.size();
        if (n2 == 0) {
            return false;
        }
        this.owner.suspendUpdate();
        try {
            this.source.addAll(this.offset + n, collection);
        }
        finally {
            this.owner.resumeUpdate();
        }
        this.size += n2;
        this.owner.updateStrands(this.offset + n);
        return true;
    }

    @Override
    public Iterator<Nuc> iterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<Nuc> listIterator(final int n) {
        this.rangeCheckForAdd(n);
        return new ListIterator<Nuc>(){
            private int index;
            private int lastRet;
            {
                this.index = n;
                this.lastRet = -1;
            }

            @Override
            public boolean hasNext() {
                return this.index < Strand.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public Nuc next() {
                if (this.hasNext()) {
                    this.lastRet = Strand.this.offset + this.index++;
                    return Strand.this.source.get(this.lastRet);
                }
                throw new NoSuchElementException();
            }

            @Override
            public Nuc previous() {
                if (this.hasPrevious()) {
                    this.lastRet = Strand.this.offset + --this.index;
                    return Strand.this.source.get(this.lastRet);
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                if (this.lastRet == -1) {
                    throw new IllegalStateException();
                }
                Strand.this.remove(this.lastRet);
                if (this.lastRet < this.index) {
                    --this.index;
                }
                this.lastRet = -1;
            }

            @Override
            public void set(Nuc nuc) {
                if (this.lastRet == -1) {
                    throw new IllegalStateException();
                }
                Strand.this.set(this.lastRet, nuc);
            }

            @Override
            public void add(Nuc nuc) {
                Strand.this.add(this.index, nuc);
                this.lastRet = -1;
                ++this.index;
            }
        };
    }
}

