/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ur_rna.StructureEditor.models.Bond;
import ur_rna.StructureEditor.models.IMotif;
import ur_rna.StructureEditor.models.INucGroup;
import ur_rna.StructureEditor.models.Nuc;
import ur_rna.StructureEditor.models.RnaScene;
import ur_rna.StructureEditor.models.Strand;
import ur_rna.Utilities.ObjTools;
import ur_rna.Utilities.geom.Vec2D;

public abstract class Motif {
    public static boolean hasPseudoKnots(RnaScene rnaScene, boolean bl) {
        Bond bond;
        int n = rnaScene.getNucCount();
        Bond[] bondArray = new Bond[n];
        List<Bond> list = rnaScene.getBonds(!bl);
        Object object = list.iterator();
        while (object.hasNext()) {
            bondArray[bond.n5.indexInScene] = bond = object.next();
        }
        object = new IntervalStack(Math.min(8, n / 4));
        ((IntervalStack)object).push(0, n - 1);
        bond = null;
        while (((IntervalStack)object).pop()) {
            while (((IntervalStack)object).i <= ((IntervalStack)object).j && null == (bond = bondArray[((IntervalStack)object).i])) {
                ((IntervalStack)object).i = (short)(((IntervalStack)object).i + 1);
            }
            if (((IntervalStack)object).i > ((IntervalStack)object).j || bond == null) continue;
            int n2 = bond.n3.indexInScene;
            if (n2 > ((IntervalStack)object).j) {
                return true;
            }
            if (((IntervalStack)object).i + 1 <= n2 - 1) {
                ((IntervalStack)object).push(((IntervalStack)object).i + 1, n2 - 1);
            }
            if (n2 + 1 > ((IntervalStack)object).j) continue;
            ((IntervalStack)object).push(n2 + 1, ((IntervalStack)object).j);
        }
        return false;
    }

    public static Set<Bond> findPseudoKnots(RnaScene rnaScene) {
        HashSet<Bond> hashSet = new HashSet<Bond>();
        Motif.findNonCrossingBonds(rnaScene.getBonds(), hashSet);
        return hashSet;
    }

    public static Set<Bond> findNonCrossingBonds(RnaScene rnaScene) {
        return Motif.findNonCrossingBonds(rnaScene.getBonds());
    }

    public static Set<Bond> findNonCrossingBonds(Collection<Bond> collection) {
        return Motif.findNonCrossingBonds(collection, null);
    }

    public static Set<Bond> findNonCrossingBonds(Collection<Bond> collection, Collection<Bond> collection2) {
        Object object;
        Object object2;
        if (collection.size() == 0) {
            return Collections.emptySet();
        }
        int n = collection.iterator().next().getScene().getNucCount();
        Bond[] bondArray = new Bond[n];
        Object object3 = collection.iterator();
        while (object3.hasNext()) {
            bondArray[((Bond)object2).n5.indexInScene] = bondArray[((Bond)object2).n3.indexInScene] = (object2 = object3.next());
        }
        object3 = new short[n][n];
        object2 = new short[n][n];
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < n - i; ++j) {
                int n2;
                object = j + i;
                object3[j][object] = object3[j + 1][object];
                object2[j][object] = -1;
                if (bondArray[j] == null || bondArray[j].n5.indexInScene != j || (n2 = bondArray[j].n3.indexInScene) <= j || n2 > object) continue;
                int n3 = 1;
                if (j + 1 <= n2 - 1) {
                    n3 += object3[j + 1][n2 - 1];
                }
                if (n2 + 1 <= object) {
                    n3 += object3[n2 + 1][object];
                }
                if (n3 <= object3[j][object]) continue;
                object3[j][object] = (short)n3;
                object2[j][object] = (short)n2;
            }
        }
        HashSet<Bond> hashSet = new HashSet<Bond>(collection.size());
        IntervalStack intervalStack = new IntervalStack(Math.min(8, n / 4));
        intervalStack.push(0, n - 1);
        object = -1;
        while (intervalStack.pop()) {
            while (intervalStack.i < intervalStack.j) {
                Object object4 = object2[intervalStack.i][intervalStack.j];
                object = object4;
                if (-1 != object4) break;
                intervalStack.i = (short)(intervalStack.i + 1);
            }
            if (intervalStack.i >= intervalStack.j || object == -1) continue;
            hashSet.add(bondArray[object]);
            if (intervalStack.i + 1 < object - 1) {
                intervalStack.push(intervalStack.i + 1, object - 1);
            }
            if (object + 1 >= intervalStack.j) continue;
            intervalStack.push(object + 1, intervalStack.j);
        }
        if (collection2 != null && hashSet.size() < collection.size()) {
            for (Bond bond : collection) {
                if (hashSet.contains(bond)) continue;
                collection2.add(bond);
            }
        }
        return hashSet;
    }

    private static class IntervalStack {
        short[] stack;
        public short i;
        public short j;
        int pos;

        public IntervalStack() {
            this(10);
        }

        public IntervalStack(int n) {
            this.stack = new short[n * 2];
        }

        public void push(int n, int n2) {
            if (this.stack.length < this.pos + 2) {
                this.stack = Arrays.copyOf(this.stack, this.stack.length * 2);
            }
            this.stack[this.pos++] = (short)n;
            this.stack[this.pos++] = (short)n2;
        }

        public boolean pop() {
            if (this.pos == 0) {
                return false;
            }
            this.j = this.stack[--this.pos];
            this.i = this.stack[--this.pos];
            return true;
        }
    }

    public static class Segment
    implements INucGroup {
        public Nuc start;
        public Nuc end;

        public Segment() {
        }

        public Segment(Strand strand, int n, int n2) {
            this.start = strand.get(n);
            this.end = strand.get(n2);
        }

        public Segment(Nuc nuc, Nuc nuc2) {
            if (nuc.strand != nuc2.strand) {
                throw new IllegalArgumentException("The two nucleotides in a segment must both be from the same strand.");
            }
            this.start = nuc;
            this.end = nuc2;
        }

        public Segment(Nuc nuc, int n) {
            this(nuc, nuc.getNext(n - 1));
        }

        public void orderNucs() {
            if (this.start.indexInScene > this.end.indexInScene) {
                this.swapNucs();
            }
        }

        public void swapNucs() {
            Nuc nuc = this.start;
            this.start = this.end;
            this.end = nuc;
        }

        public int size() {
            return Math.abs(this.end.indexInScene - this.start.indexInScene) + 1;
        }

        public Nuc getNuc5() {
            return this.start.indexInScene <= this.end.indexInScene ? this.start : this.end;
        }

        public Nuc getNuc3() {
            return this.start.indexInScene <= this.end.indexInScene ? this.end : this.start;
        }

        public Nuc getNucAt(int n) {
            return this.getNuc5().getNext(n);
        }

        @Override
        public Collection<Nuc> getBases() {
            int n;
            int n2 = this.start.indexInStrand();
            if (n2 <= (n = this.end.indexInStrand())) {
                return this.start.getStrand().subList(n2, n + 1);
            }
            return this.start.getStrand().subList(n, n2 + 1);
        }
    }

    public static class Branch
    implements IMotif {
        private Helix base;
        private boolean isLowerBranch;

        public Branch() {
        }

        public Branch(Nuc nuc) {
            this.base = Helix.getHelix(nuc);
            if (this.base == null) {
                throw new IllegalArgumentException("A branch cannot be created from an unpaired nucleotide.");
            }
        }

        public Branch(Helix helix, boolean bl) {
            this.base = helix;
            this.isLowerBranch = bl;
        }

        public boolean isHybrid() {
            return this.base.isHybrid();
        }

        public boolean isParallel() {
            return this.base.isParallel();
        }

        public Helix getBaseHelix() {
            return this.base;
        }

        public void validate() {
        }

        @Override
        public Collection<Nuc> getBases() {
            if (this.isHybrid()) {
                Bond bond = this.base.getPair(0);
                Bond bond2 = this.base.getPair(this.base.pairCount - 1);
                Strand strand = bond.getNuc5().getStrand();
                Strand strand2 = bond.getNuc3().getStrand();
                List list = this.isLowerBranch ? strand.subList(0, bond2.getNuc5().indexInStrand() + 1) : strand.subList(bond.getNuc5().indexInStrand(), strand.size());
                List list2 = this.isLowerBranch == this.isParallel() ? strand2.subList(0, bond2.getNuc3().indexInStrand() + 1) : strand2.subList(bond.getNuc3().indexInStrand(), strand2.size());
                ArrayList<Nuc> arrayList = new ArrayList<Nuc>(list.size() + list2.size());
                arrayList.addAll(list);
                arrayList.addAll(list2);
                return arrayList;
            }
            Nuc nuc = this.base.getPair(0).getNuc5();
            return nuc.getStrand().subList(nuc.indexInStrand(), nuc.getPaired().indexInStrand() + 1);
        }

        public static Branch getBranch(Nuc nuc) {
            if (nuc.isPaired()) {
                return new Branch(nuc);
            }
            for (Nuc nuc2 = nuc.getPrev(); nuc2 != null; nuc2 = nuc2.getPrev()) {
                if (!nuc2.isPaired()) continue;
                Bond bond = nuc2.pair;
                if (bond.n5.indexInScene < nuc.indexInScene && bond.n3.indexInScene > nuc.indexInScene) {
                    return new Branch(nuc2);
                }
                nuc2 = nuc2.getPaired();
            }
            return null;
        }
    }

    public static class Domain
    extends Segment
    implements IMotif {
        public Domain() {
        }

        public Domain(Nuc nuc) {
            super(nuc, Domain.validatePair(nuc));
            this.orderNucs();
        }

        public Domain(Bond bond) {
            this(bond.getNuc5());
        }

        private static Nuc validatePair(Nuc nuc) {
            Nuc nuc2 = nuc.getPaired();
            if (nuc2 == null) {
                throw new IllegalArgumentException("A Domain can only be defined by a paired nucleotide.");
            }
            if (nuc2.strand != nuc.strand) {
                throw new IllegalArgumentException("A Domain can only be defined by two nucleotide on the same strand.");
            }
            return nuc2;
        }

        public static Domain getDomain(Nuc nuc) {
            Bond bond = nuc.getPairBond();
            if (bond == null || bond.getNuc5().strand != bond.getNuc3().strand) {
                return null;
            }
            return new Domain(bond);
        }
    }

    public static class MultiLoop
    implements IMotif {
        public final List<Object> elements = new ArrayList<Object>();
        private Bond[] branchBonds;
        private Loop[] loops;
        private int loopNucs;

        protected MultiLoop() {
        }

        public MultiLoop(Nuc nuc) {
            if (nuc.isPaired()) {
                throw new IllegalArgumentException("The nucleotide passed to a MultiLoop cannot be paired.");
            }
            List<Bond> list = Loop.getMultiBranchBasePairs(nuc, true);
            if (list == null) {
                return;
            }
            this.init(list, false);
        }

        public MultiLoop(List<Bond> list, boolean bl) {
            this.init(list, bl);
        }

        protected void init(List<Bond> list, boolean bl) {
            this.branchBonds = list.toArray(new Bond[list.size()]);
            if (!bl) {
                Arrays.sort(this.branchBonds);
            }
            int n = 0;
            for (int i = 0; i < this.branchBonds.length; ++i) {
                this.elements.add(this.branchBonds[i]);
                Object object = i == 0 ? this.branchBonds[i].n5 : this.branchBonds[i].n3;
                Loop loop = ((Nuc)object).nextInScene(1, true).getLoop();
                if (loop == null) continue;
                ++n;
                this.elements.add(loop);
                this.loopNucs += loop.size();
            }
            this.loops = new Loop[n];
            n = 0;
            for (Object object : this.elements) {
                if (!(object instanceof Loop)) continue;
                this.loops[n++] = (Loop)object;
            }
        }

        @Override
        public Collection<Nuc> getBases() {
            ArrayList<Nuc> arrayList = new ArrayList<Nuc>(this.nucCount());
            for (Object object : this.elements) {
                if (object instanceof Bond) {
                    arrayList.add(((Bond)object).n5);
                    arrayList.add(((Bond)object).n3);
                    continue;
                }
                if (!(object instanceof Loop)) continue;
                arrayList.addAll(((Loop)object).getBases());
            }
            return arrayList;
        }

        public List<Bond> getBonds() {
            return Arrays.asList(this.branchBonds);
        }

        public List<Loop> getLoops() {
            return Arrays.asList(this.loops);
        }

        public Nuc getN5() {
            return this.branchBonds[0].n5;
        }

        public Nuc getN3() {
            return this.branchBonds[0].n3;
        }

        public Bond getTrunk() {
            return this.branchBonds[0];
        }

        public static List<MultiLoop> findAll(RnaScene rnaScene, int n, boolean bl) {
            ArrayList<MultiLoop> arrayList = new ArrayList<MultiLoop>();
            List<Bond> list = Loop.getMultiBranchBasePairs(rnaScene.getNuc(0), true);
            for (Bond bond : list) {
                if (bl && list.size() >= n) {
                    arrayList.add(new MultiLoop(list, true));
                }
                MultiLoop.findAll(arrayList, bond.getHelix().lastPair(), n);
            }
            return arrayList;
        }

        protected static void findAll(List<MultiLoop> list, Bond bond, int n) {
            List<Bond> list2 = Loop.getMultiBranchBasePairs(bond.n5);
            if (list2.size() >= n) {
                list.add(new MultiLoop(list2, true));
            }
            for (int i = 1; i < list2.size(); ++i) {
                MultiLoop.findAll(list, list2.get(i).getHelix().lastPair(), n);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("MultiLoop @ ").append(this.getN5()).append("[").append(this.elements.size()).append("]");
            int n = 0;
            for (Object object : this.elements) {
                stringBuilder.append("  ").append(n++).append(":").append(object).append(";");
            }
            return stringBuilder.toString();
        }

        public static MultiLoop getFor(Nuc nuc, int n, boolean bl) {
            List<Bond> list = Loop.getMultiBranchBasePairs(nuc, bl);
            if (list == null || list.size() < n) {
                return null;
            }
            return new MultiLoop(list, false);
        }

        public int helixCount() {
            return this.branchBonds.length;
        }

        public int countLoops() {
            return this.loops.length;
        }

        public int loopNucCount() {
            return this.loopNucs;
        }

        public int nucCount() {
            return this.branchBonds.length * 2 + this.loopNucs;
        }
    }

    public static class Loop
    extends Segment
    implements IMotif {
        private LoopType type;

        public LoopType getType() {
            if (this.type == null) {
                this.type = Loop.calcLoopType(this);
            }
            return this.type;
        }

        public Loop() {
        }

        public Loop(Nuc nuc, Nuc nuc2) {
            super(nuc, nuc2);
        }

        public Loop(Nuc nuc, Nuc nuc2, LoopType loopType) {
            super(nuc, nuc2);
            this.type = loopType;
        }

        public static Loop getLoop(Nuc nuc) {
            Nuc nuc2;
            if (nuc.isPaired(false)) {
                return null;
            }
            Nuc nuc3 = nuc;
            Nuc nuc4 = nuc;
            while ((nuc2 = nuc4.getNext()) != null && !nuc2.isPaired(false)) {
                nuc4 = nuc2;
            }
            while ((nuc2 = nuc3.getPrev()) != null && !nuc2.isPaired(false)) {
                nuc3 = nuc2;
            }
            return new Loop(nuc3, nuc4);
        }

        public static List<Loop> findAll(RnaScene rnaScene) {
            ArrayList<Loop> arrayList = new ArrayList<Loop>();
            for (Strand strand : rnaScene.strands) {
                int n = -1;
                for (int i = 0; i < strand.size(); ++i) {
                    if (strand.get(i).isPaired(false)) {
                        if (n == -1) continue;
                        arrayList.add(new Loop(strand.get(n), strand.get(i - 1)));
                        n = -1;
                        continue;
                    }
                    if (n != -1) continue;
                    n = i;
                }
                if (n == -1) continue;
                arrayList.add(new Loop(strand.get(n), strand.get(strand.size() - 1)));
            }
            return arrayList;
        }

        public static List<Bond> getMultiBranchBasePairs(Nuc nuc, boolean bl, Bond.MultiLoopRole multiLoopRole) {
            Object object;
            ArrayList<Bond> arrayList = new ArrayList<Bond>();
            if (nuc.isPaired(false)) {
                object = nuc.pair.getMultiLoopRole(null);
                if (object == Bond.MultiLoopRole.Unknown) {
                    object = multiLoopRole;
                }
                switch (1.$SwitchMap$ur_rna$StructureEditor$models$Bond$MultiLoopRole[((Enum)object).ordinal()]) {
                    case 1: {
                        nuc = nuc.getPaired();
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        throw new IllegalArgumentException("The nucleotide passed to getMultiBranchBasePairs is internal to a helix -- not part of a branched loop.");
                    }
                    default: {
                        nuc = nuc.getPaired();
                    }
                }
            }
            object = nuc;
            do {
                if (!nuc.isPaired(false)) continue;
                if ((nuc = nuc.getPaired()) == object) {
                    return arrayList;
                }
                arrayList.add(nuc.getPairBond());
            } while ((nuc = nuc.getNext()) != null && nuc != object);
            return nuc == object || bl ? arrayList : null;
        }

        private static LoopType calcLoopType(Loop loop) {
            Nuc nuc = loop.getNuc5().getPrev();
            if (nuc == null) {
                return LoopType.Terminal;
            }
            Nuc nuc2 = loop.getNuc3();
            int n = 0;
            while (nuc2 != null) {
                Nuc nuc3 = nuc2.getPaired(false);
                if (nuc3 == null) {
                    nuc2 = nuc2.getNext();
                    continue;
                }
                if (nuc3.equals(nuc)) {
                    return n == 0 ? LoopType.Hairpin : (n == 1 ? LoopType.Internal : LoopType.Multibranch);
                }
                ++n;
                nuc2 = nuc3.getNext();
            }
            return n == 0 ? LoopType.Terminal : LoopType.Exterior;
        }

        public static List<Bond> getMultiBranchBasePairs(Nuc nuc) {
            return Loop.getMultiBranchBasePairs(nuc, false, Bond.MultiLoopRole.Entrance);
        }

        public static List<Bond> getMultiBranchBasePairs(Nuc nuc, boolean bl) {
            return Loop.getMultiBranchBasePairs(nuc, bl, Bond.MultiLoopRole.Entrance);
        }

        public String toString() {
            return (String)(this.type == null ? "Loop " : this.type + " Loop ") + this.getNuc5() + ":" + this.getNuc3();
        }

        public static enum LoopType {
            Hairpin,
            Internal,
            Multibranch,
            Pseudo,
            Exterior,
            Terminal;

        }
    }

    public static class Helix
    implements IMotif {
        Nuc nuc5;
        int pairCount;

        public RnaScene getScene() {
            return this.nuc5.getScene();
        }

        protected Helix(Nuc nuc, int n) {
            this.nuc5 = nuc;
            this.pairCount = n;
        }

        public int size() {
            return this.pairCount;
        }

        public Bond getPair(int n) {
            if (n < 0 || n >= this.pairCount) {
                throw new IndexOutOfBoundsException();
            }
            return this.nuc5.getNext(n).getPairBond();
        }

        public Bond first() {
            return this.getPair(0);
        }

        public Bond last() {
            return this.getPair(this.pairCount - 1);
        }

        public boolean isClockwise() {
            Vec2D vec2D = new Vec2D(this.first().midpoint(), this.last().midpoint());
            return this.first().normal().dot(vec2D) < 0.0;
        }

        public boolean isHybrid() {
            return this.getPair(0).isHybrid();
        }

        @Override
        public Collection<Nuc> getBases() {
            ArrayList<Nuc> arrayList = new ArrayList<Nuc>(this.pairCount * 2);
            for (int i = 0; i < this.pairCount; ++i) {
                Bond bond = this.getPair(i);
                arrayList.add(bond.getNuc5());
                arrayList.add(bond.getNuc3());
            }
            return arrayList;
        }

        public static List<Helix> findAll(RnaScene rnaScene) {
            ArrayList<Helix> arrayList = new ArrayList<Helix>();
            Bond bond = null;
            Bond bond2 = null;
            ObjTools.RefInt refInt = new ObjTools.RefInt();
            for (Bond bond3 : rnaScene.getBonds(false)) {
                if (bond != null && Helix.bondIsNextInHelix(bond2, bond3, refInt)) {
                    bond2 = bond3;
                    continue;
                }
                if (bond2 != bond) {
                    arrayList.add(new Helix(bond.n5, bond2.n5.indexInScene - bond.n5.indexInScene + 1));
                }
                bond2 = bond = bond3;
                refInt.value = 0;
            }
            if (bond2 != bond) {
                arrayList.add(new Helix(bond.n5, bond2.n5.indexInScene - bond.n5.indexInScene + 1));
            }
            return arrayList;
        }

        protected static boolean isHelixBond(Bond bond) {
            return bond != null && bond.isTruePair();
        }

        public static Helix getHelix(Nuc nuc) {
            Nuc nuc2;
            Nuc nuc3;
            if (!Helix.isHelixBond(nuc.pair)) {
                return null;
            }
            ObjTools.RefInt refInt = new ObjTools.RefInt();
            Nuc nuc4 = nuc3 = nuc.pair.getNuc5();
            while ((nuc2 = nuc3.getPrev()) != null && Helix.isHelixBond(nuc2.pair) && Helix.bondIsNextInHelix(nuc2.pair, nuc3.pair, refInt)) {
                nuc3 = nuc2;
            }
            while ((nuc2 = nuc4.getNext()) != null && Helix.isHelixBond(nuc2.pair) && Helix.bondIsNextInHelix(nuc4.pair, nuc2.pair, refInt)) {
                nuc4 = nuc2;
            }
            return new Helix(nuc3, nuc4.indexInScene - nuc3.indexInScene + 1);
        }

        private static boolean bondIsNextInHelix(Bond bond, Bond bond2, ObjTools.RefInt refInt) {
            if (bond2.n5.strand != bond.n5.strand || bond2.n3.strand != bond.n3.strand) {
                return false;
            }
            if (bond.n5.getNext() != bond2.n5) {
                return false;
            }
            int n = bond2.n3.indexInScene - bond.n3.indexInScene;
            if (refInt.value == 0 && (n == 1 || n == -1)) {
                refInt.value = n;
            }
            return n == refInt.value;
        }

        public boolean isParallel() {
            if (this.pairCount == 1) {
                return false;
            }
            Bond bond = this.getPair(0);
            Bond bond2 = this.getPair(1);
            return bond.n5.indexInScene - bond2.n5.indexInScene == bond.n3.indexInScene - bond2.n3.indexInScene;
        }

        public Bond lastPair() {
            return this.getPair(this.pairCount - 1);
        }
    }
}

