/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.models;

import java.util.HashMap;
import java.util.Map;

public enum BondType {
    Standard("BP", "Standard Basepair"),
    Forced("CF", "Forced Pair (Constraint)"),
    Prohibited("CP", "Prohibited Pair (Constraint)"),
    Special("NC", "Non-Canonical/Special Bond"),
    Pseudo("PK", "Pseudo-Knot Bond");

    public static final BondType Default;
    private final String description;
    private String abbrev;
    private static Map<String, BondType> _lookup;

    private BondType(String string2, String string3) {
        this.abbrev = string2;
        this.description = string3;
    }

    public String getAbbrev() {
        return this.abbrev;
    }

    public static BondType fromAbbrev(String string) {
        BondType bondType = BondType.fromAbbrev(string, null);
        if (bondType == null) {
            throw new IllegalArgumentException("Invalid BondType abbreviation: " + string + ".");
        }
        return bondType;
    }

    public static BondType fromAbbrev(String string, BondType bondType) {
        if (string == null || string.isEmpty()) {
            return bondType;
        }
        if (_lookup == null) {
            _lookup = new HashMap<String, BondType>();
            for (BondType bondType2 : BondType.values()) {
                _lookup.put(bondType2.abbrev, bondType2);
            }
        }
        return _lookup.getOrDefault(string, bondType);
    }

    public String getDescription() {
        return this.description;
    }

    static {
        Default = Standard;
    }
}

