/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.menus;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import ur_rna.StructureEditor.menus.MainMenu;
import ur_rna.Utilities.swing.AcceleratorKey;
import ur_rna.Utilities.swing.MergeItem;
import ur_rna.Utilities.swing.UiAction;

public class WindowsMenu
extends MainMenu {
    UiAction nextWindow = new UiAction("Switch to Next Window", () -> this.gotoNext(1)).setKeyStroke("*TAB");
    UiAction prevWindow = new UiAction("Switch to Previous Window", () -> this.gotoNext(-1)).setKeyStroke("*+TAB");
    private final JDesktopPane desktop;
    private final JPopupMenu popup;
    private final Predicate<JInternalFrame> windowFilter;
    private final JMenuItem noWindowsItem;

    public static void enableTabNext(JComponent jComponent) {
        AcceleratorKey.removeTabTraversalKeys(jComponent, AWTKeyStroke.getAWTKeyStroke(9, 128), AWTKeyStroke.getAWTKeyStroke(9, 192));
    }

    public WindowsMenu(JDesktopPane jDesktopPane, Predicate<JInternalFrame> predicate) {
        super("&Windows");
        this.desktop = jDesktopPane;
        this.windowFilter = predicate;
        this.popup = this.getPopupMenu();
        this.noWindowsItem = new MergeItem("(No windows are currently open.)");
        this.noWindowsItem.setEnabled(false);
        this.addSeparator(10);
        this.add(this.nextWindow, 10);
        this.add(this.prevWindow, 10);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                WindowsMenu.this.updateWindowList();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    private void removeWindowItems() {
        for (int i = this.popup.getComponentCount() - 1; i >= 0; --i) {
            if (!(this.popup.getComponent(i) instanceof WindowItem)) continue;
            this.popup.remove(i);
        }
    }

    private void updateWindowList() {
        this.removeWindowItems();
        int n = 0;
        for (JInternalFrame jInternalFrame : this.desktop.getAllFrames()) {
            if (!this.windowFilter.test(jInternalFrame)) continue;
            this.popup.add((Component)this.createWindowItem(jInternalFrame), n++);
        }
        if (n == 0) {
            this.popup.add((Component)this.noWindowsItem, 0);
        } else {
            this.popup.remove(this.noWindowsItem);
        }
        this.nextWindow.setEnabled(n > 1);
        this.prevWindow.setEnabled(n > 1);
    }

    public WindowItem createWindowItem(JInternalFrame jInternalFrame) {
        WindowItem windowItem = new WindowItem(jInternalFrame);
        windowItem.addActionListener(this::windowItem_click);
        return windowItem;
    }

    private void windowItem_click(ActionEvent actionEvent) {
        WindowItem windowItem = (WindowItem)actionEvent.getSource();
        windowItem.window.toFront();
    }

    void gotoNext(int n) {
        JInternalFrame[] jInternalFrameArray = this.desktop.getAllFrames();
        ArrayList<JInternalFrame> arrayList = new ArrayList<JInternalFrame>(jInternalFrameArray.length);
        for (JInternalFrame jInternalFrame : jInternalFrameArray) {
            if (!this.windowFilter.test(jInternalFrame)) continue;
            arrayList.add(jInternalFrame);
        }
        if (arrayList.size() < 2) {
            return;
        }
        int n2 = arrayList.indexOf(this.desktop.getSelectedFrame());
        n2 = n2 == -1 ? 0 : (n2 + n) % arrayList.size();
        if (n2 < 0) {
            n2 += arrayList.size();
        }
        JInternalFrame jInternalFrame = (JInternalFrame)arrayList.get(n2);
        jInternalFrame.toFront();
        this.desktop.setSelectedFrame(jInternalFrame);
        SwingUtilities.invokeLater(() -> {
            if (this.desktop.getSelectedFrame() == jInternalFrame) {
                try {
                    jInternalFrame.revalidate();
                    this.desktop.revalidate();
                    jInternalFrame.repaint();
                    this.desktop.repaint();
                    jInternalFrame.updateUI();
                    this.desktop.updateUI();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    private static class WindowItem
    extends MergeItem {
        public final JInternalFrame window;

        public WindowItem(JInternalFrame jInternalFrame) {
            this.window = jInternalFrame;
            this.setText(jInternalFrame.getTitle());
        }
    }
}

