/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.menus;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import ur_rna.StructureEditor.Program;
import ur_rna.StructureEditor.Settings;
import ur_rna.StructureEditor.menus.MainMenu;
import ur_rna.StructureEditor.services.RnaDrawController;
import ur_rna.Utilities.ObjTools;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.swing.AcceleratorKey;
import ur_rna.Utilities.swing.CheckMergeItem;
import ur_rna.Utilities.swing.Menus;
import ur_rna.Utilities.swing.MergeMenu;
import ur_rna.Utilities.swing.UiAction;

public class SettingsMenu
extends MainMenu {
    private Settings settings = Program.getInstance().settings();
    private boolean updatingSettings;

    public SettingsMenu() {
        super("&Settings");
        this.addCheck("Enable &Dashboard", "ShowDashboard", "Show the Dashboard (aka Start-Up Screen) when no other files are loaded.");
        this.addCheck("Draw Structures Clock&wise", "DrawClockwise", "<html>When (re)drawing the structure, it can be drawn either clockwise or counter-clockwise.<br>This setting only has an effect when you click <b>\"Redraw\"</b>.");
        this.addCheck("Show Visual Queues", "ShowHints", "Show temporary visual guides (lines, arcs, etc) while dragging nucleotides during rotations, loop resizing, etc.");
        this.addCheck("Enable \"Sticky\" Positions", "SnapGuides", "<html>When dragging dragging nucleotides (during rotations, loop resizing, etc.) the mouse will <i>\"stick\"</i> or <i>\"snap\"</i> to special angles or positions.<br>(This can be temporarily disabled by holding down the <b>" + AcceleratorKey.getModifierKeyName(RnaDrawController.DRAG_SPECIAL_MASK) + "</b> Key.");
        this.addCheck("Resize MultiLoops by Default", "ExpandMotif", "<html>Usually only one loop segment is affected when resizing loops. But if this setting is enabled, the full loop circuit is expanded.<br>Hold down the <b>" + AcceleratorKey.getModifierKeyName(RnaDrawController.DRAG_EXPANDED_MOTIF_MASK) + "</b> Key to temporarily toggle this setting.");
        MergeMenu mergeMenu = new MergeMenu("Disable Layout Tools (aka \"Drag Handles\")");
        mergeMenu.addCheck(new UiAction("Disable Free &Rotation (and the Center-of_Rotation cross-hair", this::checkSettingChanged).setDesc("Check this setting if the free-rotation feature is distracting or in the way (i.e. the center-of-rotation cross-hair icon or rotation icon).").setCommand("DisableRotation"));
        mergeMenu.addCheck(new UiAction("Disable &Loop Resizing", this::checkSettingChanged).setCommand("DisableLoopResize"));
        mergeMenu.addCheck(new UiAction("Disable &Branch Sliding", this::checkSettingChanged).setCommand("DisableBranchSlide"));
        mergeMenu.addSeparator();
        mergeMenu.add(new UiAction("Enable &All", actionEvent -> this.checkAll(mergeMenu, false)));
        mergeMenu.add(new UiAction("&Disable All", actionEvent -> this.checkAll(mergeMenu, true)));
        this.add(mergeMenu);
        this.settings.addChangeHandler(this::settingsChanged);
        this.loadSettings();
    }

    private void checkAll(Container container, boolean bl) {
        for (Component component : Menus.getMenuItems(container)) {
            if (!(component instanceof AbstractButton)) continue;
            ((AbstractButton)component).setSelected(bl);
        }
        this.saveSettings();
    }

    private CheckMergeItem addCheck(String string, String string2, String string3) {
        CheckMergeItem checkMergeItem = new CheckMergeItem(string, this::checkSettingChanged, string2);
        checkMergeItem.setToolTipText(string3);
        this.add(checkMergeItem);
        return checkMergeItem;
    }

    private void settingsChanged() {
        this.updatingSettings = true;
        this.loadSettings();
        this.updatingSettings = false;
    }

    private void loadSettings() {
        this.loadSettings(this);
    }

    private void loadSettings(Component component) {
        for (JMenuItem jMenuItem : Menus.getMenuItems(component)) {
            if (jMenuItem instanceof JCheckBoxMenuItem && !Strings.isEmpty(jMenuItem.getActionCommand())) {
                jMenuItem.setSelected(this.getBoolSetting(jMenuItem.getActionCommand()));
            }
            if (!(jMenuItem instanceof JMenu)) continue;
            this.loadSettings(jMenuItem);
        }
    }

    private void saveSettings() {
        this.settings.suspendChangeNotification();
        try {
            this.saveSettings(this);
        }
        finally {
            this.settings.resumeChangeNotification();
        }
    }

    private void saveSettings(Component component) {
        for (JMenuItem jMenuItem : Menus.getMenuItems(component)) {
            if (jMenuItem instanceof JCheckBoxMenuItem) {
                String string = jMenuItem.getActionCommand();
                if (Strings.isEmpty(string)) continue;
                this.settings.set(string, (Object)jMenuItem.isSelected());
                continue;
            }
            if (!(jMenuItem instanceof JMenu)) continue;
            this.saveSettings(jMenuItem);
        }
    }

    private boolean getBoolSetting(String string) {
        return ObjTools.asBool(this.settings.get(string));
    }

    private void checkSettingChanged(ActionEvent actionEvent) {
        if (this.updatingSettings) {
            return;
        }
        String string = actionEvent.getActionCommand();
        boolean bl = ((AbstractButton)actionEvent.getSource()).isSelected();
        this.settings.set(string, (Object)bl);
    }
}

