/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor;

import java.lang.reflect.Field;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import ur_rna.StructureEditor.models.DrawSettings;
import ur_rna.Utilities.AppLog;
import ur_rna.Utilities.Convert;
import ur_rna.Utilities.EventSource;
import ur_rna.Utilities.ObjTools;

public class Settings {
    private static final String nullValue = "{~NULL}";
    public static final Object Missing = new Object();
    public boolean ShowDashboard = true;
    public boolean DrawClockwise = false;
    public boolean ShowHints = true;
    public boolean SnapGuides = true;
    public boolean ExpandMotif = false;
    public boolean DisableRotation = false;
    public boolean DisableLoopResize = false;
    public boolean DisableBranchSlide = false;
    private final EventSource.NoArg _changeEvent = new EventSource.NoArg();
    private static final Field[] fields;
    private DrawSettings drawSettings = new DrawSettings();
    private boolean suspendChanges;
    private boolean settingsWereChanged;

    public void addChangeHandler(Runnable runnable) {
        this._changeEvent.add(runnable);
    }

    public void removeChangeHandler(Runnable runnable) {
        this._changeEvent.remove(runnable);
    }

    public void notifyChanged() {
        this._changeEvent.invoke();
    }

    public Object get(String string) {
        Field field = this.getSettingsField(string);
        if (field != null) {
            return this.get(field);
        }
        this.logError("Error retrieving program setting: Invalid setting name: \"%s\".", string);
        return Missing;
    }

    public Object get(Field field) {
        try {
            if (field.getDeclaringClass() == Settings.class) {
                return field.get(this);
            }
            if (field.getDeclaringClass() == DrawSettings.class) {
                return field.get(this.drawSettings);
            }
            throw new IllegalAccessException("Unknown Declaring Class");
        }
        catch (Exception exception) {
            this.logError("Error retrieving program setting '%s': %s", field.getName(), exception.getMessage());
            return Missing;
        }
    }

    public void set(String string, Object object) {
        Field field = this.getSettingsField(string);
        if (field == null) {
            this.logError("Error updating program setting: Invalid setting name: \"%s\".", string);
        } else {
            this.set(field, object);
        }
    }

    private void set(Field field, Object object) {
        try {
            object = Convert.toType(object, field.getType());
            if (field.getDeclaringClass() == Settings.class) {
                field.set(this, object);
            } else if (field.getDeclaringClass() == DrawSettings.class) {
                field.set(this.drawSettings, object);
            } else {
                throw new IllegalAccessException("Unknown Declaring Class");
            }
            if (this.suspendChanges) {
                this.settingsWereChanged = true;
            } else {
                this.notifyChanged();
            }
        }
        catch (Exception exception) {
            this.logError("Error loading setting '%s':  to value '%s': %s", field.getName(), object, exception.getMessage());
        }
    }

    private void logError(String string, Object ... objectArray) {
        AppLog.getDefault().error(string, objectArray);
    }

    private Field getSettingsField(String string) {
        for (Field field : fields) {
            if (field == null) break;
            if (!field.getName().equals(string)) continue;
            return field;
        }
        return null;
    }

    public void load(Preferences preferences) {
        String[] stringArray = ObjTools.EMPTY_STRING_ARRAY;
        this.suspendChanges = true;
        try {
            stringArray = preferences.keys();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        for (Field field : fields) {
            String string;
            if (field == null) break;
            if (!ObjTools.contains(stringArray, field.getName()) || (string = preferences.get(field.getName(), null)) == null) continue;
            this.set(field, (Object)(nullValue.equals(string) ? null : string));
        }
        this.suspendChanges = false;
    }

    public void save(Preferences preferences) {
        try {
            preferences.clear();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        for (Field field : fields) {
            if (field == null) break;
            try {
                Object object = this.get(field);
                if (object == Missing) continue;
                preferences.put(field.getName(), Convert.toString(object, nullValue));
            }
            catch (Exception exception) {
                System.out.println(String.format("Error saving setting '%s': %s", field.getName(), exception.getMessage()));
            }
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    public void suspendChangeNotification() {
        this.suspendChanges = true;
    }

    public void resumeChangeNotification() {
        this.suspendChanges = false;
        if (this.settingsWereChanged) {
            this.settingsWereChanged = false;
            this.notifyChanged();
        }
    }

    public DrawSettings getDrawSettings() {
        return this.drawSettings.copy();
    }

    static {
        Field[] fieldArray = Settings.class.getFields();
        Field[] fieldArray2 = DrawSettings.class.getFields();
        fields = new Field[fieldArray.length + fieldArray2.length];
        int n = 0;
        for (Field field : fieldArray) {
            if ((field.getModifiers() & 0x80) != 0) continue;
            Settings.fields[n++] = field;
        }
    }
}

