/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.InternalFrameEvent;
import ur_rna.StructureEditor.AppActions;
import ur_rna.StructureEditor.FileType;
import ur_rna.StructureEditor.Program;
import ur_rna.StructureEditor.Settings;
import ur_rna.StructureEditor.menus.FileMenu;
import ur_rna.StructureEditor.menus.SettingsMenu;
import ur_rna.StructureEditor.menus.WindowsMenu;
import ur_rna.StructureEditor.services.RecentFileList;
import ur_rna.StructureEditor.services.RecentFileMenuManager;
import ur_rna.StructureEditor.ui.SliderToolWindow;
import ur_rna.StructureEditor.windows.ChildFrame;
import ur_rna.StructureEditor.windows.DashboardFrame;
import ur_rna.StructureEditor.windows.DrawWindow;
import ur_rna.Utilities.AppLog;
import ur_rna.Utilities.OSInfo;
import ur_rna.Utilities.ObjTools;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.swing.AcceleratorKey;
import ur_rna.Utilities.swing.Components;
import ur_rna.Utilities.swing.MdiChildFrame;
import ur_rna.Utilities.swing.MdiParentFrame;
import ur_rna.Utilities.swing.MergeButton;
import ur_rna.Utilities.swing.MergeManager;
import ur_rna.Utilities.swing.MergeMenu;
import ur_rna.Utilities.swing.UiAction;

public class MainFrame
extends MdiParentFrame {
    private AppLog log = AppLog.getDefault();
    private final JMenuBar menuBar;
    private final JToolBar toolBar;
    private final JPanel statusBar;
    private final JLabel infoLabel;
    public final JDesktopPane desktop;
    private final Program program;
    private RecentFileList recentFiles;
    private RecentFileMenuManager recentFilesMenu;
    private DashboardFrame dashboard;
    private MergeManager menuMerger = new MergeManager();
    public static final int FileMenuSection = -100;
    public static final int EditMenuSection = -80;
    public static final int ViewMenuSection = -40;
    public static final int FormatMenuSection = -20;
    public static final int SettingsMenuSection = 900;
    public static final int WindowsMenuSection = 910;
    public static final int HelpMenuSection = 1000;
    private Timer testIconsTimer = new Timer(1000, actionEvent -> this.testIcons());
    private Component[] originalToolbar;

    public MainFrame() {
        super("Structure Editor");
        this.program = Program.getInstance();
        this.setLayout(new BorderLayout());
        this.desktop = this.buildDesktop();
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.createMainMenus();
        this.toolBar = this.buildToolBar();
        this.createMainToolButtons();
        this.program.settings().addChangeHandler(this::settingsChanged);
        this.recentFiles = new RecentFileList();
        this.dashboard = new DashboardFrame();
        this.add((Component)this.toolBar, "First");
        this.add((Component)this.desktop, "Center");
        this.infoLabel = this.buildInfoLabel();
        this.statusBar = this.buildStatusBar(this.infoLabel);
        this.resetInfoLabel();
        this.updateActiveFrameInfo();
        this.setDefaultCloseOperation(3);
        this.setSize(1024, 730);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.loadRecentFiles();
        this.addMainActions();
        AcceleratorKey.resetTabTraversalKeys(this.desktop);
    }

    private void settingsChanged() {
        Settings settings = this.program.settings();
        if (!settings.ShowDashboard && this.dashboard.isVisible()) {
            this.hideDashboard();
        } else if (settings.ShowDashboard && this.getChildFrames().size() == 0) {
            this.showDashboard(false);
        }
        for (ChildFrame childFrame : this.getChildFrames()) {
            childFrame.programSettingsUpdated();
        }
    }

    private void addMainActions() {
        this.addAction("show-rotate", actionEvent -> new SliderToolWindow().show());
    }

    private Preferences getRecentFilesNode() {
        return this.program.prefs().user().node("RecentFiles");
    }

    private void loadRecentFiles() {
        this.recentFiles.load(this.getRecentFilesNode());
        this.updateRecentFilesUI();
    }

    public void addRecentFile(String string, FileType fileType) {
        this.recentFiles.add(string, fileType);
        this.recentFiles.save(this.getRecentFilesNode());
        this.updateRecentFilesUI();
    }

    private void updateRecentFilesUI() {
        this.dashboard.setRecent(this.recentFiles);
        this.recentFilesMenu.setRecent(this.recentFiles);
        this.menuMerger.clearCache(this.recentFilesMenu.getComponent());
        this.menuMerger.sort(this.recentFilesMenu.getComponent());
    }

    public void cleanRecent(boolean bl) {
        if (bl) {
            this.recentFiles.clear();
        } else {
            for (RecentFileList.RecentFile recentFile : this.recentFiles.getFiles().toArray(new RecentFileList.RecentFile[this.recentFiles.size()])) {
                if (new File(recentFile.path).exists()) continue;
                this.recentFiles.remove(recentFile);
            }
        }
        this.recentFiles.save(this.getRecentFilesNode());
        this.updateRecentFilesUI();
    }

    private JDesktopPane buildDesktop() {
        JDesktopPane jDesktopPane = new JDesktopPane();
        jDesktopPane.setBackground(Color.GRAY);
        jDesktopPane.removeAll();
        return jDesktopPane;
    }

    private JPanel buildStatusBar(JLabel jLabel) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(new BevelBorder(1));
        jPanel.add((Component)jLabel, "South");
        this.add((Component)jPanel, "South");
        return jPanel;
    }

    private void createMainMenus() {
        FileMenu fileMenu = new FileMenu();
        SettingsMenu settingsMenu = new SettingsMenu();
        WindowsMenu windowsMenu = new WindowsMenu(this.desktop, this::windowMenuFilter);
        MergeMenu mergeMenu = new MergeMenu("&Edit");
        MergeMenu mergeMenu2 = new MergeMenu("&Help");
        this.addMainMenu(fileMenu, -100);
        this.addMainMenu(mergeMenu, -80);
        this.addMainMenu(settingsMenu, 900);
        this.addMainMenu(windowsMenu, 910);
        this.addMainMenu(mergeMenu2, 1000);
        if (Strings.asBool(System.getProperty("debug"))) {
            fileMenu.add(new UiAction("Test Icons", actionEvent -> {
                if (this.testIconsTimer.isRunning()) {
                    this.testIconsTimer.stop();
                } else {
                    this.testIconsTimer.start();
                }
            }).setKeyStroke("*I"));
        }
        mergeMenu2.add(AppActions.SHOW_LOCAL_HELP);
        mergeMenu2.add(AppActions.SHOW_ONLINE_HELP);
        mergeMenu2.add(AppActions.OPEN_WEBSITE);
        mergeMenu2.addSeparator();
        mergeMenu2.add(AppActions.SEND_FEEDBACK);
        mergeMenu2.addSeparator();
        mergeMenu2.add(AppActions.SHOW_ABOUT_WINDOW);
        this.recentFilesMenu = new RecentFileMenuManager(fileMenu.recentFilesMenu());
    }

    private boolean windowMenuFilter(JInternalFrame jInternalFrame) {
        return jInternalFrame != this.dashboard;
    }

    private void addMainMenu(MergeMenu mergeMenu, int n) {
        this.menuBar.add(mergeMenu);
        mergeMenu.setMergePos(n);
    }

    private JLabel buildInfoLabel() {
        final JLabel jLabel = new JLabel("Structure Editor");
        jLabel.setFont(new Font(jLabel.getFont().getFontName(), 0, 16));
        jLabel.setHorizontalAlignment(2);
        jLabel.setSize(jLabel.getPreferredSize());
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (0 != (mouseEvent.getModifiers() & 1)) {
                    StringSelection stringSelection = new StringSelection(jLabel.getText());
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
                }
            }
        });
        return jLabel;
    }

    private void testIcons() {
        this.toolBar.removeAll();
        File file = new File("E:\\home\\jobs\\RNA\\RNAstructure\\alignment-editor\\src\\ur_rna\\StructureEditor\\resources\\images");
        for (File file2 : file.listFiles()) {
            String string = file2.getName();
            if (!string.endsWith(".png")) continue;
            try {
                ImageIcon imageIcon = new ImageIcon(ImageIO.read(file2));
                String string2 = string + Strings.fmt(" %sx%s", imageIcon.getIconWidth(), imageIcon.getIconHeight());
                System.out.println(string2);
                if (imageIcon.getIconHeight() > 32 || imageIcon.getIconWidth() > 32) continue;
                JButton jButton = new JButton(imageIcon);
                jButton.setToolTipText(string2);
                this.toolBar.add(jButton);
            }
            catch (Exception exception) {
                System.err.println("Error with " + string);
                exception.printStackTrace();
            }
        }
        this.toolBar.add(new JButton("T" + System.currentTimeMillis()));
        this.toolBar.revalidate();
        this.toolBar.repaint();
    }

    private JToolBar buildToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(true);
        return jToolBar;
    }

    private void createMainToolButtons() {
        this.addToolButton(AppActions.SHOW_OPEN_FILE, -100);
        this.addToolButton(AppActions.SHOW_DASHBOARD, -100);
    }

    private MergeButton addToolButton(Action action, int n) {
        MergeButton mergeButton = new MergeButton(action, n);
        mergeButton.setMnemonic(0);
        return (MergeButton)this.toolBar.add(mergeButton);
    }

    private void copyAction(AbstractButton abstractButton, AbstractButton abstractButton2) {
        abstractButton2.setActionCommand(abstractButton.getActionCommand());
        for (ActionListener actionListener : abstractButton.getActionListeners()) {
            abstractButton2.addActionListener(actionListener);
        }
    }

    @Override
    protected JDesktopPane getDesktop() {
        return this.desktop;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void resetInfoLabel() {
        this.setInfoLabel("For help, press F1.");
    }

    public void setInfoLabel(String string) {
        this.infoLabel.setText(string);
    }

    @Override
    public ChildFrame getActiveChild() {
        MdiChildFrame mdiChildFrame = super.getActiveChild();
        return mdiChildFrame instanceof ChildFrame ? (ChildFrame)mdiChildFrame : null;
    }

    public DrawWindow getActiveDrawing() {
        MdiChildFrame mdiChildFrame = super.getActiveChild();
        return mdiChildFrame instanceof DrawWindow ? (DrawWindow)mdiChildFrame : null;
    }

    public void updateActiveFrameInfo() {
        String string;
        JInternalFrame jInternalFrame2 = this.desktop.getSelectedFrame();
        Collection<? extends JMenu> collection = null;
        Collection<? extends Component> collection2 = null;
        if (jInternalFrame2 == null) {
            string = "";
        } else {
            string = ObjTools.toStr(jInternalFrame2.getTitle(), "").trim();
            if (jInternalFrame2 instanceof ChildFrame) {
                collection = ((ChildFrame)jInternalFrame2).getMenus();
                collection2 = ((ChildFrame)jInternalFrame2).getToolbarButtons();
            }
        }
        if (string.length() == 0) {
            this.setTitle("Structure Editor");
        } else {
            this.setTitle("Structure Editor - " + string);
        }
        this.rebuildMainMenu(collection);
        this.rebuildToolBar(collection2);
        this.menuBar.revalidate();
        this.toolBar.revalidate();
        if (ObjTools.contains(this.desktop.getAllFrames(), jInternalFrame -> jInternalFrame instanceof ChildFrame)) {
            this.hideDashboard();
        } else {
            this.showDashboard(false);
        }
        this.repaint();
    }

    private void test() {
        final JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(true);
        jToolBar.add(new JButton("Hello there"));
        this.add((Component)jToolBar, "East");
        jToolBar.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (SwingUtilities.getWindowAncestor(jToolBar).equals(MainFrame.this)) {
                    System.out.println("...In Main Frame");
                } else {
                    System.out.println("...Maybe floating");
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                if (SwingUtilities.getWindowAncestor(jToolBar).equals(MainFrame.this)) {
                    System.out.println("...In Main Frame");
                } else {
                    System.out.println("...Maybe floating");
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    private void rebuildToolBar(Collection<? extends Component> collection) {
        JToolBar jToolBar = this.toolBar;
        if (this.originalToolbar == null) {
            this.originalToolbar = jToolBar.getComponents();
        }
        jToolBar.removeAll();
        Components.addAll((Container)jToolBar, this.originalToolbar);
        if (collection != null) {
            this.removeMnemonics(collection);
            Components.addAll((Container)jToolBar, collection);
        }
        this.menuMerger.sort(jToolBar);
        for (Component component : this.toolBar.getComponents()) {
            KeyStroke keyStroke;
            Action action;
            if (!(component instanceof AbstractButton)) continue;
            AbstractButton abstractButton = (AbstractButton)component;
            String string = abstractButton.getToolTipText();
            if (abstractButton.getIcon() != null && string != null) {
                abstractButton.setHideActionText(true);
            }
            if (string == null || string.indexOf(40) != -1 || (action = abstractButton.getAction()) == null || (keyStroke = UiAction.getKeyStroke(action)) == null) continue;
            abstractButton.setToolTipText(string + " (" + AcceleratorKey.toString(keyStroke) + ")");
        }
    }

    private void removeMnemonics(Collection<? extends Component> collection) {
        for (Component component : collection) {
            if (!(component instanceof AbstractButton)) continue;
            ((AbstractButton)component).setMnemonic(0);
        }
    }

    private void rebuildMainMenu(Collection<? extends Component> collection) {
        this.menuMerger.reset();
        if (collection != null) {
            this.menuMerger.merge((Component)this.menuBar, collection.toArray(new Component[collection.size()]));
        }
        this.menuMerger.sort(this.menuBar);
        if (OSInfo.isMac()) {
            this.removeMenuMnemonics(this.menuBar.getComponents());
        } else {
            this.verifyMenuMnemonics(this.menuBar.getComponents());
        }
    }

    private void removeMenuMnemonics(Component[] componentArray) {
        for (Component component : componentArray) {
            if (component instanceof AbstractButton) {
                ((AbstractButton)component).setMnemonic(0);
            }
            if (!(component instanceof Container)) continue;
            this.removeMenuMnemonics(((Container)component).getComponents());
        }
    }

    private void verifyMenuMnemonics(Component[] componentArray) {
        for (Component component : componentArray) {
            String string;
            AbstractButton abstractButton;
            if (component instanceof AbstractButton && (abstractButton = (AbstractButton)component).getMnemonic() == 0 && !Strings.isEmpty(string = abstractButton.getText())) {
                abstractButton.setMnemonic(string.charAt(0));
            }
            if (!(component instanceof Container)) continue;
            this.verifyMenuMnemonics(((Container)component).getComponents());
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        this.updateActiveFrameInfo();
        super.internalFrameClosed(internalFrameEvent);
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        this.updateActiveFrameInfo();
        super.internalFrameActivated(internalFrameEvent);
    }

    public JButton getToolBarItem(String string) {
        if (string == null) {
            return null;
        }
        for (Component component : this.toolBar.getComponents()) {
            if (!(component instanceof JButton) || !string.equals(component.getName())) continue;
            return (JButton)component;
        }
        for (Component component : this.toolBar.getComponents()) {
            if (!(component instanceof JButton) || !string.equals(((JButton)component).getText())) continue;
            return (JButton)component;
        }
        for (Component component : this.toolBar.getComponents()) {
            if (!(component instanceof JButton) || !string.equals(((JButton)component).getActionCommand())) continue;
            return (JButton)component;
        }
        if (this.log.isDebugEnabled()) {
            this.log.warn("Unknown Toolbar Item: " + string);
        }
        return null;
    }

    @Override
    protected void addChild(MdiChildFrame mdiChildFrame) {
        WindowsMenu.enableTabNext(mdiChildFrame);
        super.addChild(mdiChildFrame);
    }

    public void show(ChildFrame childFrame) {
        this.show(childFrame, null);
    }

    public void show(ChildFrame childFrame, Point point) {
        boolean bl;
        if (ObjTools.indexOf(this.desktop.getAllFrames(), childFrame) == -1) {
            this.addChild(childFrame);
        }
        if (point != null) {
            childFrame.setLocation(point);
        }
        boolean bl2 = bl = !childFrame.isMaximizable();
        if (!bl) {
            for (JInternalFrame jInternalFrame : this.getDesktop().getAllFrames()) {
                if (jInternalFrame == childFrame || jInternalFrame == this.dashboard || !jInternalFrame.isVisible() || jInternalFrame.isMaximum()) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            try {
                childFrame.setMaximum(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        childFrame.setVisible(true);
        if (this.getDesktop().getSelectedFrame() != childFrame) {
            this.activateChild(childFrame);
        }
    }

    public void showCentered(ChildFrame childFrame) {
        Dimension dimension = this.desktop.getSize();
        Dimension dimension2 = childFrame.getSize();
        this.hideDashboard();
        this.show(childFrame, new Point((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2));
    }

    public DashboardFrame getDashboard() {
        return this.dashboard;
    }

    public void showDashboard(boolean bl) {
        if (!bl && !this.program.settings().ShowDashboard) {
            return;
        }
        if (!ObjTools.contains(this.desktop.getAllFrames(), this.dashboard)) {
            this.desktop.add(this.dashboard);
        }
        this.dashboard.pack();
        this.dashboard.updateLayout();
        this.dashboard.show();
    }

    public void hideDashboard() {
        if (this.dashboard != null) {
            this.dashboard.hide();
            this.desktop.remove(this.dashboard);
        }
    }

    public List<ChildFrame> getChildFrames() {
        JInternalFrame[] jInternalFrameArray = this.getDesktop().getAllFrames();
        ArrayList<ChildFrame> arrayList = new ArrayList<ChildFrame>(jInternalFrameArray.length);
        for (JInternalFrame jInternalFrame : jInternalFrameArray) {
            if (!(jInternalFrame instanceof ChildFrame)) continue;
            arrayList.add((ChildFrame)jInternalFrame);
        }
        return arrayList;
    }
}

