/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import ur_rna.StructureEditor.Program;
import ur_rna.Utilities.ObjTools;
import ur_rna.Utilities.PathTools;
import ur_rna.Utilities.Strings;

public enum FileType {
    Report("Report File", "rep"),
    SHAPE("SHAPE File", "shape"),
    OligoList("Sequence List File", "lis;olis"),
    OUT("OUT File", "out"),
    PartitionSav("Partition Function Save File", "pfs"),
    DynalignSav("Dynalign Save File", "dsv"),
    FoldingSav("Folding Save File", "sav,save"),
    Alignment("Alignment File", "ali"),
    Constraints("Constraint File", "con"),
    DotPlot("Dot Plot File", "dp"),
    Fasta("FASTA File", "fasta;fa"),
    Seq("SEQ File", "seq"),
    SeqText("Sequence Text File", "txt"),
    SeqGenbank("Genbank Sequence File", "gen"),
    CT("CT File", "ct"),
    DotBracket("Bracket File", "dbn,bracket,dot"),
    Helix("Helix File", "helix;hlx;htxt"),
    NsdDrawing("Structure Drawing File", Program.DrawingFileExtension),
    CteDrawing("Extended CT Drawing File", "cte"),
    SVG("SVG - Scalable Vector Graphics File", "svg"),
    Postscript("Postscript File", "ps"),
    PNG("PNG Image File", "png"),
    GIF("GIF Image File", "gif"),
    JPEG("JPEG Image File", "jpg,jpeg"),
    Sequence("Sequence File", Fasta, Seq, SeqText),
    VectorImage("Vector Image File", SVG),
    Image("Image File", PNG, GIF, JPEG),
    Structure("Structure File", CT, DotBracket),
    Drawing("Structure Drawing", NsdDrawing, CteDrawing),
    AnyOpenable("Drawing, Structure, or Sequence File", Drawing, Structure, Sequence, PartitionSav, FoldingSav),
    AnySaveable("Any Save Type", Drawing, Structure, Sequence, VectorImage, Image);

    public static final List<FileType> allTypes;
    public static final List<FileType> primaryTypes;
    public static final Map<String, FileType> extMap;
    private final String description;
    private final String extensions;
    private final Set<FileType> subTypes;

    private FileType(String string2, FileType ... fileTypeArray) {
        this(string2, "", new LinkedHashSet<FileType>(Arrays.asList(fileTypeArray)));
    }

    private FileType(String string2, String string3) {
        this(string2, string3.trim().replace(',', ';').replace(' ', ';'), Collections.emptySet());
    }

    private FileType(String string2, String string3, Set<FileType> set) {
        this.description = string2;
        this.extensions = string3;
        this.subTypes = set;
        String string4 = null;
        if (string3 != null && !string3.isEmpty() && !set.isEmpty()) {
            string4 = "both";
        } else if ((string3 == null || string3.isEmpty()) && set.isEmpty()) {
            string4 = "neither";
        }
        if (string4 != null) {
            throw new IllegalStateException(String.format("A %s must either contain primary file extensions OR be composed of sub-types, but %s has %s, which is invalid.", FileType.class.getSimpleName(), this.name(), string4));
        }
    }

    public String[] getExtensions() {
        return this.extensions == null || this.extensions.isEmpty() ? ObjTools.EMPTY_STRING_ARRAY : this.extensions.split(";");
    }

    public String firstExtension() {
        return this.extensions == null || this.extensions.isEmpty() ? "" : this.extensions.split(";")[0];
    }

    public String getFilterString() {
        return this.getFilterString(false);
    }

    public String getFilterString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            this.addFilterString(stringBuilder);
        } else {
            stringBuilder.append(this.description).append('|');
            this.addExtensions(stringBuilder);
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public void addFilterString(StringBuilder stringBuilder) {
        if (!Strings.isEmpty(this.extensions)) {
            stringBuilder.append(this.description).append('|').append(this.extensions).append('|');
        }
        if (this.subTypes.size() != 0) {
            for (FileType fileType : this.subTypes) {
                fileType.addFilterString(stringBuilder);
            }
        }
    }

    private void addExtensions(StringBuilder stringBuilder) {
        if (!Strings.isEmpty(this.extensions)) {
            stringBuilder.append(this.extensions).append(';');
        }
        for (FileType fileType : this.subTypes) {
            fileType.addExtensions(stringBuilder);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public Set<FileType> subTypes() {
        return this.subTypes;
    }

    public boolean includes(FileType fileType) {
        if (this == fileType || this.subTypes().contains((Object)fileType)) {
            return true;
        }
        for (FileType fileType2 : this.subTypes()) {
            if (!fileType2.includes(fileType)) continue;
            return true;
        }
        return false;
    }

    public boolean isSubTypeOf(FileType ... fileTypeArray) {
        for (FileType fileType : fileTypeArray) {
            if (!fileType.includes(this)) continue;
            return true;
        }
        return false;
    }

    public static FileType fromExt(String string) {
        if (string.isEmpty() || string.equals(".")) {
            return null;
        }
        if (string.charAt(0) == '.') {
            string = string.substring(1);
        }
        return extMap.get(string.toLowerCase());
    }

    public static FileType fromFilter(FileFilter fileFilter) {
        if (fileFilter instanceof FileNameExtensionFilter) {
            for (String string : ((FileNameExtensionFilter)fileFilter).getExtensions()) {
                FileType fileType = FileType.fromExt(string);
                if (fileType == null) continue;
                return fileType;
            }
        }
        return FileType.fromDesc(fileFilter.getDescription());
    }

    public static FileType fromDesc(String string) {
        int n = string.indexOf(" (*.");
        if (n != -1) {
            string = string.substring(0, n);
        }
        string = string.trim();
        for (FileType fileType : allTypes) {
            if (!fileType.getDescription().equals(string)) continue;
            return fileType;
        }
        return null;
    }

    public static FileType fromName(String string) {
        if (string != null && !string.isEmpty()) {
            for (FileType fileType : allTypes) {
                if (!fileType.name().equals(string)) continue;
                return fileType;
            }
        }
        return null;
    }

    public static FileType fromAny(String string, String string2, String string3, String string4, FileType fileType) {
        FileType fileType2 = FileType.fromName(string);
        if (fileType2 != null) {
            return fileType2;
        }
        if (string2 != null) {
            fileType2 = FileType.fromExt(string2);
        }
        if (fileType2 != null) {
            return fileType2;
        }
        if (string3 != null) {
            fileType2 = FileType.fromDesc(string3);
        }
        if (fileType2 != null) {
            return fileType2;
        }
        if (string4 != null) {
            fileType2 = FileType.fromExt(PathTools.getExt(string4));
        }
        if (fileType2 != null) {
            return fileType2;
        }
        return fileType;
    }

    public String toString() {
        return this.getDescription();
    }

    static {
        FileType[] fileTypeArray = FileType.values();
        allTypes = Collections.unmodifiableList(Arrays.asList(fileTypeArray));
        ArrayList<FileType> arrayList = new ArrayList<FileType>();
        HashMap<String, FileType> hashMap = new HashMap<String, FileType>();
        for (FileType fileType : allTypes) {
            if (fileType.subTypes().size() != 0) continue;
            arrayList.add(fileType);
            for (String string : fileType.getExtensions()) {
                if (hashMap.containsKey(string = string.toLowerCase())) {
                    throw new IllegalStateException(String.format("The extension %1s is included by more than one primary %2s: %3s and %4s.", string, FileType.class.getSimpleName(), ((FileType)((Object)hashMap.get(string))).name(), fileType.name()));
                }
                hashMap.put(string, fileType);
            }
        }
        primaryTypes = Collections.unmodifiableList(arrayList);
        extMap = Collections.unmodifiableMap(hashMap);
    }
}

