/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import ur_rna.RNAstructure.RnaBackendException;
import ur_rna.StructureEditor.FileType;
import ur_rna.StructureEditor.MainFrame;
import ur_rna.StructureEditor.Program;
import ur_rna.StructureEditor.models.RnaScene;
import ur_rna.StructureEditor.models.RnaSceneGroup;
import ur_rna.StructureEditor.services.drawing.NucLayout;
import ur_rna.StructureEditor.services.fileIO.DrawingFileIO;
import ur_rna.StructureEditor.services.fileIO.RnaFileIO;
import ur_rna.StructureEditor.windows.AboutWindow;
import ur_rna.StructureEditor.windows.DashboardFrame;
import ur_rna.StructureEditor.windows.DrawWindow;
import ur_rna.StructureEditor.windows.NewFileWindow;
import ur_rna.Utilities.AppLog;
import ur_rna.Utilities.ExceptionHelper;
import ur_rna.Utilities.FormatterException;
import ur_rna.Utilities.ObjTools;
import ur_rna.Utilities.PathTools;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.SyntaxErrorException;
import ur_rna.Utilities.swing.Dialogs;
import ur_rna.Utilities.swing.FileDialog;
import ur_rna.Utilities.swing.UiAction;

public abstract class AppActions {
    private static Program _app;
    private static MainFrame _window;
    private static AppLog log;
    private static final String WEB_URL = "http://rna.urmc.rochester.edu/";
    private static final String HELP_URL = "http://rna.urmc.rochester.edu/GUI/html/StructureEditor.html";
    private static final String FEEDBACK_URL = "http://rna2.urmc.rochester.edu/RNAstructureWeb/feedback.php";
    private static final String FEEDBACK_SECRET = "18qY19wP21fR21uCuL1v";
    private static final String LOCAL_HELP_PAGE = "StructureEditor.html";
    private static final String[] LOCAL_HELP_URLS;
    public static final UiAction SHOW_ABOUT_WINDOW;
    public static final UiAction OPEN_WEBSITE;
    public static final UiAction SHOW_ONLINE_HELP;
    public static final UiAction SHOW_LOCAL_HELP;
    public static final UiAction SEND_FEEDBACK;
    public static final UiAction NEW_FILE;
    public static final UiAction SHOW_OPEN_FILE;
    public static final UiAction EXIT_PROGRAM;
    public static final UiAction SHOW_DASHBOARD;
    public static final UiAction CLEANUP_RECENT_FILES;
    public static final UiAction CLEAR_RECENT_FILES;

    protected static Program app() {
        return _app == null ? (_app = Program.getInstance()) : _app;
    }

    protected static MainFrame window() {
        return _window == null ? (_window = AppActions.app().getMainFrame()) : _window;
    }

    public static void exitApp() {
        AppActions.window().close();
    }

    public static void showAboutWindow() {
        AppActions.window().showCentered(new AboutWindow());
    }

    private static void browseLocalHelp() {
        for (String string : LOCAL_HELP_URLS) {
            File file = PathTools.findLocalPath(string + "/StructureEditor.html");
            if (file == null) continue;
            AppActions.browse(file.toURI().toString());
            return;
        }
        AppActions.browse(HELP_URL);
    }

    private static String urlenc(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    private static void sendFeedbackFromBrowser() {
        String string = FEEDBACK_URL;
        try {
            String string2;
            Object object;
            try {
                object = new URL("http://rna2.urmc.rochester.edu/RNAstructureWeb/feedback.php?action=get-token").openStream();
                try {
                    string2 = Strings.readAll((InputStream)object);
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                string2 = null;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(FEEDBACK_URL).append("?program=").append(AppActions.urlenc("Structure Editor")).append("&version=").append(AppActions.urlenc(Program.getVersion()));
            if (string2 != null) {
                ((StringBuilder)object).append("&passtoken=").append(AppActions.urlenc(string2)).append("&passresult=").append(Strings.md5(FEEDBACK_SECRET + string2));
            }
            string = ((StringBuilder)object).toString();
            Desktop.getDesktop().browse(new URI(string));
        }
        catch (Exception exception) {
            Dialogs.showWarning("error showing feedback webpage in browser.\nError: " + exception.toString() + "\nURL: " + string);
        }
    }

    public static void browse(String string) {
        try {
            Desktop.getDesktop().browse(new URI(string));
        }
        catch (Exception exception) {
            Dialogs.showWarning("error showing webpage in browser: " + string);
        }
    }

    public static void openFile(String string, String string2) {
        try {
            AppActions.openFile(string, FileType.fromAny(string2, null, null, string, FileType.AnyOpenable));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            Dialogs.showWarning("Unknown file type: " + string2);
        }
    }

    public static DrawWindow createEditorWindow(RnaSceneGroup rnaSceneGroup) {
        DrawWindow drawWindow = new DrawWindow();
        drawWindow.loadFile(rnaSceneGroup);
        AppActions.window().show(drawWindow);
        drawWindow.autoScale();
        drawWindow.controller.clearUndo();
        return drawWindow;
    }

    public static void createNewFile() {
        AppActions.window().showCentered(new NewFileWindow());
    }

    public static void showOpenFile() {
        String string = FileDialog.getOpenName(FileType.AnyOpenable.getFilterString() + "|*", null, "Open Drawing", "drawing", AppActions.window());
        if (string == null) {
            return;
        }
        AppActions.openFile(string, FileType.AnyOpenable);
    }

    public static void openFile(String string, FileType fileType) {
        try {
            if (fileType == null || fileType == FileType.AnyOpenable) {
                fileType = FileType.fromExt(PathTools.getExt(string));
            }
            if (fileType == null) {
                fileType = AppActions.showFileTypePrompt();
            }
            if (fileType == null) {
                return;
            }
            boolean bl = string.startsWith("example://");
            if (bl && (string = DashboardFrame.extractExample(string)) == null) {
                Dialogs.showWarning("The example file was not found or could not be read.");
                return;
            }
            RnaSceneGroup rnaSceneGroup = AppActions.readSceneFile(string, fileType);
            if (rnaSceneGroup != null) {
                if (bl) {
                    rnaSceneGroup.setSource(new File(string).getName(), fileType);
                } else {
                    AppActions.window().addRecentFile(string, fileType);
                }
                AppActions.createEditorWindow(rnaSceneGroup);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Dialogs.showWarning(AppActions.formatFileError("open", fileType, string, exception));
        }
    }

    public static FileType showFileTypePrompt() {
        Object[] objectArray = new Object[]{FileType.NsdDrawing, FileType.CteDrawing, FileType.CT, FileType.DotBracket, FileType.Sequence};
        return (FileType)((Object)JOptionPane.showInputDialog(Program.getInstance().getMainFrame(), "Please indicate the file type:", "Select File Type", 3, null, objectArray, (Object)FileType.NsdDrawing));
    }

    public static RnaSceneGroup readSceneFile(String string, FileType fileType) throws RnaBackendException, SyntaxErrorException, IOException {
        RnaSceneGroup rnaSceneGroup;
        System.out.printf("Reading file %s (%s)\n", new Object[]{string, fileType});
        if (fileType == null) {
            throw new IllegalArgumentException("File type is required.");
        }
        switch (fileType) {
            case Drawing: 
            case NsdDrawing: {
                rnaSceneGroup = DrawingFileIO.readNsdDrawingFile(string);
                break;
            }
            case CteDrawing: {
                rnaSceneGroup = DrawingFileIO.readCteDrawingFile(string);
                break;
            }
            case Structure: 
            case CT: {
                rnaSceneGroup = DrawingFileIO.readCteDrawingFile(string);
                AppActions.createLayout().redrawRadial(rnaSceneGroup);
                break;
            }
            case DotBracket: 
            case FoldingSav: 
            case PartitionSav: 
            case Sequence: 
            case Seq: 
            case Fasta: 
            case SeqText: {
                rnaSceneGroup = RnaFileIO.readFileAsScene(string, fileType);
                AppActions.createLayout().redrawRadial(rnaSceneGroup);
                break;
            }
            default: {
                throw new RuntimeException(String.format("%s cannot open %s as drawings.", "Structure Editor", fileType.getDescription()));
            }
        }
        rnaSceneGroup.setSource(string, fileType);
        return rnaSceneGroup;
    }

    private static NucLayout createLayout() {
        return new NucLayout(AppActions.app().settings().getDrawSettings());
    }

    public static boolean writeFile(RnaSceneGroup rnaSceneGroup, String string, FileType fileType, boolean bl, boolean bl2) throws IOException, RnaBackendException, FormatterException {
        boolean bl3;
        FileType fileType2 = rnaSceneGroup.getFileType();
        boolean bl4 = bl3 = fileType2 == FileType.AnyOpenable;
        if (fileType == null) {
            throw new IllegalArgumentException("File type is required.");
        }
        switch (fileType) {
            case NsdDrawing: {
                DrawingFileIO.writeNsdDrawingFile(rnaSceneGroup, string, bl2);
                bl3 |= fileType2.isSubTypeOf(FileType.NsdDrawing, FileType.Structure, FileType.Sequence);
                break;
            }
            case CteDrawing: {
                DrawingFileIO.writeCteDrawingFile(rnaSceneGroup, string, bl2);
                bl3 |= fileType2.isSubTypeOf(FileType.CteDrawing, FileType.Structure, FileType.Sequence);
                break;
            }
            case CT: 
            case DotBracket: {
                new RnaFileIO();
                RnaFileIO.writeStructureFile(rnaSceneGroup, string, fileType, bl2);
                bl3 |= fileType2.isSubTypeOf(FileType.Structure, FileType.Sequence);
                break;
            }
            case Seq: 
            case Fasta: 
            case SeqText: {
                new RnaFileIO();
                RnaFileIO.writeSequenceFile((RnaScene)rnaSceneGroup.get(0), string, fileType, bl2);
                bl3 |= FileType.Sequence.includes(fileType2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Programming Error: writeFile cannot handle files of type: " + fileType);
            }
        }
        if (bl3 && !bl) {
            rnaSceneGroup.setSource(string, fileType);
        }
        return true;
    }

    public static String formatFileError(String string, FileType fileType, String string2, Exception exception) {
        File file = new File(string2);
        Object object = String.format("Failed to %s %s \"%s\":\n\n%s\n\nFull Path: %s", string, fileType == null ? "File" : fileType.getDescription(), file.getName(), ExceptionHelper.getMessage(exception).trim().replace("Error opening file: ", "").replace("Error saving file: ", ""), PathTools.getCanonicalPath(file));
        if (ObjTools.asBool(System.getProperty("debug"))) {
            object = (String)object + "\n\n\n\nError Stack Trace (for debugging):\n" + ExceptionHelper.getStackTrace(exception);
        }
        return object;
    }

    static {
        log = AppLog.getDefault();
        LOCAL_HELP_URLS = new String[]{"manual/html", "manual/GUI/html"};
        SHOW_ABOUT_WINDOW = new UiAction("About", AppActions::showAboutWindow, (Icon)Program.getIcon("help-about"));
        OPEN_WEBSITE = new UiAction("Mathews Lab &Website", actionEvent -> AppActions.browse(WEB_URL));
        SHOW_ONLINE_HELP = new UiAction("&Online Help", actionEvent -> AppActions.browse(HELP_URL));
        SHOW_LOCAL_HELP = new UiAction("Program &Help", AppActions::browseLocalHelp, (Icon)Program.getIcon("help-docs"));
        SEND_FEEDBACK = new UiAction("Send &Feedback or Bug Report", AppActions::sendFeedbackFromBrowser, (Icon)Program.getIcon("help-feedback"));
        NEW_FILE = new UiAction("&New File (enter sequence...)", AppActions::createNewFile, (Icon)Program.getIcon("file-new"));
        SHOW_OPEN_FILE = new UiAction("&Open File", AppActions::showOpenFile, (Icon)Program.getIcon("file-open"));
        EXIT_PROGRAM = new UiAction("&Exit", AppActions::exitApp);
        SHOW_DASHBOARD = new UiAction("&Home", actionEvent -> AppActions.window().showDashboard(true));
        CLEANUP_RECENT_FILES = new UiAction("&Remove missing files", actionEvent -> AppActions.window().cleanRecent(false), (Icon)Program.getIcon("clear-recent"));
        CLEAR_RECENT_FILES = new UiAction("&Remove ALL recent files", actionEvent -> AppActions.window().cleanRecent(true), (Icon)Program.getIcon("delete"));
        SHOW_OPEN_FILE.setDesc("Browse to open a Drawing, Structure, or Sequence file.").setKeyStroke("*o");
        NEW_FILE.setDesc("Create a new drawing by entering a sequence and optional base pairing information.").setKeyStroke("*N");
        EXIT_PROGRAM.setDesc("Close all open windows and exit the program.").setKeyStroke("*+w");
        SHOW_ONLINE_HELP.setKeyStroke("+F1");
        SHOW_LOCAL_HELP.setKeyStroke("F1");
    }
}

